/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.hadoop.format;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.coders.IterableCoder;
import org.apache.beam.sdk.coders.ListCoder;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;

class IterableCombinerFn<T>
extends Combine.AccumulatingCombineFn<T, CollectionAccumulator<T>, Iterable<T>> {
    private final TypeDescriptor<T> typeDescriptor;

    IterableCombinerFn(TypeDescriptor<T> typeDescriptor) {
        this.typeDescriptor = typeDescriptor;
    }

    public CollectionAccumulator<T> createAccumulator() {
        return new CollectionAccumulator();
    }

    public TypeDescriptor<Iterable<T>> getOutputType() {
        return TypeDescriptors.iterables(this.typeDescriptor);
    }

    public Coder<Iterable<T>> getDefaultOutputCoder(CoderRegistry registry, Coder<T> inputCoder) {
        return IterableCoder.of(inputCoder);
    }

    public Coder<CollectionAccumulator<T>> getAccumulatorCoder(CoderRegistry registry, Coder<T> inputCoder) {
        return new CollectionAccumulatorCoder(inputCoder);
    }

    private static class CollectionAccumulatorCoder<T>
    extends AtomicCoder<CollectionAccumulator<T>> {
        private final ListCoder<T> listCoder;

        private CollectionAccumulatorCoder(Coder<T> typeCoder) {
            this.listCoder = ListCoder.of(typeCoder);
        }

        public void encode(CollectionAccumulator<T> value, OutputStream outStream) throws IOException {
            this.listCoder.encode((Iterable)((CollectionAccumulator)value).collection, outStream);
        }

        public CollectionAccumulator<T> decode(InputStream inStream) throws IOException {
            List decodedList = (List)this.listCoder.decode(inStream);
            return new CollectionAccumulator(decodedList);
        }
    }

    public static class CollectionAccumulator<T>
    implements Combine.AccumulatingCombineFn.Accumulator<T, CollectionAccumulator<T>, Iterable<T>> {
        private final List<T> collection;

        private CollectionAccumulator() {
            this(new ArrayList());
        }

        private CollectionAccumulator(List<T> collection) {
            Objects.requireNonNull(collection, "Collection can't be null");
            this.collection = collection;
        }

        public void addInput(T input) {
            this.collection.add(input);
        }

        public void mergeAccumulator(CollectionAccumulator<T> other) {
            this.collection.addAll(other.collection);
        }

        public Iterable<T> extractOutput() {
            return this.collection;
        }
    }
}

