/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.hdfs;

import java.net.URI;
import java.util.Objects;
import org.apache.beam.repackaged.beam_sdks_java_io_hadoop_file_system.com.google.common.base.Preconditions;
import org.apache.beam.sdk.io.fs.ResolveOptions;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.hadoop.fs.Path;

class HadoopResourceId
implements ResourceId {
    private final URI uri;

    HadoopResourceId(URI uri) {
        this.uri = uri;
    }

    public ResourceId resolve(String other, ResolveOptions resolveOptions) {
        if (resolveOptions == ResolveOptions.StandardResolveOptions.RESOLVE_DIRECTORY) {
            if (!other.endsWith("/")) {
                other = other + "/";
            }
            return new HadoopResourceId(this.uri.resolve(other));
        }
        if (resolveOptions == ResolveOptions.StandardResolveOptions.RESOLVE_FILE) {
            Preconditions.checkArgument(!other.endsWith("/"), "Resolving a file with a directory path: %s", (Object)other);
            return new HadoopResourceId(this.uri.resolve(other));
        }
        throw new UnsupportedOperationException(String.format("Unexpected StandardResolveOptions %s", resolveOptions));
    }

    public ResourceId getCurrentDirectory() {
        return new HadoopResourceId(this.uri.getPath().endsWith("/") ? this.uri : this.uri.resolve("."));
    }

    public boolean isDirectory() {
        return this.uri.getPath().endsWith("/");
    }

    public String getFilename() {
        return new Path(this.uri).getName();
    }

    public String getScheme() {
        return this.uri.getScheme();
    }

    public String toString() {
        return this.uri.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof HadoopResourceId)) {
            return false;
        }
        return Objects.equals(this.uri, ((HadoopResourceId)obj).uri);
    }

    public int hashCode() {
        return Objects.hashCode(this.uri);
    }

    Path toPath() {
        return new Path(this.uri);
    }
}

