/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.hdfs;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.DefaultValueFactory;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.vendor.guava.v20_0.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v20_0.com.google.common.base.Strings;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v20_0.com.google.common.collect.Sets;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental(value=Experimental.Kind.FILESYSTEM)
public interface HadoopFileSystemOptions
extends PipelineOptions {
    @Description(value="A list of Hadoop configurations used to configure zero or more Hadoop filesystems. By default, Hadoop configuration is loaded from 'core-site.xml' and 'hdfs-site.xml' based upon the HADOOP_CONF_DIR and YARN_CONF_DIR environment variables. To specify configuration on the command-line, represent the value as a JSON list of JSON maps, where each map represents the entire configuration for a single Hadoop filesystem. For example --hdfsConfiguration='[{\"fs.default.name\": \"hdfs://localhost:9998\", ...},{\"fs.default.name\": \"s3a://\", ...},...]'")
    @Default.InstanceFactory(value=ConfigurationLocator.class)
    public List<Configuration> getHdfsConfiguration();

    public void setHdfsConfiguration(List<Configuration> var1);

    public static class ConfigurationLocator
    implements DefaultValueFactory<List<Configuration>> {
        private static final Logger LOG = LoggerFactory.getLogger(ConfigurationLocator.class);

        public List<Configuration> create(PipelineOptions options) {
            List<Configuration> configurationList = this.readConfigurationFromHadoopYarnConfigDirs();
            return configurationList.size() > 0 ? configurationList : null;
        }

        private List<Configuration> readConfigurationFromHadoopYarnConfigDirs() {
            ArrayList configurationList = Lists.newArrayList();
            HashSet confDirs = Sets.newHashSet();
            for (String confDir : Lists.newArrayList((Object[])new String[]{"HADOOP_CONF_DIR", "YARN_CONF_DIR"})) {
                String hadoopConfDir;
                if (!this.getEnvironment().containsKey(confDir) || Strings.isNullOrEmpty((String)(hadoopConfDir = this.getEnvironment().get(confDir)))) continue;
                confDirs.add(hadoopConfDir);
            }
            for (String confDir : confDirs) {
                if (!new File(confDir).exists()) continue;
                Configuration conf = new Configuration(false);
                boolean confLoaded = false;
                for (String confName : Lists.newArrayList((Object[])new String[]{"core-site.xml", "hdfs-site.xml"})) {
                    File confFile = new File(confDir, confName);
                    if (!confFile.exists()) continue;
                    LOG.debug("Adding {} to hadoop configuration", (Object)confFile.getAbsolutePath());
                    conf.addResource(new Path(confFile.getAbsolutePath()));
                    confLoaded = true;
                }
                if (!confLoaded) continue;
                configurationList.add(conf);
            }
            return configurationList;
        }

        @VisibleForTesting
        Map<String, String> getEnvironment() {
            return System.getenv();
        }
    }
}

