/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner;

import com.google.auto.value.AutoValue;
import com.google.cloud.spanner.BatchReadOnlyTransaction;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.TimestampBound;
import com.google.common.annotations.VisibleForTesting;
import javax.annotation.Nullable;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.io.gcp.spanner.AutoValue_NaiveSpannerRead;
import org.apache.beam.sdk.io.gcp.spanner.ReadOperation;
import org.apache.beam.sdk.io.gcp.spanner.SpannerAccessor;
import org.apache.beam.sdk.io.gcp.spanner.SpannerConfig;
import org.apache.beam.sdk.io.gcp.spanner.SpannerIO;
import org.apache.beam.sdk.io.gcp.spanner.Transaction;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;

@VisibleForTesting
@AutoValue
abstract class NaiveSpannerRead
extends PTransform<PCollection<ReadOperation>, PCollection<Struct>> {
    NaiveSpannerRead() {
    }

    public static NaiveSpannerRead create(SpannerConfig spannerConfig, PCollectionView<Transaction> txView, TimestampBound timestampBound) {
        return new AutoValue_NaiveSpannerRead(spannerConfig, txView, timestampBound);
    }

    abstract SpannerConfig getSpannerConfig();

    @Nullable
    abstract PCollectionView<Transaction> getTxView();

    abstract TimestampBound getTimestampBound();

    public PCollection<Struct> expand(PCollection<ReadOperation> input) {
        PCollectionView txView = this.getTxView();
        if (txView == null) {
            Pipeline begin = input.getPipeline();
            SpannerIO.CreateTransaction createTx = SpannerIO.createTransaction().withSpannerConfig(this.getSpannerConfig()).withTimestampBound(this.getTimestampBound());
            txView = (PCollectionView)begin.apply((PTransform)createTx);
        }
        return (PCollection)input.apply("Naive read from Cloud Spanner", (PTransform)ParDo.of((DoFn)new NaiveSpannerReadFn(this.getSpannerConfig(), txView)).withSideInputs(new PCollectionView[]{txView}));
    }

    private static class NaiveSpannerReadFn
    extends DoFn<ReadOperation, Struct> {
        private final SpannerConfig config;
        @Nullable
        private final PCollectionView<Transaction> txView;
        private transient SpannerAccessor spannerAccessor;

        NaiveSpannerReadFn(SpannerConfig config, @Nullable PCollectionView<Transaction> transaction) {
            this.config = config;
            this.txView = transaction;
        }

        @DoFn.Setup
        public void setup() throws Exception {
            this.spannerAccessor = this.config.connectToSpanner();
        }

        @DoFn.Teardown
        public void teardown() throws Exception {
            this.spannerAccessor.close();
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) throws Exception {
            Transaction tx = (Transaction)c.sideInput(this.txView);
            ReadOperation op = (ReadOperation)c.element();
            BatchReadOnlyTransaction context = this.spannerAccessor.getBatchClient().batchReadOnlyTransaction(tx.transactionId());
            try (ResultSet resultSet = this.execute(op, context);){
                while (resultSet.next()) {
                    c.output((Object)resultSet.getCurrentRowAsStruct());
                }
            }
        }

        private ResultSet execute(ReadOperation op, BatchReadOnlyTransaction readOnlyTransaction) {
            if (op.getQuery() != null) {
                return readOnlyTransaction.executeQuery(op.getQuery(), new Options.QueryOption[0]);
            }
            if (op.getIndex() != null) {
                return readOnlyTransaction.readUsingIndex(op.getTable(), op.getIndex(), op.getKeySet(), op.getColumns(), new Options.ReadOption[0]);
            }
            return readOnlyTransaction.read(op.getTable(), op.getKeySet(), op.getColumns(), new Options.ReadOption[0]);
        }
    }
}

