/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner;

import java.util.List;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.gcp.spanner.SpannerConfig;
import org.apache.beam.sdk.io.gcp.spanner.SpannerIO;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;

final class AutoValue_SpannerIO_Write
extends SpannerIO.Write {
    private final SpannerConfig spannerConfig;
    private final long batchSizeBytes;
    private final long maxNumMutations;
    private final int numSamples;
    private final SpannerIO.FailureMode failureMode;
    private final PTransform<PCollection<KV<String, byte[]>>, PCollection<KV<String, List<byte[]>>>> sampler;

    private AutoValue_SpannerIO_Write(SpannerConfig spannerConfig, long batchSizeBytes, long maxNumMutations, int numSamples, SpannerIO.FailureMode failureMode, @Nullable PTransform<PCollection<KV<String, byte[]>>, PCollection<KV<String, List<byte[]>>>> sampler) {
        this.spannerConfig = spannerConfig;
        this.batchSizeBytes = batchSizeBytes;
        this.maxNumMutations = maxNumMutations;
        this.numSamples = numSamples;
        this.failureMode = failureMode;
        this.sampler = sampler;
    }

    @Override
    SpannerConfig getSpannerConfig() {
        return this.spannerConfig;
    }

    @Override
    long getBatchSizeBytes() {
        return this.batchSizeBytes;
    }

    @Override
    long getMaxNumMutations() {
        return this.maxNumMutations;
    }

    @Override
    int getNumSamples() {
        return this.numSamples;
    }

    @Override
    SpannerIO.FailureMode getFailureMode() {
        return this.failureMode;
    }

    @Override
    @Nullable
    PTransform<PCollection<KV<String, byte[]>>, PCollection<KV<String, List<byte[]>>>> getSampler() {
        return this.sampler;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SpannerIO.Write) {
            SpannerIO.Write that = (SpannerIO.Write)((Object)o);
            return this.spannerConfig.equals(that.getSpannerConfig()) && this.batchSizeBytes == that.getBatchSizeBytes() && this.maxNumMutations == that.getMaxNumMutations() && this.numSamples == that.getNumSamples() && this.failureMode.equals((Object)that.getFailureMode()) && (this.sampler == null ? that.getSampler() == null : this.sampler.equals(that.getSampler()));
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.spannerConfig.hashCode();
        h *= 1000003;
        h ^= (int)(this.batchSizeBytes >>> 32 ^ this.batchSizeBytes);
        h *= 1000003;
        h ^= (int)(this.maxNumMutations >>> 32 ^ this.maxNumMutations);
        h *= 1000003;
        h ^= this.numSamples;
        h *= 1000003;
        h ^= this.failureMode.hashCode();
        h *= 1000003;
        return h ^= this.sampler == null ? 0 : this.sampler.hashCode();
    }

    @Override
    SpannerIO.Write.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends SpannerIO.Write.Builder {
        private SpannerConfig spannerConfig;
        private Long batchSizeBytes;
        private Long maxNumMutations;
        private Integer numSamples;
        private SpannerIO.FailureMode failureMode;
        private PTransform<PCollection<KV<String, byte[]>>, PCollection<KV<String, List<byte[]>>>> sampler;

        Builder() {
        }

        private Builder(SpannerIO.Write source) {
            this.spannerConfig = source.getSpannerConfig();
            this.batchSizeBytes = source.getBatchSizeBytes();
            this.maxNumMutations = source.getMaxNumMutations();
            this.numSamples = source.getNumSamples();
            this.failureMode = source.getFailureMode();
            this.sampler = source.getSampler();
        }

        @Override
        SpannerIO.Write.Builder setSpannerConfig(SpannerConfig spannerConfig) {
            if (spannerConfig == null) {
                throw new NullPointerException("Null spannerConfig");
            }
            this.spannerConfig = spannerConfig;
            return this;
        }

        @Override
        SpannerIO.Write.Builder setBatchSizeBytes(long batchSizeBytes) {
            this.batchSizeBytes = batchSizeBytes;
            return this;
        }

        @Override
        SpannerIO.Write.Builder setMaxNumMutations(long maxNumMutations) {
            this.maxNumMutations = maxNumMutations;
            return this;
        }

        @Override
        SpannerIO.Write.Builder setNumSamples(int numSamples) {
            this.numSamples = numSamples;
            return this;
        }

        @Override
        SpannerIO.Write.Builder setFailureMode(SpannerIO.FailureMode failureMode) {
            if (failureMode == null) {
                throw new NullPointerException("Null failureMode");
            }
            this.failureMode = failureMode;
            return this;
        }

        @Override
        SpannerIO.Write.Builder setSampler(@Nullable PTransform<PCollection<KV<String, byte[]>>, PCollection<KV<String, List<byte[]>>>> sampler) {
            this.sampler = sampler;
            return this;
        }

        @Override
        SpannerIO.Write build() {
            String missing = "";
            if (this.spannerConfig == null) {
                missing = missing + " spannerConfig";
            }
            if (this.batchSizeBytes == null) {
                missing = missing + " batchSizeBytes";
            }
            if (this.maxNumMutations == null) {
                missing = missing + " maxNumMutations";
            }
            if (this.numSamples == null) {
                missing = missing + " numSamples";
            }
            if (this.failureMode == null) {
                missing = missing + " failureMode";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_SpannerIO_Write(this.spannerConfig, this.batchSizeBytes, this.maxNumMutations, this.numSamples, this.failureMode, this.sampler);
        }
    }
}

