/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import javax.annotation.Nullable;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.beam.sdk.extensions.avro.schemas.utils.AvroUtils;
import org.apache.beam.sdk.io.gcp.bigquery.AvroGenericRecordToStorageApiProto;
import org.apache.beam.sdk.io.gcp.bigquery.AvroWriteRequest;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryUtils;
import org.apache.beam.sdk.io.gcp.bigquery.DynamicDestinations;
import org.apache.beam.sdk.io.gcp.bigquery.RowMutationInformation;
import org.apache.beam.sdk.io.gcp.bigquery.StorageApiDynamicDestinations;
import org.apache.beam.sdk.io.gcp.bigquery.StorageApiWritePayload;
import org.apache.beam.sdk.io.gcp.bigquery.TableRowToStorageApiProto;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class StorageApiDynamicDestinationsGenericRecord<@UnknownKeyFor T, @UnknownKeyFor DestinationT>
extends StorageApiDynamicDestinations<T, DestinationT> {
    private final @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized AvroWriteRequest<T>, @UnknownKeyFor @NonNull @Initialized GenericRecord> toGenericRecord;
    private final @UnknownKeyFor @NonNull @Initialized SerializableFunction<@org.checkerframework.checker.nullness.qual.Nullable @UnknownKeyFor @Initialized TableSchema, @UnknownKeyFor @NonNull @Initialized Schema> schemaFactory;
    private final @org.checkerframework.checker.nullness.qual.Nullable @UnknownKeyFor @Initialized BigQueryIO.TableRowFormatFunction<T> formatRecordOnFailureFunction;
    private @UnknownKeyFor @NonNull @Initialized boolean usesCdc;

    StorageApiDynamicDestinationsGenericRecord(@UnknownKeyFor @NonNull @Initialized DynamicDestinations<T, DestinationT> inner, @UnknownKeyFor @NonNull @Initialized SerializableFunction<@org.checkerframework.checker.nullness.qual.Nullable @UnknownKeyFor @Initialized TableSchema, @UnknownKeyFor @NonNull @Initialized Schema> schemaFactory, @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized AvroWriteRequest<T>, @UnknownKeyFor @NonNull @Initialized GenericRecord> toGenericRecord, @org.checkerframework.checker.nullness.qual.Nullable @UnknownKeyFor @Initialized BigQueryIO.TableRowFormatFunction<T> formatRecordOnFailureFunction, @UnknownKeyFor @NonNull @Initialized boolean usesCdc) {
        super(inner);
        this.toGenericRecord = toGenericRecord;
        this.schemaFactory = schemaFactory;
        this.formatRecordOnFailureFunction = formatRecordOnFailureFunction;
        this.usesCdc = usesCdc;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized StorageApiDynamicDestinations.MessageConverter<T> getMessageConverter(DestinationT destination,  @UnknownKeyFor @NonNull @Initialized BigQueryServices.DatasetService datasetService) throws @UnknownKeyFor @NonNull @Initialized Exception {
        return new GenericRecordConverter(destination);
    }

    class GenericRecordConverter
    implements StorageApiDynamicDestinations.MessageConverter<T> {
        final @UnknownKeyFor @NonNull @Initialized com.google.cloud.bigquery.storage.v1.TableSchema protoTableSchema;
        final @UnknownKeyFor @NonNull @Initialized Schema avroSchema;
        final @UnknownKeyFor @NonNull @Initialized TableSchema bqTableSchema;
        final // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized Descriptors.Descriptor descriptor;
        @Nullable
        final // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Descriptors.Descriptor cdcDescriptor;

        GenericRecordConverter(DestinationT destination) throws @UnknownKeyFor @NonNull @Initialized Exception {
            this.avroSchema = (Schema)StorageApiDynamicDestinationsGenericRecord.this.schemaFactory.apply((Object)StorageApiDynamicDestinationsGenericRecord.this.getSchema(destination));
            this.bqTableSchema = BigQueryUtils.toTableSchema(AvroUtils.toBeamSchema((Schema)this.avroSchema));
            this.protoTableSchema = AvroGenericRecordToStorageApiProto.protoTableSchemaFromAvroSchema(this.avroSchema);
            this.descriptor = TableRowToStorageApiProto.getDescriptorFromTableSchema(this.protoTableSchema, true, false);
            this.cdcDescriptor = StorageApiDynamicDestinationsGenericRecord.this.usesCdc ? TableRowToStorageApiProto.getDescriptorFromTableSchema(this.protoTableSchema, true, true) : null;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized StorageApiWritePayload toMessage(T element, @org.checkerframework.checker.nullness.qual.Nullable @UnknownKeyFor @Initialized RowMutationInformation rowMutationInformation) throws @UnknownKeyFor @NonNull @Initialized Exception {
            String changeType = null;
            String changeSequenceNum = null;
            Descriptors.Descriptor descriptorToUse = this.descriptor;
            if (rowMutationInformation != null) {
                changeType = rowMutationInformation.getMutationType().toString();
                changeSequenceNum = rowMutationInformation.getChangeSequenceNumber();
                descriptorToUse = this.cdcDescriptor;
            }
            DynamicMessage msg = AvroGenericRecordToStorageApiProto.messageFromGenericRecord(descriptorToUse, (GenericRecord)StorageApiDynamicDestinationsGenericRecord.this.toGenericRecord.apply(new AvroWriteRequest(element, this.avroSchema)), changeType, changeSequenceNum);
            return StorageApiWritePayload.of(msg.toByteArray(), null, StorageApiDynamicDestinationsGenericRecord.this.formatRecordOnFailureFunction != null ? this.toFailsafeTableRow(element) : null);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized TableRow toFailsafeTableRow(T element) {
            if (StorageApiDynamicDestinationsGenericRecord.this.formatRecordOnFailureFunction != null) {
                return (TableRow)StorageApiDynamicDestinationsGenericRecord.this.formatRecordOnFailureFunction.apply(null, element);
            }
            return BigQueryUtils.convertGenericRecordToTableRow((GenericRecord)StorageApiDynamicDestinationsGenericRecord.this.toGenericRecord.apply(new AvroWriteRequest(element, this.avroSchema)), this.bqTableSchema);
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized com.google.cloud.bigquery.storage.v1.TableSchema getTableSchema() {
            return this.protoTableSchema;
        }

        @Override
        public // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized DescriptorProtos.DescriptorProto getDescriptor(@UnknownKeyFor @NonNull @Initialized boolean includeCdcColumns) throws @UnknownKeyFor @NonNull @Initialized Exception {
            return this.cdcDescriptor != null ? this.cdcDescriptor.toProto() : this.descriptor.toProto();
        }
    }
}

