/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.cloud.bigquery.storage.v1.DataFormat;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.SchemaAndRecord;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.errorhandling.BadRecord;
import org.apache.beam.sdk.transforms.errorhandling.BadRecordRouter;
import org.apache.beam.sdk.transforms.errorhandling.ErrorHandler;
import org.checkerframework.checker.nullness.qual.Nullable;

final class AutoValue_BigQueryIO_DynamicRead<T>
extends BigQueryIO.DynamicRead<T> {
    private final BigQueryServices bigQueryServices;
    private final DataFormat format;
    private final @Nullable SerializableFunction<SchemaAndRecord, T> parseFn;
    private final @Nullable Coder<T> outputCoder;
    private final boolean projectionPushdownApplied;
    private final BadRecordRouter badRecordRouter;
    private final ErrorHandler<BadRecord, ?> badRecordErrorHandler;
    private final @Nullable String queryLocation;
    private final @Nullable String queryTempDataset;
    private final @Nullable String queryTempProject;
    private final @Nullable String kmsKey;

    private AutoValue_BigQueryIO_DynamicRead(BigQueryServices bigQueryServices, DataFormat format, @Nullable SerializableFunction<SchemaAndRecord, T> parseFn, @Nullable Coder<T> outputCoder, boolean projectionPushdownApplied, BadRecordRouter badRecordRouter, ErrorHandler<BadRecord, ?> badRecordErrorHandler, @Nullable String queryLocation, @Nullable String queryTempDataset, @Nullable String queryTempProject, @Nullable String kmsKey) {
        this.bigQueryServices = bigQueryServices;
        this.format = format;
        this.parseFn = parseFn;
        this.outputCoder = outputCoder;
        this.projectionPushdownApplied = projectionPushdownApplied;
        this.badRecordRouter = badRecordRouter;
        this.badRecordErrorHandler = badRecordErrorHandler;
        this.queryLocation = queryLocation;
        this.queryTempDataset = queryTempDataset;
        this.queryTempProject = queryTempProject;
        this.kmsKey = kmsKey;
    }

    @Override
    BigQueryServices getBigQueryServices() {
        return this.bigQueryServices;
    }

    @Override
    DataFormat getFormat() {
        return this.format;
    }

    @Override
    @Nullable SerializableFunction<SchemaAndRecord, T> getParseFn() {
        return this.parseFn;
    }

    @Override
    @Nullable Coder<T> getOutputCoder() {
        return this.outputCoder;
    }

    @Override
    boolean getProjectionPushdownApplied() {
        return this.projectionPushdownApplied;
    }

    @Override
    BadRecordRouter getBadRecordRouter() {
        return this.badRecordRouter;
    }

    @Override
    ErrorHandler<BadRecord, ?> getBadRecordErrorHandler() {
        return this.badRecordErrorHandler;
    }

    @Override
    @Nullable String getQueryLocation() {
        return this.queryLocation;
    }

    @Override
    @Nullable String getQueryTempDataset() {
        return this.queryTempDataset;
    }

    @Override
    @Nullable String getQueryTempProject() {
        return this.queryTempProject;
    }

    @Override
    @Nullable String getKmsKey() {
        return this.kmsKey;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof BigQueryIO.DynamicRead) {
            BigQueryIO.DynamicRead that = (BigQueryIO.DynamicRead)((Object)o);
            return this.bigQueryServices.equals(that.getBigQueryServices()) && this.format.equals((Object)that.getFormat()) && (this.parseFn == null ? that.getParseFn() == null : this.parseFn.equals(that.getParseFn())) && (this.outputCoder == null ? that.getOutputCoder() == null : this.outputCoder.equals(that.getOutputCoder())) && this.projectionPushdownApplied == that.getProjectionPushdownApplied() && this.badRecordRouter.equals(that.getBadRecordRouter()) && this.badRecordErrorHandler.equals(that.getBadRecordErrorHandler()) && (this.queryLocation == null ? that.getQueryLocation() == null : this.queryLocation.equals(that.getQueryLocation())) && (this.queryTempDataset == null ? that.getQueryTempDataset() == null : this.queryTempDataset.equals(that.getQueryTempDataset())) && (this.queryTempProject == null ? that.getQueryTempProject() == null : this.queryTempProject.equals(that.getQueryTempProject())) && (this.kmsKey == null ? that.getKmsKey() == null : this.kmsKey.equals(that.getKmsKey()));
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.bigQueryServices.hashCode();
        h$ *= 1000003;
        h$ ^= this.format.hashCode();
        h$ *= 1000003;
        h$ ^= this.parseFn == null ? 0 : this.parseFn.hashCode();
        h$ *= 1000003;
        h$ ^= this.outputCoder == null ? 0 : this.outputCoder.hashCode();
        h$ *= 1000003;
        h$ ^= this.projectionPushdownApplied ? 1231 : 1237;
        h$ *= 1000003;
        h$ ^= this.badRecordRouter.hashCode();
        h$ *= 1000003;
        h$ ^= this.badRecordErrorHandler.hashCode();
        h$ *= 1000003;
        h$ ^= this.queryLocation == null ? 0 : this.queryLocation.hashCode();
        h$ *= 1000003;
        h$ ^= this.queryTempDataset == null ? 0 : this.queryTempDataset.hashCode();
        h$ *= 1000003;
        h$ ^= this.queryTempProject == null ? 0 : this.queryTempProject.hashCode();
        h$ *= 1000003;
        return h$ ^= this.kmsKey == null ? 0 : this.kmsKey.hashCode();
    }

    @Override
    BigQueryIO.DynamicRead.Builder<T> toBuilder() {
        return new Builder(this);
    }

    static final class Builder<T>
    extends BigQueryIO.DynamicRead.Builder<T> {
        private BigQueryServices bigQueryServices;
        private DataFormat format;
        private @Nullable SerializableFunction<SchemaAndRecord, T> parseFn;
        private @Nullable Coder<T> outputCoder;
        private Boolean projectionPushdownApplied;
        private BadRecordRouter badRecordRouter;
        private ErrorHandler<BadRecord, ?> badRecordErrorHandler;
        private @Nullable String queryLocation;
        private @Nullable String queryTempDataset;
        private @Nullable String queryTempProject;
        private @Nullable String kmsKey;

        Builder() {
        }

        private Builder(BigQueryIO.DynamicRead<T> source) {
            this.bigQueryServices = source.getBigQueryServices();
            this.format = source.getFormat();
            this.parseFn = source.getParseFn();
            this.outputCoder = source.getOutputCoder();
            this.projectionPushdownApplied = source.getProjectionPushdownApplied();
            this.badRecordRouter = source.getBadRecordRouter();
            this.badRecordErrorHandler = source.getBadRecordErrorHandler();
            this.queryLocation = source.getQueryLocation();
            this.queryTempDataset = source.getQueryTempDataset();
            this.queryTempProject = source.getQueryTempProject();
            this.kmsKey = source.getKmsKey();
        }

        @Override
        BigQueryIO.DynamicRead.Builder<T> setBigQueryServices(BigQueryServices bigQueryServices) {
            if (bigQueryServices == null) {
                throw new NullPointerException("Null bigQueryServices");
            }
            this.bigQueryServices = bigQueryServices;
            return this;
        }

        @Override
        BigQueryIO.DynamicRead.Builder<T> setFormat(DataFormat format) {
            if (format == null) {
                throw new NullPointerException("Null format");
            }
            this.format = format;
            return this;
        }

        @Override
        BigQueryIO.DynamicRead.Builder<T> setParseFn(SerializableFunction<SchemaAndRecord, T> parseFn) {
            this.parseFn = parseFn;
            return this;
        }

        @Override
        BigQueryIO.DynamicRead.Builder<T> setOutputCoder(Coder<T> outputCoder) {
            this.outputCoder = outputCoder;
            return this;
        }

        @Override
        BigQueryIO.DynamicRead.Builder<T> setProjectionPushdownApplied(boolean projectionPushdownApplied) {
            this.projectionPushdownApplied = projectionPushdownApplied;
            return this;
        }

        @Override
        BigQueryIO.DynamicRead.Builder<T> setBadRecordRouter(BadRecordRouter badRecordRouter) {
            if (badRecordRouter == null) {
                throw new NullPointerException("Null badRecordRouter");
            }
            this.badRecordRouter = badRecordRouter;
            return this;
        }

        @Override
        BigQueryIO.DynamicRead.Builder<T> setBadRecordErrorHandler(ErrorHandler<BadRecord, ?> badRecordErrorHandler) {
            if (badRecordErrorHandler == null) {
                throw new NullPointerException("Null badRecordErrorHandler");
            }
            this.badRecordErrorHandler = badRecordErrorHandler;
            return this;
        }

        @Override
        BigQueryIO.DynamicRead.Builder<T> setQueryLocation(String queryLocation) {
            this.queryLocation = queryLocation;
            return this;
        }

        @Override
        BigQueryIO.DynamicRead.Builder<T> setQueryTempDataset(String queryTempDataset) {
            this.queryTempDataset = queryTempDataset;
            return this;
        }

        @Override
        BigQueryIO.DynamicRead.Builder<T> setQueryTempProject(String queryTempProject) {
            this.queryTempProject = queryTempProject;
            return this;
        }

        @Override
        BigQueryIO.DynamicRead.Builder<T> setKmsKey(String kmsKey) {
            this.kmsKey = kmsKey;
            return this;
        }

        @Override
        BigQueryIO.DynamicRead<T> build() {
            if (this.bigQueryServices == null || this.format == null || this.projectionPushdownApplied == null || this.badRecordRouter == null || this.badRecordErrorHandler == null) {
                StringBuilder missing = new StringBuilder();
                if (this.bigQueryServices == null) {
                    missing.append(" bigQueryServices");
                }
                if (this.format == null) {
                    missing.append(" format");
                }
                if (this.projectionPushdownApplied == null) {
                    missing.append(" projectionPushdownApplied");
                }
                if (this.badRecordRouter == null) {
                    missing.append(" badRecordRouter");
                }
                if (this.badRecordErrorHandler == null) {
                    missing.append(" badRecordErrorHandler");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_BigQueryIO_DynamicRead(this.bigQueryServices, this.format, this.parseFn, this.outputCoder, this.projectionPushdownApplied, this.badRecordRouter, this.badRecordErrorHandler, this.queryLocation, this.queryTempDataset, this.queryTempProject, this.kmsKey);
        }
    }
}

