/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.datastore;

import com.google.datastore.v1.Entity;
import com.google.datastore.v1.Key;
import com.google.datastore.v1.Value;
import com.google.datastore.v1.client.DatastoreHelper;
import com.google.protobuf.Timestamp;
import com.google.protobuf.util.Timestamps;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityToRow
extends PTransform<PCollection<Entity>, PCollection<Row>> {
    private final @UnknownKeyFor @NonNull @Initialized Schema schema;
    private final @UnknownKeyFor @NonNull @Initialized String keyField;
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(EntityToRow.class);

    private EntityToRow(@UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized String keyField) {
        this.schema = schema;
        this.keyField = keyField;
        if (schema.getFieldNames().contains(keyField)) {
            if (!schema.getField(keyField).getType().getTypeName().equals((Object)Schema.TypeName.BYTES)) {
                throw new IllegalStateException("Field `" + keyField + "` should of type `BYTES`. Please change the type or specify a field to store the KEY value.");
            }
            LOG.info("Entity KEY will be stored under `" + keyField + "` field.");
        }
    }

    public static @UnknownKeyFor @NonNull @Initialized EntityToRow create(@UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized String keyField) {
        return new EntityToRow(schema, keyField);
    }

    public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Entity> input) {
        return ((PCollection)input.apply((PTransform)ParDo.of((DoFn)new EntityToRowConverter()))).setRowSchema(this.schema);
    }

    class EntityToRowConverter
    extends DoFn<Entity, Row> {
        EntityToRowConverter() {
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext context) {
            Entity entity = (Entity)context.element();
            ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
            mapBuilder.put((Object)EntityToRow.this.keyField, (Object)DatastoreHelper.makeValue((Key)entity.getKey()).build());
            mapBuilder.putAll(entity.getPropertiesMap());
            context.output((Object)this.extractRowFromProperties(EntityToRow.this.schema, (Map<String, Value>)mapBuilder.build()));
        }

        private @UnknownKeyFor @NonNull @Initialized Object convertValueToObject(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Schema.FieldType currentFieldType, @UnknownKeyFor @NonNull @Initialized Value val) {
            Value.ValueTypeCase typeCase = val.getValueTypeCase();
            switch (typeCase) {
                case NULL_VALUE: 
                case VALUETYPE_NOT_SET: {
                    return null;
                }
                case BOOLEAN_VALUE: {
                    return val.getBooleanValue();
                }
                case INTEGER_VALUE: {
                    return val.getIntegerValue();
                }
                case DOUBLE_VALUE: {
                    return val.getDoubleValue();
                }
                case TIMESTAMP_VALUE: {
                    Timestamp time = val.getTimestampValue();
                    long millis = Timestamps.toMillis((Timestamp)time);
                    return Instant.ofEpochMilli((long)millis).toDateTime();
                }
                case STRING_VALUE: {
                    return val.getStringValue();
                }
                case KEY_VALUE: {
                    return val.getKeyValue().toByteArray();
                }
                case BLOB_VALUE: {
                    return val.getBlobValue().toByteArray();
                }
                case ENTITY_VALUE: {
                    Schema rowSchema = currentFieldType.getRowSchema();
                    assert (rowSchema != null);
                    Entity entity = val.getEntityValue();
                    return this.extractRowFromProperties(rowSchema, entity.getPropertiesMap());
                }
                case ARRAY_VALUE: {
                    Schema.FieldType elementType = currentFieldType.getCollectionElementType();
                    List valueList = val.getArrayValue().getValuesList();
                    return valueList.stream().map(v -> this.convertValueToObject(elementType, (Value)v)).collect(Collectors.toList());
                }
            }
            throw new IllegalStateException("No conversion exists from type: " + val.getValueTypeCase().name() + " to Beam type.");
        }

        private @UnknownKeyFor @NonNull @Initialized Row extractRowFromProperties(@UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Value> values) {
            Row.Builder builder = Row.withSchema((Schema)schema);
            for (Schema.Field field : schema.getFields()) {
                Value val = values.get(field.getName());
                builder.addValue(this.convertValueToObject(field.getType(), val));
            }
            return builder.build();
        }
    }
}

