/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.cloud.bigquery.storage.v1.TableFieldSchema;
import com.google.cloud.bigquery.storage.v1.TableSchema;
import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.apache.avro.Conversions;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.beam.sdk.extensions.avro.schemas.utils.AvroUtils;
import org.apache.beam.sdk.io.gcp.bigquery.CivilTimeEncoder;
import org.apache.beam.sdk.io.gcp.bigquery.StorageApiCDC;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Functions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.primitives.Bytes;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Days;
import org.joda.time.LocalTime;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;

public class AvroGenericRecordToStorageApiProto {
    private static final @UnknownKeyFor @NonNull @Initialized org.joda.time.LocalDate EPOCH_DATE = new org.joda.time.LocalDate(1970, 1, 1);
    static final @UnknownKeyFor @NonNull @Initialized Map<// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.Type, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized TableFieldSchema.Type> PRIMITIVE_TYPES = ImmutableMap.builder().put((Object)Schema.Type.INT, (Object)TableFieldSchema.Type.INT64).put((Object)Schema.Type.FIXED, (Object)TableFieldSchema.Type.BYTES).put((Object)Schema.Type.LONG, (Object)TableFieldSchema.Type.INT64).put((Object)Schema.Type.FLOAT, (Object)TableFieldSchema.Type.DOUBLE).put((Object)Schema.Type.DOUBLE, (Object)TableFieldSchema.Type.DOUBLE).put((Object)Schema.Type.STRING, (Object)TableFieldSchema.Type.STRING).put((Object)Schema.Type.BOOLEAN, (Object)TableFieldSchema.Type.BOOL).put((Object)Schema.Type.ENUM, (Object)TableFieldSchema.Type.STRING).put((Object)Schema.Type.BYTES, (Object)TableFieldSchema.Type.BYTES).build();
    static final @UnknownKeyFor @NonNull @Initialized Map<// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.Type, @UnknownKeyFor @NonNull @Initialized Function<@UnknownKeyFor @NonNull @Initialized Object, @UnknownKeyFor @NonNull @Initialized Object>> PRIMITIVE_ENCODERS = ImmutableMap.builder().put((Object)Schema.Type.INT, o -> (long)((Integer)o).intValue()).put((Object)Schema.Type.FIXED, o -> ByteString.copyFrom((byte[])((GenericData.Fixed)o).bytes())).put((Object)Schema.Type.LONG, (Object)Functions.identity()).put((Object)Schema.Type.FLOAT, o -> Double.parseDouble(Float.valueOf(((Float)o).floatValue()).toString())).put((Object)Schema.Type.DOUBLE, Function.identity()).put((Object)Schema.Type.STRING, Object::toString).put((Object)Schema.Type.BOOLEAN, Function.identity()).put((Object)Schema.Type.ENUM, o -> o.toString()).put((Object)Schema.Type.BYTES, AvroGenericRecordToStorageApiProto::convertBytes).build();
    static final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized BiFunction<@UnknownKeyFor @NonNull @Initialized LogicalType, @UnknownKeyFor @NonNull @Initialized Object, @UnknownKeyFor @NonNull @Initialized Object>> LOGICAL_TYPE_ENCODERS = ImmutableMap.builder().put((Object)"date", (logicalType, value) -> AvroGenericRecordToStorageApiProto.convertDate(value)).put((Object)"time-micros", (logicalType, value) -> AvroGenericRecordToStorageApiProto.convertTime(value, true)).put((Object)"time-millis", (logicalType, value) -> AvroGenericRecordToStorageApiProto.convertTime(value, false)).put((Object)"decimal", AvroGenericRecordToStorageApiProto::convertDecimal).put((Object)"timestamp-micros", (logicalType, value) -> AvroGenericRecordToStorageApiProto.convertTimestamp(value, true)).put((Object)"timestamp-millis", (logicalType, value) -> AvroGenericRecordToStorageApiProto.convertTimestamp(value, false)).put((Object)"local-timestamp-micros", (logicalType, value) -> AvroGenericRecordToStorageApiProto.convertDateTime(value, true)).put((Object)"local-timestamp-millis", (logicalType, value) -> AvroGenericRecordToStorageApiProto.convertDateTime(value, false)).put((Object)"uuid", (logicalType, value) -> AvroGenericRecordToStorageApiProto.convertUUID(value)).build();

    static @UnknownKeyFor @NonNull @Initialized Optional<// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized TableFieldSchema.Type> logicalTypes(@UnknownKeyFor @NonNull @Initialized LogicalType logicalType) {
        switch (logicalType.getName()) {
            case "date": {
                return Optional.of(TableFieldSchema.Type.DATE);
            }
            case "time-micros": {
                return Optional.of(TableFieldSchema.Type.TIME);
            }
            case "time-millis": {
                return Optional.of(TableFieldSchema.Type.TIME);
            }
            case "decimal": {
                LogicalTypes.Decimal decimal = (LogicalTypes.Decimal)logicalType;
                int scale = decimal.getScale();
                int precision = decimal.getPrecision();
                if (scale > 9 || precision - scale > 29) {
                    return Optional.of(TableFieldSchema.Type.BIGNUMERIC);
                }
                return Optional.of(TableFieldSchema.Type.NUMERIC);
            }
            case "timestamp-micros": {
                return Optional.of(TableFieldSchema.Type.TIMESTAMP);
            }
            case "timestamp-millis": {
                return Optional.of(TableFieldSchema.Type.TIMESTAMP);
            }
            case "local-timestamp-micros": {
                return Optional.of(TableFieldSchema.Type.DATETIME);
            }
            case "local-timestamp-millis": {
                return Optional.of(TableFieldSchema.Type.DATETIME);
            }
            case "uuid": {
                return Optional.of(TableFieldSchema.Type.STRING);
            }
        }
        return Optional.empty();
    }

    static @UnknownKeyFor @NonNull @Initialized String convertUUID(@UnknownKeyFor @NonNull @Initialized Object value) {
        if (value instanceof UUID) {
            return ((UUID)value).toString();
        }
        org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((boolean)(value instanceof String), (Object)"Expecting a value as String type.");
        UUID.fromString((String)value);
        return (String)value;
    }

    static @UnknownKeyFor @NonNull @Initialized Long convertTimestamp(@UnknownKeyFor @NonNull @Initialized Object value, @UnknownKeyFor @NonNull @Initialized boolean micros) {
        if (value instanceof ReadableInstant) {
            return ((ReadableInstant)value).getMillis() * 1000L;
        }
        if (value instanceof Instant) {
            Instant instant = (Instant)value;
            long seconds = instant.getEpochSecond();
            int nanos = instant.getNano();
            if (seconds < 0L && nanos > 0) {
                long ms = Math.multiplyExact(seconds + 1L, 1000000L);
                long adjustment = (long)nanos / 1000L - 1000000L;
                return Math.addExact(ms, adjustment);
            }
            long ms = Math.multiplyExact(seconds, 1000000L);
            return Math.addExact(ms, (long)nanos / 1000L);
        }
        org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((boolean)(value instanceof Long), (Object)"Expecting a value as Long type (timestamp).");
        return (micros ? 1L : 1000L) * (Long)value;
    }

    static @UnknownKeyFor @NonNull @Initialized Integer convertDate(@UnknownKeyFor @NonNull @Initialized Object value) {
        if (value instanceof org.joda.time.LocalDate) {
            return Days.daysBetween((ReadablePartial)EPOCH_DATE, (ReadablePartial)((org.joda.time.LocalDate)value)).getDays();
        }
        if (value instanceof LocalDate) {
            return (int)((LocalDate)value).toEpochDay();
        }
        org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((boolean)(value instanceof Integer), (Object)"Expecting a value as Integer type (days).");
        return (Integer)value;
    }

    static @UnknownKeyFor @NonNull @Initialized Long convertTime(@UnknownKeyFor @NonNull @Initialized Object value, @UnknownKeyFor @NonNull @Initialized boolean micros) {
        if (value instanceof LocalTime) {
            return CivilTimeEncoder.encodePacked64TimeMicros((LocalTime)value);
        }
        if (value instanceof java.time.LocalTime) {
            return CivilTimeEncoder.encodePacked64TimeMicros((java.time.LocalTime)value);
        }
        if (micros) {
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((boolean)(value instanceof Long), (Object)"Expecting a value as Long type (time).");
            return CivilTimeEncoder.encodePacked64TimeMicros(java.time.LocalTime.ofNanoOfDay(TimeUnit.MICROSECONDS.toNanos((Long)value)));
        }
        org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((boolean)(value instanceof Integer), (Object)"Expecting a value as Integer type (time).");
        return CivilTimeEncoder.encodePacked64TimeMicros(java.time.LocalTime.ofNanoOfDay(TimeUnit.MILLISECONDS.toNanos(((Integer)value).longValue())));
    }

    static @UnknownKeyFor @NonNull @Initialized Long convertDateTime(@UnknownKeyFor @NonNull @Initialized Object value, @UnknownKeyFor @NonNull @Initialized boolean micros) {
        if (value instanceof org.joda.time.LocalDateTime) {
            DateTime dateTime = ((org.joda.time.LocalDateTime)value).toDateTime(DateTimeZone.UTC);
            return 1000L * dateTime.getMillis();
        }
        if (value instanceof LocalDateTime) {
            Instant instant = ((LocalDateTime)value).toInstant(ZoneOffset.UTC);
            return AvroGenericRecordToStorageApiProto.convertTimestamp(instant, micros);
        }
        org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((boolean)(value instanceof Long), (Object)"Expecting a value as Long type (local-timestamp).");
        return (micros ? 1L : 1000L) * (Long)value;
    }

    static @UnknownKeyFor @NonNull @Initialized ByteString convertDecimal(@UnknownKeyFor @NonNull @Initialized LogicalType logicalType, @UnknownKeyFor @NonNull @Initialized Object value) {
        ByteBuffer byteBuffer;
        if (value instanceof BigDecimal) {
            byteBuffer = new Conversions.DecimalConversion().toBytes((BigDecimal)value, Schema.create((Schema.Type)Schema.Type.NULL), logicalType);
        } else {
            org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkArgument((boolean)(value instanceof ByteBuffer), (Object)"Expecting a value as ByteBuffer type (decimal).");
            byteBuffer = (ByteBuffer)value;
        }
        byte[] bytes = new byte[byteBuffer.remaining()];
        byteBuffer.duplicate().get(bytes);
        Bytes.reverse((byte[])bytes);
        return ByteString.copyFrom((byte[])bytes);
    }

    static @UnknownKeyFor @NonNull @Initialized ByteString convertBytes(@UnknownKeyFor @NonNull @Initialized Object value) {
        if (value instanceof byte[]) {
            return ByteString.copyFrom((byte[])((byte[])value));
        }
        return ByteString.copyFrom((ByteBuffer)((ByteBuffer)value).duplicate());
    }

    public static @UnknownKeyFor @NonNull @Initialized TableSchema protoTableSchemaFromAvroSchema(@UnknownKeyFor @NonNull @Initialized Schema schema) {
        org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkState((!schema.getFields().isEmpty() ? 1 : 0) != 0);
        TableSchema.Builder builder = TableSchema.newBuilder();
        for (Schema.Field field : schema.getFields()) {
            builder.addFields(AvroGenericRecordToStorageApiProto.fieldDescriptorFromAvroField(field));
        }
        return builder.build();
    }

    public static @UnknownKeyFor @NonNull @Initialized DynamicMessage messageFromGenericRecord(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Descriptors.Descriptor descriptor, @UnknownKeyFor @NonNull @Initialized GenericRecord record, @javax.annotation.Nullable @UnknownKeyFor @Nullable @Initialized String changeType, @UnknownKeyFor @NonNull @Initialized long changeSequenceNum) {
        return AvroGenericRecordToStorageApiProto.messageFromGenericRecord(descriptor, record, changeType, Long.toHexString(changeSequenceNum));
    }

    public static @UnknownKeyFor @NonNull @Initialized DynamicMessage messageFromGenericRecord(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Descriptors.Descriptor descriptor, @UnknownKeyFor @NonNull @Initialized GenericRecord record, @javax.annotation.Nullable @UnknownKeyFor @Nullable @Initialized String changeType, @javax.annotation.Nullable @UnknownKeyFor @Nullable @Initialized String changeSequenceNum) {
        Schema schema = record.getSchema();
        DynamicMessage.Builder builder = DynamicMessage.newBuilder((Descriptors.Descriptor)descriptor);
        for (Schema.Field field : schema.getFields()) {
            Descriptors.FieldDescriptor fieldDescriptor = (Descriptors.FieldDescriptor)org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkNotNull((Object)descriptor.findFieldByName(field.name().toLowerCase()));
            Object value = AvroGenericRecordToStorageApiProto.messageValueFromGenericRecordValue(fieldDescriptor, field, field.name(), record);
            if (value == null) continue;
            builder.setField(fieldDescriptor, value);
        }
        if (changeType != null) {
            builder.setField((Descriptors.FieldDescriptor)Preconditions.checkStateNotNull((Object)descriptor.findFieldByName("_CHANGE_TYPE")), (Object)changeType);
            builder.setField((Descriptors.FieldDescriptor)Preconditions.checkStateNotNull((Object)descriptor.findFieldByName("_CHANGE_SEQUENCE_NUMBER")), Preconditions.checkStateNotNull((Object)changeSequenceNum));
        }
        return builder.build();
    }

    private static @UnknownKeyFor @NonNull @Initialized TableFieldSchema fieldDescriptorFromAvroField(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.Field field) {
        Schema schema = field.schema();
        org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkNotNull((Object)schema, (Object)"Unexpected null schema!");
        if (StorageApiCDC.COLUMNS.contains(field.name())) {
            throw new RuntimeException("Reserved field name " + field.name() + " in user schema.");
        }
        TableFieldSchema.Builder builder = TableFieldSchema.newBuilder().setName(field.name().toLowerCase());
        Schema elementType = null;
        switch (schema.getType()) {
            case RECORD: {
                org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkState((!schema.getFields().isEmpty() ? 1 : 0) != 0);
                builder = builder.setType(TableFieldSchema.Type.STRUCT);
                for (Schema.Field recordField : schema.getFields()) {
                    builder = builder.addFields(AvroGenericRecordToStorageApiProto.fieldDescriptorFromAvroField(recordField));
                }
                break;
            }
            case ARRAY: {
                elementType = AvroUtils.TypeWithNullability.create((Schema)schema.getElementType()).getType();
                if (elementType == null) {
                    throw new RuntimeException("Unexpected null element type!");
                }
                org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkState((elementType.getType() != Schema.Type.ARRAY ? 1 : 0) != 0, (Object)"Nested arrays not supported by BigQuery.");
                TableFieldSchema elementFieldSchema = AvroGenericRecordToStorageApiProto.fieldDescriptorFromAvroField(new Schema.Field(field.name(), elementType, field.doc(), field.defaultVal()));
                builder = builder.setType(elementFieldSchema.getType());
                builder.addAllFields((Iterable)elementFieldSchema.getFieldsList());
                builder = builder.setMode(TableFieldSchema.Mode.REPEATED);
                break;
            }
            case MAP: {
                Schema keyType = Schema.create((Schema.Type)Schema.Type.STRING);
                Schema valueType = Schema.create((Schema.Type)schema.getValueType().getType());
                if (valueType == null) {
                    throw new RuntimeException("Unexpected null element type!");
                }
                TableFieldSchema keyFieldSchema = AvroGenericRecordToStorageApiProto.fieldDescriptorFromAvroField(new Schema.Field("key", keyType, "key of the map entry", null));
                TableFieldSchema valueFieldSchema = AvroGenericRecordToStorageApiProto.fieldDescriptorFromAvroField(new Schema.Field("value", valueType, "value of the map entry", null));
                builder = builder.setType(TableFieldSchema.Type.STRUCT).addFields(keyFieldSchema).addFields(valueFieldSchema).setMode(TableFieldSchema.Mode.REPEATED);
                break;
            }
            case UNION: {
                elementType = AvroUtils.TypeWithNullability.create((Schema)schema).getType();
                if (elementType == null) {
                    throw new RuntimeException("Unexpected null element type!");
                }
                org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkState((elementType.getType() != Schema.Type.UNION ? 1 : 0) != 0, (Object)"Multiple non-null union types are not supported.");
                TableFieldSchema unionFieldSchema = AvroGenericRecordToStorageApiProto.fieldDescriptorFromAvroField(new Schema.Field(field.name(), elementType, field.doc(), null));
                builder = builder.setType(unionFieldSchema.getType()).setMode(unionFieldSchema.getMode()).addAllFields((Iterable)unionFieldSchema.getFieldsList());
                break;
            }
            default: {
                elementType = AvroUtils.TypeWithNullability.create((Schema)schema).getType();
                Optional<LogicalType> logicalType = Optional.ofNullable(LogicalTypes.fromSchema((Schema)elementType));
                TableFieldSchema.Type primitiveType = logicalType.flatMap(AvroGenericRecordToStorageApiProto::logicalTypes).orElse(PRIMITIVE_TYPES.get(elementType.getType()));
                if (primitiveType == null) {
                    throw new RuntimeException("Unsupported type " + elementType.getType());
                }
                builder = builder.setType(primitiveType);
                if (!logicalType.isPresent() || !logicalType.get().getName().equals("decimal")) break;
                LogicalTypes.Decimal decimal = (LogicalTypes.Decimal)logicalType.get();
                int precision = decimal.getPrecision();
                int scale = decimal.getScale();
                if (precision == 38 && scale == 9 || precision == 77 && scale == 38) break;
                builder = builder.setPrecision((long)precision);
                if (scale == 0) break;
                builder = builder.setScale((long)scale);
            }
        }
        if (builder.getMode() != TableFieldSchema.Mode.REPEATED) {
            builder = AvroUtils.TypeWithNullability.create((Schema)schema).isNullable() != false ? builder.setMode(TableFieldSchema.Mode.NULLABLE) : builder.setMode(TableFieldSchema.Mode.REQUIRED);
        }
        if (field.doc() != null) {
            builder = builder.setDescription(field.doc());
        }
        return builder.build();
    }

    @javax.annotation.Nullable
    private static @UnknownKeyFor @Nullable @Initialized Object messageValueFromGenericRecordValue(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Descriptors.FieldDescriptor fieldDescriptor, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.Field avroField, @UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized GenericRecord record) {
        Object value = record.get(name);
        if (value == null) {
            if (fieldDescriptor.isOptional() || avroField.schema().getTypes().stream().anyMatch(t -> t.getType() == Schema.Type.NULL)) {
                return null;
            }
            throw new IllegalArgumentException("Received null value for non-nullable field " + fieldDescriptor.getName());
        }
        return AvroGenericRecordToStorageApiProto.toProtoValue(fieldDescriptor, avroField.schema(), value);
    }

    private static @UnknownKeyFor @NonNull @Initialized Object toProtoValue(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Descriptors.FieldDescriptor fieldDescriptor, @UnknownKeyFor @NonNull @Initialized Schema avroSchema, @UnknownKeyFor @NonNull @Initialized Object value) {
        switch (avroSchema.getType()) {
            case RECORD: {
                return AvroGenericRecordToStorageApiProto.messageFromGenericRecord(fieldDescriptor.getMessageType(), (GenericRecord)value, null, -1L);
            }
            case ARRAY: {
                Iterable iterable = (Iterable)value;
                Schema arrayElementType = avroSchema.getElementType();
                if (arrayElementType == null) {
                    throw new RuntimeException("Unexpected null element type!");
                }
                return StreamSupport.stream(iterable.spliterator(), false).map(v -> AvroGenericRecordToStorageApiProto.toProtoValue(fieldDescriptor, arrayElementType, v)).collect(Collectors.toList());
            }
            case UNION: {
                AvroUtils.TypeWithNullability type = AvroUtils.TypeWithNullability.create((Schema)avroSchema);
                org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkState((type.getType().getType() != Schema.Type.UNION ? 1 : 0) != 0, (Object)"Multiple non-null union types are not supported.");
                return AvroGenericRecordToStorageApiProto.toProtoValue(fieldDescriptor, type.getType(), value);
            }
            case MAP: {
                Map map = (Map)value;
                Schema valueType = Schema.create((Schema.Type)avroSchema.getValueType().getType());
                if (valueType == null) {
                    throw new RuntimeException("Unexpected null element type!");
                }
                return map.entrySet().stream().map(entry -> AvroGenericRecordToStorageApiProto.mapEntryToProtoValue(fieldDescriptor.getMessageType(), valueType, entry)).collect(Collectors.toList());
            }
        }
        return AvroGenericRecordToStorageApiProto.scalarToProtoValue(avroSchema, value);
    }

    static @UnknownKeyFor @NonNull @Initialized Object mapEntryToProtoValue(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Descriptors.Descriptor descriptor, @UnknownKeyFor @NonNull @Initialized Schema valueFieldType, @UnknownKeyFor @NonNull @Initialized Map.Entry<@UnknownKeyFor @NonNull @Initialized CharSequence, @UnknownKeyFor @NonNull @Initialized Object> entryValue) {
        Descriptors.FieldDescriptor valueFieldDescriptor;
        Object value;
        DynamicMessage.Builder builder = DynamicMessage.newBuilder((Descriptors.Descriptor)descriptor);
        Descriptors.FieldDescriptor keyFieldDescriptor = (Descriptors.FieldDescriptor)org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkNotNull((Object)descriptor.findFieldByName("key"));
        Object key = AvroGenericRecordToStorageApiProto.toProtoValue(keyFieldDescriptor, Schema.create((Schema.Type)Schema.Type.STRING), entryValue.getKey());
        if (key != null) {
            builder.setField(keyFieldDescriptor, key);
        }
        if ((value = AvroGenericRecordToStorageApiProto.toProtoValue(valueFieldDescriptor = (Descriptors.FieldDescriptor)org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions.checkNotNull((Object)descriptor.findFieldByName("value")), valueFieldType, entryValue.getValue())) != null) {
            builder.setField(valueFieldDescriptor, value);
        }
        return builder.build();
    }

    @VisibleForTesting
    static @UnknownKeyFor @NonNull @Initialized Object scalarToProtoValue(@UnknownKeyFor @NonNull @Initialized Schema fieldSchema, @UnknownKeyFor @NonNull @Initialized Object value) {
        AvroUtils.TypeWithNullability type = AvroUtils.TypeWithNullability.create((Schema)fieldSchema);
        LogicalType logicalType = LogicalTypes.fromSchema((Schema)type.getType());
        if (logicalType != null) {
            BiFunction<LogicalType, Object, Object> logicalTypeEncoder = LOGICAL_TYPE_ENCODERS.get(logicalType.getName());
            if (logicalTypeEncoder == null) {
                throw new IllegalArgumentException("Unsupported logical type " + logicalType.getName());
            }
            return logicalTypeEncoder.apply(logicalType, value);
        }
        Function<Object, Object> encoder = PRIMITIVE_ENCODERS.get(type.getType().getType());
        if (encoder == null) {
            throw new RuntimeException("Unexpected beam type " + fieldSchema);
        }
        return encoder.apply(value);
    }
}

