/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner;

import com.google.auto.service.AutoService;
import com.google.auto.value.AutoValue;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.gcp.spanner.AutoValue_SpannerReadSchemaTransformProvider_SpannerReadSchemaTransformConfiguration;
import org.apache.beam.sdk.io.gcp.spanner.SpannerIO;
import org.apache.beam.sdk.io.gcp.spanner.StructUtils;
import org.apache.beam.sdk.schemas.AutoValueSchema;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.annotations.DefaultSchema;
import org.apache.beam.sdk.schemas.annotations.SchemaFieldDescription;
import org.apache.beam.sdk.schemas.transforms.SchemaTransform;
import org.apache.beam.sdk.schemas.transforms.SchemaTransformProvider;
import org.apache.beam.sdk.schemas.transforms.TypedSchemaTransformProvider;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionRowTuple;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Strings;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@AutoService(value={SchemaTransformProvider.class})
public class SpannerReadSchemaTransformProvider
extends TypedSchemaTransformProvider<SpannerReadSchemaTransformConfiguration> {
    public @UnknownKeyFor @NonNull @Initialized String identifier() {
        return "beam:schematransform:org.apache.beam:spanner_read:v1";
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> inputCollectionNames() {
        return Collections.emptyList();
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> outputCollectionNames() {
        return Collections.singletonList("output");
    }

    protected @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized SpannerReadSchemaTransformConfiguration> configurationClass() {
        return SpannerReadSchemaTransformConfiguration.class;
    }

    protected @UnknownKeyFor @NonNull @Initialized SchemaTransform from(@UnknownKeyFor @NonNull @Initialized SpannerReadSchemaTransformConfiguration configuration) {
        return new SpannerSchemaTransformRead(configuration);
    }

    @DefaultSchema(value=AutoValueSchema.class)
    @AutoValue
    public static abstract class SpannerReadSchemaTransformConfiguration
    implements Serializable {
        public void validate() {
            String invalidConfigMessage = "Invalid Cloud Spanner Read configuration: ";
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.getInstanceId()) ? 1 : 0) != 0, (Object)(invalidConfigMessage + "Instance ID must be specified."));
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.getDatabaseId()) ? 1 : 0) != 0, (Object)(invalidConfigMessage + "Database ID must be specified."));
            if (Strings.isNullOrEmpty((String)this.getQuery())) {
                Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.getTableId()) ? 1 : 0) != 0, (Object)(invalidConfigMessage + "Table name must be specified for table read."));
                Preconditions.checkArgument((this.getColumns() != null && !this.getColumns().isEmpty() ? 1 : 0) != 0, (Object)(invalidConfigMessage + "Columns must be specified for table read."));
            } else {
                Preconditions.checkArgument((!Strings.isNullOrEmpty((String)this.getQuery()) ? 1 : 0) != 0, (Object)(invalidConfigMessage + "Query must be specified for query read."));
                Preconditions.checkArgument((boolean)Strings.isNullOrEmpty((String)this.getTableId()), (Object)(invalidConfigMessage + "Table name should not be specified when using a query."));
                Preconditions.checkArgument((this.getColumns() == null || this.getColumns().isEmpty() ? 1 : 0) != 0, (Object)(invalidConfigMessage + "Columns should not be specified when using a query."));
            }
        }

        public static @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Builder builder() {
            return new AutoValue_SpannerReadSchemaTransformProvider_SpannerReadSchemaTransformConfiguration.Builder();
        }

        @SchemaFieldDescription(value="Specifies the GCP project ID.")
        @Nullable
        public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String getProjectId();

        @SchemaFieldDescription(value="Specifies the Cloud Spanner instance.")
        public abstract @UnknownKeyFor @NonNull @Initialized String getInstanceId();

        @SchemaFieldDescription(value="Specifies the Cloud Spanner database.")
        public abstract @UnknownKeyFor @NonNull @Initialized String getDatabaseId();

        @SchemaFieldDescription(value="Specifies the Cloud Spanner table.")
        @Nullable
        public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String getTableId();

        @SchemaFieldDescription(value="Specifies the SQL query to execute.")
        @Nullable
        public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String getQuery();

        @SchemaFieldDescription(value="Specifies the columns to read from the table.")
        @Nullable
        public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized List<@UnknownKeyFor @NonNull @Initialized String> getColumns();

        @Nullable
        @AutoValue.Builder
        public static abstract class Builder {
            public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Builder setProjectId(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Builder setInstanceId(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Builder setDatabaseId(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Builder setTableId(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Builder setQuery(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Builder setColumns(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> var1);

            public abstract @UnknownKeyFor @NonNull @Initialized SpannerReadSchemaTransformConfiguration build();
        }
    }

    static class SpannerSchemaTransformRead
    extends SchemaTransform
    implements Serializable {
        private final @UnknownKeyFor @NonNull @Initialized SpannerReadSchemaTransformConfiguration configuration;

        SpannerSchemaTransformRead(@UnknownKeyFor @NonNull @Initialized SpannerReadSchemaTransformConfiguration configuration) {
            configuration.validate();
            this.configuration = configuration;
        }

        public @UnknownKeyFor @NonNull @Initialized PCollectionRowTuple expand(@UnknownKeyFor @NonNull @Initialized PCollectionRowTuple input) {
            Preconditions.checkNotNull((Object)input, (Object)"Input to SpannerReadSchemaTransform cannot be null.");
            SpannerIO.Read read = SpannerIO.readWithSchema().withProjectId(this.configuration.getProjectId()).withInstanceId(this.configuration.getInstanceId()).withDatabaseId(this.configuration.getDatabaseId());
            read = !Strings.isNullOrEmpty((String)this.configuration.getQuery()) ? read.withQuery(this.configuration.getQuery()) : read.withTable(this.configuration.getTableId()).withColumns(this.configuration.getColumns());
            PCollection spannerRows = (PCollection)input.getPipeline().apply((PTransform)read);
            Schema schema = spannerRows.getSchema();
            PCollection rows = (PCollection)spannerRows.apply((PTransform)MapElements.into((TypeDescriptor)TypeDescriptor.of(Row.class)).via((SerializableFunction & Serializable)struct -> StructUtils.structToBeamRow(struct, schema)));
            return PCollectionRowTuple.of((String)"output", (PCollection)rows.setRowSchema(schema));
        }
    }
}

