/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner;

import com.google.cloud.ServiceFactory;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerOptions;
import com.google.common.annotations.VisibleForTesting;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.gcp.spanner.SpannerConfig;
import org.apache.beam.sdk.options.ValueProvider;

final class AutoValue_SpannerConfig
extends SpannerConfig {
    private final ValueProvider<String> projectId;
    private final ValueProvider<String> instanceId;
    private final ValueProvider<String> databaseId;
    private final ValueProvider<String> host;
    private final ServiceFactory<Spanner, SpannerOptions> serviceFactory;

    private AutoValue_SpannerConfig(@Nullable ValueProvider<String> projectId, @Nullable ValueProvider<String> instanceId, @Nullable ValueProvider<String> databaseId, @Nullable ValueProvider<String> host, @Nullable ServiceFactory<Spanner, SpannerOptions> serviceFactory) {
        this.projectId = projectId;
        this.instanceId = instanceId;
        this.databaseId = databaseId;
        this.host = host;
        this.serviceFactory = serviceFactory;
    }

    @Override
    @Nullable
    public ValueProvider<String> getProjectId() {
        return this.projectId;
    }

    @Override
    @Nullable
    public ValueProvider<String> getInstanceId() {
        return this.instanceId;
    }

    @Override
    @Nullable
    public ValueProvider<String> getDatabaseId() {
        return this.databaseId;
    }

    @Override
    @Nullable
    public ValueProvider<String> getHost() {
        return this.host;
    }

    @Override
    @Nullable
    @VisibleForTesting
    ServiceFactory<Spanner, SpannerOptions> getServiceFactory() {
        return this.serviceFactory;
    }

    public String toString() {
        return "SpannerConfig{projectId=" + this.projectId + ", instanceId=" + this.instanceId + ", databaseId=" + this.databaseId + ", host=" + this.host + ", serviceFactory=" + this.serviceFactory + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SpannerConfig) {
            SpannerConfig that = (SpannerConfig)o;
            return (this.projectId == null ? that.getProjectId() == null : this.projectId.equals(that.getProjectId())) && (this.instanceId == null ? that.getInstanceId() == null : this.instanceId.equals(that.getInstanceId())) && (this.databaseId == null ? that.getDatabaseId() == null : this.databaseId.equals(that.getDatabaseId())) && (this.host == null ? that.getHost() == null : this.host.equals(that.getHost())) && (this.serviceFactory == null ? that.getServiceFactory() == null : this.serviceFactory.equals(that.getServiceFactory()));
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.projectId == null ? 0 : this.projectId.hashCode();
        h *= 1000003;
        h ^= this.instanceId == null ? 0 : this.instanceId.hashCode();
        h *= 1000003;
        h ^= this.databaseId == null ? 0 : this.databaseId.hashCode();
        h *= 1000003;
        h ^= this.host == null ? 0 : this.host.hashCode();
        h *= 1000003;
        return h ^= this.serviceFactory == null ? 0 : this.serviceFactory.hashCode();
    }

    @Override
    SpannerConfig.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends SpannerConfig.Builder {
        private ValueProvider<String> projectId;
        private ValueProvider<String> instanceId;
        private ValueProvider<String> databaseId;
        private ValueProvider<String> host;
        private ServiceFactory<Spanner, SpannerOptions> serviceFactory;

        Builder() {
        }

        private Builder(SpannerConfig source) {
            this.projectId = source.getProjectId();
            this.instanceId = source.getInstanceId();
            this.databaseId = source.getDatabaseId();
            this.host = source.getHost();
            this.serviceFactory = source.getServiceFactory();
        }

        @Override
        SpannerConfig.Builder setProjectId(@Nullable ValueProvider<String> projectId) {
            this.projectId = projectId;
            return this;
        }

        @Override
        SpannerConfig.Builder setInstanceId(@Nullable ValueProvider<String> instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        @Override
        SpannerConfig.Builder setDatabaseId(@Nullable ValueProvider<String> databaseId) {
            this.databaseId = databaseId;
            return this;
        }

        @Override
        SpannerConfig.Builder setHost(@Nullable ValueProvider<String> host) {
            this.host = host;
            return this;
        }

        @Override
        SpannerConfig.Builder setServiceFactory(@Nullable ServiceFactory<Spanner, SpannerOptions> serviceFactory) {
            this.serviceFactory = serviceFactory;
            return this;
        }

        @Override
        public SpannerConfig build() {
            return new AutoValue_SpannerConfig(this.projectId, this.instanceId, this.databaseId, this.host, this.serviceFactory);
        }
    }
}

