/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.Job;
import com.google.api.services.bigquery.model.JobConfigurationTableCopy;
import com.google.api.services.bigquery.model.JobReference;
import com.google.api.services.bigquery.model.TableReference;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryHelpers;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.TableDestination;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollectionView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WriteRename
extends DoFn<Iterable<KV<TableDestination, String>>, Void> {
    private static final Logger LOG = LoggerFactory.getLogger(WriteRename.class);
    private final BigQueryServices bqServices;
    private final PCollectionView<String> jobIdToken;
    private final BigQueryIO.Write.WriteDisposition firstPaneWriteDisposition;
    private final BigQueryIO.Write.CreateDisposition firstPaneCreateDisposition;

    public WriteRename(BigQueryServices bqServices, PCollectionView<String> jobIdToken, BigQueryIO.Write.WriteDisposition writeDisposition, BigQueryIO.Write.CreateDisposition createDisposition) {
        this.bqServices = bqServices;
        this.jobIdToken = jobIdToken;
        this.firstPaneWriteDisposition = writeDisposition;
        this.firstPaneCreateDisposition = createDisposition;
    }

    @DoFn.ProcessElement
    public void processElement(DoFn.ProcessContext c) throws Exception {
        ArrayListMultimap tempTables = ArrayListMultimap.create();
        for (KV kV : (Iterable)c.element()) {
            tempTables.put((Object)((TableDestination)kV.getKey()), (Object)((String)kV.getValue()));
        }
        for (Map.Entry entry : tempTables.asMap().entrySet()) {
            this.writeRename((TableDestination)entry.getKey(), (Iterable)entry.getValue(), c);
        }
    }

    private void writeRename(TableDestination finalTableDestination, Iterable<String> tempTableNames, DoFn.ProcessContext c) throws Exception {
        BigQueryIO.Write.WriteDisposition writeDisposition = c.pane().getIndex() == 0L ? this.firstPaneWriteDisposition : BigQueryIO.Write.WriteDisposition.WRITE_APPEND;
        BigQueryIO.Write.CreateDisposition createDisposition = c.pane().getIndex() == 0L ? this.firstPaneCreateDisposition : BigQueryIO.Write.CreateDisposition.CREATE_NEVER;
        ArrayList tempTablesJson = Lists.newArrayList(tempTableNames);
        if (tempTablesJson.isEmpty()) {
            return;
        }
        ArrayList tempTables = Lists.newArrayList();
        for (String table : tempTablesJson) {
            tempTables.add(BigQueryHelpers.fromJsonString(table, TableReference.class));
        }
        String jobIdPrefix = BigQueryHelpers.createJobId((String)c.sideInput(this.jobIdToken), finalTableDestination, -1, c.pane().getIndex());
        this.copy(this.bqServices.getJobService((BigQueryOptions)c.getPipelineOptions().as(BigQueryOptions.class)), this.bqServices.getDatasetService((BigQueryOptions)c.getPipelineOptions().as(BigQueryOptions.class)), jobIdPrefix, finalTableDestination.getTableReference(), tempTables, writeDisposition, createDisposition, finalTableDestination.getTableDescription());
        BigQueryServices.DatasetService tableService = this.bqServices.getDatasetService((BigQueryOptions)c.getPipelineOptions().as(BigQueryOptions.class));
        WriteRename.removeTemporaryTables(tableService, tempTables);
    }

    private void copy(BigQueryServices.JobService jobService, BigQueryServices.DatasetService datasetService, String jobIdPrefix, TableReference ref, List<TableReference> tempTables, BigQueryIO.Write.WriteDisposition writeDisposition, BigQueryIO.Write.CreateDisposition createDisposition, @Nullable String tableDescription) throws InterruptedException, IOException {
        JobConfigurationTableCopy copyConfig = new JobConfigurationTableCopy().setSourceTables(tempTables).setDestinationTable(ref).setWriteDisposition(writeDisposition.name()).setCreateDisposition(createDisposition.name());
        String projectId = ref.getProjectId();
        Job lastFailedCopyJob = null;
        block5: for (int i = 0; i < 3; ++i) {
            String jobId = jobIdPrefix + "-" + i;
            JobReference jobRef = new JobReference().setProjectId(projectId).setJobId(jobId);
            jobService.startCopyJob(jobRef, copyConfig);
            Job copyJob = jobService.pollJob(jobRef, Integer.MAX_VALUE);
            BigQueryHelpers.Status jobStatus = BigQueryHelpers.parseStatus(copyJob);
            switch (jobStatus) {
                case SUCCEEDED: {
                    if (tableDescription != null) {
                        datasetService.patchTableDescription(ref, tableDescription);
                    }
                    return;
                }
                case UNKNOWN: {
                    throw new RuntimeException(String.format("UNKNOWN status of copy job [%s]: %s.", jobId, BigQueryHelpers.jobToPrettyString(copyJob)));
                }
                case FAILED: {
                    lastFailedCopyJob = copyJob;
                    continue block5;
                }
                default: {
                    throw new IllegalStateException(String.format("Unexpected status [%s] of load job: %s.", new Object[]{jobStatus, BigQueryHelpers.jobToPrettyString(copyJob)}));
                }
            }
        }
        throw new RuntimeException(String.format("Failed to create copy job with id prefix %s, reached max retries: %d, last failed copy job: %s.", jobIdPrefix, 3, BigQueryHelpers.jobToPrettyString(lastFailedCopyJob)));
    }

    static void removeTemporaryTables(BigQueryServices.DatasetService tableService, List<TableReference> tempTables) {
        for (TableReference tableRef : tempTables) {
            try {
                LOG.debug("Deleting table {}", (Object)BigQueryHelpers.toJsonString(tableRef));
                tableService.deleteTable(tableRef);
            }
            catch (Exception e) {
                LOG.warn("Failed to delete the table {}", (Object)BigQueryHelpers.toJsonString(tableRef), (Object)e);
            }
        }
    }

    public void populateDisplayData(DisplayData.Builder builder) {
        super.populateDisplayData(builder);
        builder.add(DisplayData.item((String)"firstPaneWriteDisposition", (String)this.firstPaneWriteDisposition.toString()).withLabel("Write Disposition")).add(DisplayData.item((String)"firstPaneCreateDisposition", (String)this.firstPaneCreateDisposition.toString()).withLabel("Create Disposition"));
    }
}

