/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.healthcare;

import com.google.gson.JsonArray;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.beam.sdk.coders.CustomCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class JsonArrayCoder
extends CustomCoder<JsonArray> {
    private static final @UnknownKeyFor @NonNull @Initialized JsonArrayCoder CODER = new JsonArrayCoder();
    private static final @UnknownKeyFor @NonNull @Initialized StringUtf8Coder STRING_CODER = StringUtf8Coder.of();

    public static @UnknownKeyFor @NonNull @Initialized JsonArrayCoder of() {
        return CODER;
    }

    public void encode(@UnknownKeyFor @NonNull @Initialized JsonArray value, @UnknownKeyFor @NonNull @Initialized OutputStream outStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
        STRING_CODER.encode(value.toString(), outStream);
    }

    public @UnknownKeyFor @NonNull @Initialized JsonArray decode(@UnknownKeyFor @NonNull @Initialized InputStream inStream) throws @UnknownKeyFor @NonNull @Initialized IOException {
        return JsonParser.parseString((String)STRING_CODER.decode(inStream)).getAsJsonArray();
    }
}

