/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner;

import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.StatusCode;
import com.google.auto.value.AutoValue;
import com.google.cloud.ServiceFactory;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.AbortedException;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.PartitionOptions;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.TimestampBound;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.OptionalInt;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.beam.runners.core.metrics.GcpResourceIdentifiers;
import org.apache.beam.runners.core.metrics.MonitoringInfoConstants;
import org.apache.beam.runners.core.metrics.ServiceCallMetric;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.SerializableCoder;
import org.apache.beam.sdk.io.gcp.spanner.AutoValue_SpannerIO_CreateTransaction;
import org.apache.beam.sdk.io.gcp.spanner.AutoValue_SpannerIO_Read;
import org.apache.beam.sdk.io.gcp.spanner.AutoValue_SpannerIO_ReadAll;
import org.apache.beam.sdk.io.gcp.spanner.AutoValue_SpannerIO_ReadChangeStream;
import org.apache.beam.sdk.io.gcp.spanner.AutoValue_SpannerIO_Write;
import org.apache.beam.sdk.io.gcp.spanner.BatchSpannerRead;
import org.apache.beam.sdk.io.gcp.spanner.CreateTransactionFn;
import org.apache.beam.sdk.io.gcp.spanner.MutationCellCounter;
import org.apache.beam.sdk.io.gcp.spanner.MutationGroup;
import org.apache.beam.sdk.io.gcp.spanner.MutationKeyEncoder;
import org.apache.beam.sdk.io.gcp.spanner.MutationSizeEstimator;
import org.apache.beam.sdk.io.gcp.spanner.MutationUtils;
import org.apache.beam.sdk.io.gcp.spanner.NaiveSpannerRead;
import org.apache.beam.sdk.io.gcp.spanner.ReadOperation;
import org.apache.beam.sdk.io.gcp.spanner.ReadSpannerSchema;
import org.apache.beam.sdk.io.gcp.spanner.SpannerAccessor;
import org.apache.beam.sdk.io.gcp.spanner.SpannerConfig;
import org.apache.beam.sdk.io.gcp.spanner.SpannerSchema;
import org.apache.beam.sdk.io.gcp.spanner.SpannerWriteResult;
import org.apache.beam.sdk.io.gcp.spanner.StructUtils;
import org.apache.beam.sdk.io.gcp.spanner.Transaction;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.ChangeStreamMetrics;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.ChangeStreamsConstants;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.MetadataSpannerConfigFactory;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.NameGenerator;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.action.ActionFactory;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.dao.DaoFactory;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.dofn.CleanUpReadChangeStreamDoFn;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.dofn.DetectNewPartitionsDoFn;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.dofn.InitializeDoFn;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.dofn.PostProcessingMetricsDoFn;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.dofn.ReadChangeStreamPartitionDoFn;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.estimator.BytesThroughputEstimator;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.estimator.SizeEstimator;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.mapper.MapperFactory;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.DataChangeRecord;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.PartitionMetadata;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Distribution;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.options.StreamingOptions;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.Flatten;
import org.apache.beam.sdk.transforms.Impulse;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.Reshuffle;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.View;
import org.apache.beam.sdk.transforms.Wait;
import org.apache.beam.sdk.transforms.WithTimestamps;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.DefaultTrigger;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindows;
import org.apache.beam.sdk.transforms.windowing.Trigger;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.util.BackOff;
import org.apache.beam.sdk.util.FluentBackoff;
import org.apache.beam.sdk.util.Sleeper;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Stopwatch;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.cache.CacheBuilder;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.cache.CacheLoader;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.cache.LoadingCache;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableSet;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.primitives.UnsignedBytes;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpannerIO {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(SpannerIO.class);
    private static final @UnknownKeyFor @NonNull @Initialized long DEFAULT_BATCH_SIZE_BYTES = 0x100000L;
    private static final @UnknownKeyFor @NonNull @Initialized int DEFAULT_MAX_NUM_MUTATIONS = 5000;
    private static final @UnknownKeyFor @NonNull @Initialized int DEFAULT_MAX_NUM_ROWS = 500;
    private static final @UnknownKeyFor @NonNull @Initialized int DEFAULT_GROUPING_FACTOR = 1000;
    static final @UnknownKeyFor @NonNull @Initialized int METRICS_CACHE_SIZE = 100;

    public static @UnknownKeyFor @NonNull @Initialized Read read() {
        return new AutoValue_SpannerIO_Read.Builder().setSpannerConfig(SpannerConfig.create()).setTimestampBound(TimestampBound.strong()).setReadOperation(ReadOperation.create()).setBatching(true).build();
    }

    public static @UnknownKeyFor @NonNull @Initialized ReadAll readAll() {
        return new AutoValue_SpannerIO_ReadAll.Builder().setSpannerConfig(SpannerConfig.create()).setTimestampBound(TimestampBound.strong()).setBatching(true).build();
    }

    public static @UnknownKeyFor @NonNull @Initialized CreateTransaction createTransaction() {
        return new AutoValue_SpannerIO_CreateTransaction.Builder().setSpannerConfig(SpannerConfig.create()).setTimestampBound(TimestampBound.strong()).build();
    }

    public static @UnknownKeyFor @NonNull @Initialized Write write() {
        return new AutoValue_SpannerIO_Write.Builder().setSpannerConfig(SpannerConfig.create()).setBatchSizeBytes(0x100000L).setMaxNumMutations(5000L).setMaxNumRows(500L).setFailureMode(FailureMode.FAIL_FAST).build();
    }

    public static @UnknownKeyFor @NonNull @Initialized ReadChangeStream readChangeStream() {
        return new AutoValue_SpannerIO_ReadChangeStream.Builder().setSpannerConfig(SpannerConfig.create()).setChangeStreamName("").setRpcPriority(ChangeStreamsConstants.DEFAULT_RPC_PRIORITY).setInclusiveStartAt(ChangeStreamsConstants.DEFAULT_INCLUSIVE_START_AT).setInclusiveEndAt(ChangeStreamsConstants.DEFAULT_INCLUSIVE_END_AT).build();
    }

    private static @UnknownKeyFor @NonNull @Initialized Dialect getDialect(@UnknownKeyFor @NonNull @Initialized SpannerConfig spannerConfig) {
        DatabaseClient databaseClient = SpannerAccessor.getOrCreate(spannerConfig).getDatabaseClient();
        return databaseClient.getDialect();
    }

    private SpannerIO() {
    }

    private static @UnknownKeyFor @NonNull @Initialized HashMap<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> buildServiceCallMetricLabels(@UnknownKeyFor @NonNull @Initialized SpannerConfig config) {
        HashMap<String, String> baseLabels = new HashMap<String, String>();
        baseLabels.put("PTRANSFORM", "");
        baseLabels.put("SERVICE", "Spanner");
        baseLabels.put("SPANNER_PROJECT_ID", config.getProjectId() == null || config.getProjectId().get() == null || ((String)config.getProjectId().get()).isEmpty() ? SpannerOptions.getDefaultProjectId() : (String)config.getProjectId().get());
        baseLabels.put("SPANNER_INSTANCE_ID", (String)config.getInstanceId().get());
        baseLabels.put("SPANNER_DATABASE_ID", (String)config.getDatabaseId().get());
        return baseLabels;
    }

    @VisibleForTesting
    static class WriteToSpannerFn
    extends DoFn<Iterable<MutationGroup>, Void> {
        private final @UnknownKeyFor @NonNull @Initialized SpannerConfig spannerConfig;
        private final @UnknownKeyFor @NonNull @Initialized FailureMode failureMode;
        private transient @UnknownKeyFor @NonNull @Initialized SpannerAccessor spannerAccessor;
        private static final @UnknownKeyFor @NonNull @Initialized int ABORTED_RETRY_ATTEMPTS = 5;
        private final @UnknownKeyFor @NonNull @Initialized String schemaChangeErrString = "Transaction aborted. Database schema probably changed during transaction, retry may succeed.";
        private final @UnknownKeyFor @NonNull @Initialized String emulatorErrorString = "The emulator only supports one transaction at a time.";
        @VisibleForTesting
        static @UnknownKeyFor @NonNull @Initialized Sleeper sleeper = Sleeper.DEFAULT;
        private final @UnknownKeyFor @NonNull @Initialized Counter mutationGroupBatchesReceived = Metrics.counter(WriteGrouped.class, (String)"mutation_group_batches_received");
        private final @UnknownKeyFor @NonNull @Initialized Counter mutationGroupBatchesWriteSuccess = Metrics.counter(WriteGrouped.class, (String)"mutation_group_batches_write_success");
        private final @UnknownKeyFor @NonNull @Initialized Counter mutationGroupBatchesWriteFail = Metrics.counter(WriteGrouped.class, (String)"mutation_group_batches_write_fail");
        private final @UnknownKeyFor @NonNull @Initialized Counter mutationGroupsReceived = Metrics.counter(WriteGrouped.class, (String)"mutation_groups_received");
        private final @UnknownKeyFor @NonNull @Initialized Counter mutationGroupsWriteSuccess = Metrics.counter(WriteGrouped.class, (String)"mutation_groups_write_success");
        private final @UnknownKeyFor @NonNull @Initialized Counter mutationGroupsWriteFail = Metrics.counter(WriteGrouped.class, (String)"mutation_groups_write_fail");
        private final @UnknownKeyFor @NonNull @Initialized Counter spannerWriteSuccess = Metrics.counter(WriteGrouped.class, (String)"spanner_write_success");
        private final @UnknownKeyFor @NonNull @Initialized Counter spannerWriteFail = Metrics.counter(WriteGrouped.class, (String)"spanner_write_fail");
        private final @UnknownKeyFor @NonNull @Initialized Distribution spannerWriteLatency = Metrics.distribution(WriteGrouped.class, (String)"spanner_write_latency_ms");
        private final @UnknownKeyFor @NonNull @Initialized Counter spannerWriteTimeouts = Metrics.counter(WriteGrouped.class, (String)"spanner_write_timeouts");
        private final @UnknownKeyFor @NonNull @Initialized Counter spannerWriteRetries = Metrics.counter(WriteGrouped.class, (String)"spanner_write_retries");
        private final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized MutationGroup> failedTag;
        private transient @UnknownKeyFor @NonNull @Initialized FluentBackoff bundleWriteBackoff;
        private transient @UnknownKeyFor @NonNull @Initialized LoadingCache<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized ServiceCallMetric> writeMetricsByTableName;

        WriteToSpannerFn(@UnknownKeyFor @NonNull @Initialized SpannerConfig spannerConfig, @UnknownKeyFor @NonNull @Initialized FailureMode failureMode, @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized MutationGroup> failedTag) {
            this.spannerConfig = spannerConfig;
            this.failureMode = failureMode;
            this.failedTag = failedTag;
        }

        @DoFn.Setup
        public void setup() {
            this.spannerAccessor = SpannerAccessor.getOrCreate(this.spannerConfig);
            this.bundleWriteBackoff = FluentBackoff.DEFAULT.withMaxCumulativeBackoff((Duration)this.spannerConfig.getMaxCumulativeBackoff().get()).withInitialBackoff(((Duration)this.spannerConfig.getMaxCumulativeBackoff().get()).dividedBy(60L));
            this.writeMetricsByTableName = CacheBuilder.newBuilder().maximumSize(100L).build((CacheLoader)new CacheLoader<String, ServiceCallMetric>(){

                public @UnknownKeyFor @NonNull @Initialized ServiceCallMetric load(@UnknownKeyFor @NonNull @Initialized String tableName) {
                    return WriteToSpannerFn.buildWriteServiceCallMetric(spannerConfig, tableName);
                }
            });
        }

        @DoFn.Teardown
        public void teardown() {
            this.spannerAccessor.close();
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) throws @UnknownKeyFor @NonNull @Initialized Exception {
            ImmutableList mutations = ImmutableList.copyOf((Iterable)((Iterable)c.element()));
            try {
                this.mutationGroupBatchesReceived.inc();
                this.mutationGroupsReceived.inc((long)mutations.size());
                Iterable batch = Iterables.concat((Iterable)mutations);
                this.writeMutations(batch);
                this.mutationGroupBatchesWriteSuccess.inc();
                this.mutationGroupsWriteSuccess.inc((long)mutations.size());
                return;
            }
            catch (SpannerException e) {
                this.mutationGroupBatchesWriteFail.inc();
                if (this.failureMode != FailureMode.REPORT_FAILURES) {
                    if (this.failureMode == FailureMode.FAIL_FAST) {
                        this.mutationGroupsWriteFail.inc((long)mutations.size());
                        LOG.error("Failed to write a batch of mutation groups", (Throwable)e);
                        throw e;
                    }
                    throw new IllegalArgumentException("Unknown failure mode " + (Object)((Object)this.failureMode));
                }
                for (MutationGroup mg : mutations) {
                    try {
                        this.spannerWriteRetries.inc();
                        this.writeMutations(mg);
                        this.mutationGroupsWriteSuccess.inc();
                    }
                    catch (SpannerException e2) {
                        this.mutationGroupsWriteFail.inc();
                        LOG.warn("Failed to write the mutation group: " + mg, (Throwable)e2);
                        c.output(this.failedTag, (Object)mg);
                    }
                }
                return;
            }
        }

        private void spannerWriteWithRetryIfSchemaChange(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Mutation> batch) throws @UnknownKeyFor @NonNull @Initialized SpannerException {
            int retry = 1;
            while (true) {
                try {
                    if (this.spannerConfig.getRpcPriority() != null && this.spannerConfig.getRpcPriority().get() != null) {
                        this.spannerAccessor.getDatabaseClient().writeAtLeastOnceWithOptions(batch, new Options.TransactionOption[]{Options.priority((Options.RpcPriority)((Options.RpcPriority)this.spannerConfig.getRpcPriority().get()))});
                    } else {
                        this.spannerAccessor.getDatabaseClient().writeAtLeastOnce(batch);
                    }
                    this.reportServiceCallMetricsForBatch(batch, "ok");
                    return;
                }
                catch (AbortedException e) {
                    this.reportServiceCallMetricsForBatch(batch, e.getErrorCode().getGrpcStatusCode().toString());
                    if (retry >= 5) {
                        throw e;
                    }
                    if (!(e.isRetryable() || e.getMessage().contains("Transaction aborted. Database schema probably changed during transaction, retry may succeed.") || e.getMessage().contains("The emulator only supports one transaction at a time."))) {
                        throw e;
                    }
                }
                catch (SpannerException e) {
                    this.reportServiceCallMetricsForBatch(batch, e.getErrorCode().getGrpcStatusCode().toString());
                    throw e;
                }
                ++retry;
            }
        }

        private void reportServiceCallMetricsForBatch(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized Mutation> batch, @UnknownKeyFor @NonNull @Initialized String statusCode) {
            Set tableNames = batch.stream().map(Mutation::getTable).collect(Collectors.toSet());
            for (String tableName : tableNames) {
                ((ServiceCallMetric)this.writeMetricsByTableName.getUnchecked((Object)tableName)).call(statusCode);
            }
        }

        private static @UnknownKeyFor @NonNull @Initialized ServiceCallMetric buildWriteServiceCallMetric(@UnknownKeyFor @NonNull @Initialized SpannerConfig config, @UnknownKeyFor @NonNull @Initialized String tableId) {
            HashMap baseLabels = SpannerIO.buildServiceCallMetricLabels(config);
            baseLabels.put("METHOD", "Write");
            baseLabels.put("RESOURCE", GcpResourceIdentifiers.spannerTable((String)((String)baseLabels.get("SPANNER_PROJECT_ID")), (String)((String)config.getInstanceId().get()), (String)((String)config.getDatabaseId().get()), (String)tableId));
            baseLabels.put("TABLE_ID", tableId);
            return new ServiceCallMetric(MonitoringInfoConstants.Urns.API_REQUEST_COUNT, baseLabels);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeMutations(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized Mutation> mutationIterable) throws @UnknownKeyFor @NonNull @Initialized SpannerException, @UnknownKeyFor @NonNull @Initialized IOException {
            BackOff backoff = this.bundleWriteBackoff.backoff();
            ImmutableList mutations = ImmutableList.copyOf(mutationIterable);
            while (true) {
                Stopwatch timer = Stopwatch.createStarted();
                try {
                    this.spannerWriteWithRetryIfSchemaChange((List<Mutation>)mutations);
                    this.spannerWriteSuccess.inc();
                    return;
                }
                catch (SpannerException exception) {
                    if (exception.getErrorCode() == ErrorCode.DEADLINE_EXCEEDED) {
                        this.spannerWriteTimeouts.inc();
                        long sleepTimeMsecs = backoff.nextBackOffMillis();
                        if (sleepTimeMsecs == -1L) {
                            LOG.error("DEADLINE_EXCEEDED writing batch of {} mutations to Cloud Spanner. Aborting after too many retries.", (Object)mutations.size());
                            this.spannerWriteFail.inc();
                            throw exception;
                        }
                        LOG.info("DEADLINE_EXCEEDED writing batch of {} mutations to Cloud Spanner, retrying after backoff of {}ms\n({})", new Object[]{mutations.size(), sleepTimeMsecs, exception.getMessage()});
                        this.spannerWriteRetries.inc();
                        try {
                            sleeper.sleep(sleepTimeMsecs);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    this.spannerWriteFail.inc();
                    throw exception;
                }
                finally {
                    this.spannerWriteLatency.update(timer.elapsed(TimeUnit.MILLISECONDS));
                    continue;
                }
                break;
            }
        }
    }

    @VisibleForTesting
    static class BatchableMutationFilterFn
    extends DoFn<MutationGroup, MutationGroup> {
        private final @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized SpannerSchema> schemaView;
        private final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized MutationGroup>> unbatchableMutationsTag;
        private final @UnknownKeyFor @NonNull @Initialized long batchSizeBytes;
        private final @UnknownKeyFor @NonNull @Initialized long maxNumMutations;
        private final @UnknownKeyFor @NonNull @Initialized long maxNumRows;
        private final @UnknownKeyFor @NonNull @Initialized Counter batchableMutationGroupsCounter = Metrics.counter(WriteGrouped.class, (String)"batchable_mutation_groups");
        private final @UnknownKeyFor @NonNull @Initialized Counter unBatchableMutationGroupsCounter = Metrics.counter(WriteGrouped.class, (String)"unbatchable_mutation_groups");

        BatchableMutationFilterFn(@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized SpannerSchema> schemaView, @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized MutationGroup>> unbatchableMutationsTag, @UnknownKeyFor @NonNull @Initialized long batchSizeBytes, @UnknownKeyFor @NonNull @Initialized long maxNumMutations, @UnknownKeyFor @NonNull @Initialized long maxNumRows) {
            this.schemaView = schemaView;
            this.unbatchableMutationsTag = unbatchableMutationsTag;
            this.batchSizeBytes = batchSizeBytes;
            this.maxNumMutations = maxNumMutations;
            this.maxNumRows = maxNumRows;
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) {
            MutationGroup mg = (MutationGroup)c.element();
            if (mg.primary().getOperation() == Mutation.Op.DELETE && !MutationUtils.isPointDelete(mg.primary())) {
                c.output(this.unbatchableMutationsTag, Arrays.asList(mg));
                this.unBatchableMutationGroupsCounter.inc();
                return;
            }
            SpannerSchema spannerSchema = (SpannerSchema)c.sideInput(this.schemaView);
            long groupSize = MutationSizeEstimator.sizeOf(mg);
            long groupCells = MutationCellCounter.countOf(spannerSchema, mg);
            long groupRows = Iterables.size((Iterable)mg);
            if (groupSize >= this.batchSizeBytes || groupCells >= this.maxNumMutations || groupRows >= this.maxNumRows) {
                c.output(this.unbatchableMutationsTag, Arrays.asList(mg));
                this.unBatchableMutationGroupsCounter.inc();
            } else {
                c.output((Object)mg);
                this.batchableMutationGroupsCounter.inc();
            }
        }
    }

    @VisibleForTesting
    static class GatherSortCreateBatchesFn
    extends DoFn<MutationGroup, Iterable<MutationGroup>> {
        private final @UnknownKeyFor @NonNull @Initialized long maxBatchSizeBytes;
        private final @UnknownKeyFor @NonNull @Initialized long maxBatchNumMutations;
        private final @UnknownKeyFor @NonNull @Initialized long maxBatchNumRows;
        private final @UnknownKeyFor @NonNull @Initialized long maxSortableSizeBytes;
        private final @UnknownKeyFor @NonNull @Initialized long maxSortableNumMutations;
        private final @UnknownKeyFor @NonNull @Initialized long maxSortableNumRows;
        private final @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized SpannerSchema> schemaView;
        private final @UnknownKeyFor @NonNull @Initialized ArrayList<@UnknownKeyFor @NonNull @Initialized MutationGroupContainer> mutationsToSort = new ArrayList();
        private @UnknownKeyFor @NonNull @Initialized long sortableSizeBytes = 0L;
        private @UnknownKeyFor @NonNull @Initialized long sortableNumCells = 0L;
        private @UnknownKeyFor @NonNull @Initialized long sortableNumRows = 0L;

        GatherSortCreateBatchesFn(@UnknownKeyFor @NonNull @Initialized long maxBatchSizeBytes, @UnknownKeyFor @NonNull @Initialized long maxNumMutations, @UnknownKeyFor @NonNull @Initialized long maxNumRows, @UnknownKeyFor @NonNull @Initialized long groupingFactor, @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized SpannerSchema> schemaView) {
            this.maxBatchSizeBytes = maxBatchSizeBytes;
            this.maxBatchNumMutations = maxNumMutations;
            this.maxBatchNumRows = maxNumRows;
            if (groupingFactor <= 0L) {
                groupingFactor = 1L;
            }
            this.maxSortableSizeBytes = maxBatchSizeBytes * groupingFactor;
            this.maxSortableNumMutations = maxNumMutations * groupingFactor;
            this.maxSortableNumRows = maxNumRows * groupingFactor;
            this.schemaView = schemaView;
            this.initSorter();
        }

        private synchronized void initSorter() {
            this.mutationsToSort.clear();
            this.sortableSizeBytes = 0L;
            this.sortableNumCells = 0L;
            this.sortableNumRows = 0L;
        }

        @DoFn.FinishBundle
        public synchronized void finishBundle(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized FinishBundleContext c) throws @UnknownKeyFor @NonNull @Initialized Exception {
            this.sortAndOutputBatches(new OutputReceiverForFinishBundle(c));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void sortAndOutputBatches(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized MutationGroup>> out) throws @UnknownKeyFor @NonNull @Initialized IOException {
            try {
                if (this.mutationsToSort.isEmpty()) {
                    return;
                }
                if (this.maxSortableNumMutations == this.maxBatchNumMutations) {
                    this.outputBatch(out, 0, this.mutationsToSort.size());
                    return;
                }
                this.mutationsToSort.sort(Comparator.naturalOrder());
                int batchStart = 0;
                int batchEnd = 0;
                long batchSizeBytes = 0L;
                long batchCells = 0L;
                long batchRows = 0L;
                while (batchEnd < this.mutationsToSort.size()) {
                    MutationGroupContainer mg = this.mutationsToSort.get(batchEnd);
                    if (batchCells + mg.numCells > this.maxBatchNumMutations || batchSizeBytes + mg.sizeBytes > this.maxBatchSizeBytes || batchRows + mg.numRows > this.maxBatchNumRows) {
                        this.outputBatch(out, batchStart, batchEnd);
                        batchStart = batchEnd;
                        batchSizeBytes = 0L;
                        batchCells = 0L;
                        batchRows = 0L;
                    }
                    ++batchEnd;
                    batchSizeBytes += mg.sizeBytes;
                    batchCells += mg.numCells;
                    batchRows += mg.numRows;
                }
                if (batchStart < batchEnd) {
                    this.outputBatch(out, batchStart, this.mutationsToSort.size());
                }
            }
            finally {
                this.initSorter();
            }
        }

        private void outputBatch(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized MutationGroup>> out, @UnknownKeyFor @NonNull @Initialized int batchStart, @UnknownKeyFor @NonNull @Initialized int batchEnd) {
            out.output((Object)this.mutationsToSort.subList(batchStart, batchEnd).stream().map(o -> o.mutationGroup).collect(Collectors.toList()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @DoFn.ProcessElement
        public synchronized void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized MutationGroup>> out) throws @UnknownKeyFor @NonNull @Initialized Exception {
            SpannerSchema spannerSchema = (SpannerSchema)c.sideInput(this.schemaView);
            MutationKeyEncoder encoder = new MutationKeyEncoder(spannerSchema);
            MutationGroup mg = (MutationGroup)c.element();
            long groupSize = MutationSizeEstimator.sizeOf(mg);
            long groupCells = MutationCellCounter.countOf(spannerSchema, mg);
            long groupRows = mg.size();
            GatherSortCreateBatchesFn gatherSortCreateBatchesFn = this;
            synchronized (gatherSortCreateBatchesFn) {
                if (this.sortableNumCells + groupCells > this.maxSortableNumMutations || this.sortableSizeBytes + groupSize > this.maxSortableSizeBytes || this.sortableNumRows + groupRows > this.maxSortableNumRows) {
                    this.sortAndOutputBatches(out);
                }
                this.mutationsToSort.add(new MutationGroupContainer(mg, groupSize, groupCells, groupRows, encoder.encodeTableNameAndKey(mg.primary())));
                this.sortableSizeBytes += groupSize;
                this.sortableNumCells += groupCells;
                this.sortableNumRows += groupRows;
            }
        }

        private static class OutputReceiverForFinishBundle
        implements DoFn.OutputReceiver<Iterable<MutationGroup>> {
            private final /*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized FinishBundleContext c;

            OutputReceiverForFinishBundle(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized FinishBundleContext c) {
                this.c = c;
            }

            public void output(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized MutationGroup> output) {
                this.outputWithTimestamp(output, Instant.now());
            }

            public void outputWithTimestamp(@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized MutationGroup> output, @UnknownKeyFor @NonNull @Initialized Instant timestamp) {
                this.c.output(output, timestamp, (BoundedWindow)GlobalWindow.INSTANCE);
            }
        }

        private static final class MutationGroupContainer
        implements Comparable<MutationGroupContainer> {
            final @UnknownKeyFor @NonNull @Initialized MutationGroup mutationGroup;
            final @UnknownKeyFor @NonNull @Initialized long sizeBytes;
            final @UnknownKeyFor @NonNull @Initialized long numCells;
            final @UnknownKeyFor @NonNull @Initialized long numRows;
            final @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] encodedKey;

            MutationGroupContainer(@UnknownKeyFor @NonNull @Initialized MutationGroup mutationGroup, @UnknownKeyFor @NonNull @Initialized long sizeBytes, @UnknownKeyFor @NonNull @Initialized long numCells, @UnknownKeyFor @NonNull @Initialized long numRows, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] encodedKey) {
                this.mutationGroup = mutationGroup;
                this.sizeBytes = sizeBytes;
                this.numCells = numCells;
                this.numRows = numRows;
                this.encodedKey = encodedKey;
            }

            @Override
            @Pure
            public @UnknownKeyFor @NonNull @Initialized int compareTo(@UnknownKeyFor @NonNull @Initialized MutationGroupContainer o) {
                return UnsignedBytes.lexicographicalComparator().compare(this.encodedKey, o.encodedKey);
            }
        }
    }

    private static class ToMutationGroupFn
    extends DoFn<Mutation, MutationGroup> {
        private ToMutationGroupFn() {
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext c) {
            Mutation value = (Mutation)c.element();
            c.output((Object)MutationGroup.create(value, new Mutation[0]));
        }
    }

    public static interface SpannerChangeStreamOptions
    extends StreamingOptions {
        public @UnknownKeyFor @NonNull @Initialized String getMetadataTable();

        public void setMetadataTable(@UnknownKeyFor @NonNull @Initialized String var1);
    }

    @AutoValue
    public static abstract class ReadChangeStream
    extends PTransform<PBegin, PCollection<DataChangeRecord>> {
        abstract @UnknownKeyFor @NonNull @Initialized SpannerConfig getSpannerConfig();

        abstract @UnknownKeyFor @NonNull @Initialized String getChangeStreamName();

        abstract @Nullable @UnknownKeyFor @Initialized String getMetadataInstance();

        abstract @Nullable @UnknownKeyFor @Initialized String getMetadataDatabase();

        abstract @Nullable @UnknownKeyFor @Initialized String getMetadataTable();

        abstract @UnknownKeyFor @NonNull @Initialized Timestamp getInclusiveStartAt();

        abstract @Nullable @UnknownKeyFor @Initialized Timestamp getInclusiveEndAt();

        abstract // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable @UnknownKeyFor @Initialized Options.RpcPriority getRpcPriority();

        @Deprecated
        abstract @Nullable @UnknownKeyFor @Initialized Double getTraceSampleProbability();

        abstract @UnknownKeyFor @NonNull @Initialized Builder toBuilder();

        public @UnknownKeyFor @NonNull @Initialized ReadChangeStream withSpannerConfig(@UnknownKeyFor @NonNull @Initialized SpannerConfig spannerConfig) {
            return this.toBuilder().setSpannerConfig(spannerConfig).build();
        }

        public @UnknownKeyFor @NonNull @Initialized ReadChangeStream withProjectId(@UnknownKeyFor @NonNull @Initialized String projectId) {
            return this.withProjectId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)projectId));
        }

        public @UnknownKeyFor @NonNull @Initialized ReadChangeStream withProjectId(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> projectId) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withProjectId(projectId));
        }

        public @UnknownKeyFor @NonNull @Initialized ReadChangeStream withInstanceId(@UnknownKeyFor @NonNull @Initialized String instanceId) {
            return this.withInstanceId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)instanceId));
        }

        public @UnknownKeyFor @NonNull @Initialized ReadChangeStream withInstanceId(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> instanceId) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withInstanceId(instanceId));
        }

        public @UnknownKeyFor @NonNull @Initialized ReadChangeStream withDatabaseId(@UnknownKeyFor @NonNull @Initialized String databaseId) {
            return this.withDatabaseId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)databaseId));
        }

        public @UnknownKeyFor @NonNull @Initialized ReadChangeStream withDatabaseId(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> databaseId) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withDatabaseId(databaseId));
        }

        public @UnknownKeyFor @NonNull @Initialized ReadChangeStream withChangeStreamName(@UnknownKeyFor @NonNull @Initialized String changeStreamName) {
            return this.toBuilder().setChangeStreamName(changeStreamName).build();
        }

        public @UnknownKeyFor @NonNull @Initialized ReadChangeStream withMetadataInstance(@UnknownKeyFor @NonNull @Initialized String metadataInstance) {
            return this.toBuilder().setMetadataInstance(metadataInstance).build();
        }

        public @UnknownKeyFor @NonNull @Initialized ReadChangeStream withMetadataDatabase(@UnknownKeyFor @NonNull @Initialized String metadataDatabase) {
            return this.toBuilder().setMetadataDatabase(metadataDatabase).build();
        }

        public @UnknownKeyFor @NonNull @Initialized ReadChangeStream withMetadataTable(@UnknownKeyFor @NonNull @Initialized String metadataTable) {
            return this.toBuilder().setMetadataTable(metadataTable).build();
        }

        public @UnknownKeyFor @NonNull @Initialized ReadChangeStream withInclusiveStartAt(@UnknownKeyFor @NonNull @Initialized Timestamp timestamp) {
            return this.toBuilder().setInclusiveStartAt(timestamp).build();
        }

        public @UnknownKeyFor @NonNull @Initialized ReadChangeStream withInclusiveEndAt(@UnknownKeyFor @NonNull @Initialized Timestamp timestamp) {
            return this.toBuilder().setInclusiveEndAt(timestamp).build();
        }

        public @UnknownKeyFor @NonNull @Initialized ReadChangeStream withRpcPriority(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Options.RpcPriority rpcPriority) {
            return this.toBuilder().setRpcPriority(rpcPriority).build();
        }

        @Deprecated
        public @UnknownKeyFor @NonNull @Initialized ReadChangeStream withTraceSampleProbability(@UnknownKeyFor @NonNull @Initialized Double probability) {
            return this.toBuilder().setTraceSampleProbability(probability).build();
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized DataChangeRecord> expand(@UnknownKeyFor @NonNull @Initialized PBegin input) {
            Preconditions.checkArgument((this.getSpannerConfig() != null ? 1 : 0) != 0, (Object)"SpannerIO.readChangeStream() requires the spanner config to be set.");
            Preconditions.checkArgument((this.getSpannerConfig().getProjectId() != null ? 1 : 0) != 0, (Object)"SpannerIO.readChangeStream() requires the project ID to be set.");
            Preconditions.checkArgument((this.getSpannerConfig().getInstanceId() != null ? 1 : 0) != 0, (Object)"SpannerIO.readChangeStream() requires the instance ID to be set.");
            Preconditions.checkArgument((this.getSpannerConfig().getDatabaseId() != null ? 1 : 0) != 0, (Object)"SpannerIO.readChangeStream() requires the database ID to be set.");
            Preconditions.checkArgument((this.getChangeStreamName() != null ? 1 : 0) != 0, (Object)"SpannerIO.readChangeStream() requires the name of the change stream to be set.");
            Preconditions.checkArgument((this.getInclusiveStartAt() != null ? 1 : 0) != 0, (Object)"SpannerIO.readChangeStream() requires the start time to be set.");
            Preconditions.checkArgument((this.getInclusiveEndAt() != null ? 1 : 0) != 0, (Object)"SpannerIO.readChangeStream() requires the end time to be set. If you'd like to process the stream without an end time, you can omit this parameter.");
            if (this.getMetadataInstance() != null) {
                Preconditions.checkArgument((this.getMetadataDatabase() != null ? 1 : 0) != 0, (Object)"SpannerIO.readChangeStream() requires the metadata database to be set if metadata instance is set.");
            }
            if (this.getInclusiveEndAt() != null && this.getInclusiveStartAt().toSqlTimestamp().after(this.getInclusiveEndAt().toSqlTimestamp())) {
                throw new IllegalArgumentException("Start time cannot be after end time.");
            }
            DatabaseId changeStreamDatabaseId = DatabaseId.of((String)((String)this.getSpannerConfig().getProjectId().get()), (String)((String)this.getSpannerConfig().getInstanceId().get()), (String)((String)this.getSpannerConfig().getDatabaseId().get()));
            String partitionMetadataInstanceId = (String)MoreObjects.firstNonNull((Object)this.getMetadataInstance(), (Object)changeStreamDatabaseId.getInstanceId().getInstance());
            String partitionMetadataDatabaseId = (String)MoreObjects.firstNonNull((Object)this.getMetadataDatabase(), (Object)changeStreamDatabaseId.getDatabase());
            DatabaseId fullPartitionMetadataDatabaseId = DatabaseId.of((String)((String)this.getSpannerConfig().getProjectId().get()), (String)partitionMetadataInstanceId, (String)partitionMetadataDatabaseId);
            SpannerConfig changeStreamSpannerConfig = this.getSpannerConfig();
            if (changeStreamSpannerConfig.getRetryableCodes() == null) {
                ImmutableSet defaultRetryableCodes = ImmutableSet.of((Object)StatusCode.Code.UNAVAILABLE, (Object)StatusCode.Code.ABORTED);
                changeStreamSpannerConfig = changeStreamSpannerConfig.toBuilder().setRetryableCodes((ImmutableSet<StatusCode.Code>)defaultRetryableCodes).build();
            }
            if (changeStreamSpannerConfig.getExecuteStreamingSqlRetrySettings() == null) {
                changeStreamSpannerConfig = changeStreamSpannerConfig.toBuilder().setExecuteStreamingSqlRetrySettings(RetrySettings.newBuilder().setTotalTimeout(org.threeten.bp.Duration.ofMinutes((long)5L)).setInitialRpcTimeout(org.threeten.bp.Duration.ofMinutes((long)1L)).setMaxRpcTimeout(org.threeten.bp.Duration.ofMinutes((long)1L)).build()).build();
            }
            SpannerConfig partitionMetadataSpannerConfig = MetadataSpannerConfigFactory.create(changeStreamSpannerConfig, partitionMetadataInstanceId, partitionMetadataDatabaseId);
            Dialect changeStreamDatabaseDialect = SpannerIO.getDialect(changeStreamSpannerConfig);
            Dialect metadataDatabaseDialect = SpannerIO.getDialect(partitionMetadataSpannerConfig);
            LOG.info("The Spanner database " + changeStreamDatabaseId + " has dialect " + changeStreamDatabaseDialect);
            LOG.info("The Spanner database " + fullPartitionMetadataDatabaseId + " has dialect " + metadataDatabaseDialect);
            String partitionMetadataTableName = (String)MoreObjects.firstNonNull((Object)this.getMetadataTable(), (Object)NameGenerator.generatePartitionMetadataTableName(partitionMetadataDatabaseId));
            String changeStreamName = this.getChangeStreamName();
            Timestamp startTimestamp = this.getInclusiveStartAt();
            Timestamp endTimestamp = this.getInclusiveEndAt().compareTo(ChangeStreamsConstants.MAX_INCLUSIVE_END_AT) > 0 ? ChangeStreamsConstants.MAX_INCLUSIVE_END_AT : this.getInclusiveEndAt();
            MapperFactory mapperFactory = new MapperFactory(changeStreamDatabaseDialect);
            ChangeStreamMetrics metrics = new ChangeStreamMetrics();
            Options.RpcPriority rpcPriority = (Options.RpcPriority)MoreObjects.firstNonNull((Object)this.getRpcPriority(), (Object)Options.RpcPriority.HIGH);
            DaoFactory daoFactory = new DaoFactory(changeStreamSpannerConfig, changeStreamName, partitionMetadataSpannerConfig, partitionMetadataTableName, rpcPriority, input.getPipeline().getOptions().getJobName(), changeStreamDatabaseDialect, metadataDatabaseDialect);
            ActionFactory actionFactory = new ActionFactory();
            InitializeDoFn initializeDoFn = new InitializeDoFn(daoFactory, mapperFactory, startTimestamp, endTimestamp);
            DetectNewPartitionsDoFn detectNewPartitionsDoFn = new DetectNewPartitionsDoFn(daoFactory, mapperFactory, actionFactory, metrics);
            ReadChangeStreamPartitionDoFn readChangeStreamPartitionDoFn = new ReadChangeStreamPartitionDoFn(daoFactory, mapperFactory, actionFactory, metrics);
            PostProcessingMetricsDoFn postProcessingMetricsDoFn = new PostProcessingMetricsDoFn(metrics);
            LOG.info("Partition metadata table that will be used is " + partitionMetadataTableName);
            ((SpannerChangeStreamOptions)input.getPipeline().getOptions().as(SpannerChangeStreamOptions.class)).setMetadataTable(partitionMetadataTableName);
            PCollection impulseOut = (PCollection)input.apply((PTransform)Impulse.create());
            PCollection partitionsOut = (PCollection)((PCollection)impulseOut.apply("Initialize the connector", (PTransform)ParDo.of((DoFn)initializeDoFn))).apply("Detect new partitions", (PTransform)ParDo.of((DoFn)detectNewPartitionsDoFn));
            Coder partitionMetadataCoder = partitionsOut.getCoder();
            SizeEstimator<PartitionMetadata> partitionMetadataSizeEstimator = new SizeEstimator<PartitionMetadata>(partitionMetadataCoder);
            long averagePartitionBytesSize = partitionMetadataSizeEstimator.sizeOf(ChangeStreamsConstants.SAMPLE_PARTITION);
            detectNewPartitionsDoFn.setAveragePartitionBytesSize(averagePartitionBytesSize);
            PCollection dataChangeRecordsOut = (PCollection)((PCollection)partitionsOut.apply("Read change stream partition", (PTransform)ParDo.of((DoFn)readChangeStreamPartitionDoFn))).apply("Gather metrics", (PTransform)ParDo.of((DoFn)postProcessingMetricsDoFn));
            Coder dataChangeRecordCoder = dataChangeRecordsOut.getCoder();
            SizeEstimator dataChangeRecordSizeEstimator = new SizeEstimator(dataChangeRecordCoder);
            BytesThroughputEstimator<DataChangeRecord> throughputEstimator = new BytesThroughputEstimator<DataChangeRecord>(10, dataChangeRecordSizeEstimator);
            readChangeStreamPartitionDoFn.setThroughputEstimator(throughputEstimator);
            ((PCollection)((PCollection)impulseOut.apply((PTransform)WithTimestamps.of((SerializableFunction & Serializable)e -> GlobalWindow.INSTANCE.maxTimestamp()))).apply((PTransform)Wait.on((PCollection[])new PCollection[]{dataChangeRecordsOut}))).apply((PTransform)ParDo.of((DoFn)new CleanUpReadChangeStreamDoFn(daoFactory)));
            return dataChangeRecordsOut;
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder setSpannerConfig(@UnknownKeyFor @NonNull @Initialized SpannerConfig var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setChangeStreamName(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setMetadataInstance(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setMetadataDatabase(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setMetadataTable(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setInclusiveStartAt(@UnknownKeyFor @NonNull @Initialized Timestamp var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setInclusiveEndAt(@UnknownKeyFor @NonNull @Initialized Timestamp var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setRpcPriority(// Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized Options.RpcPriority var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setTraceSampleProbability(@UnknownKeyFor @NonNull @Initialized Double var1);

            abstract @UnknownKeyFor @NonNull @Initialized ReadChangeStream build();
        }
    }

    public static class WriteGrouped
    extends PTransform<PCollection<MutationGroup>, SpannerWriteResult> {
        private final @UnknownKeyFor @NonNull @Initialized Write spec;
        private static final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized MutationGroup> BATCHABLE_MUTATIONS_TAG = new TupleTag<MutationGroup>("batchableMutations"){};
        private static final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized MutationGroup>> UNBATCHABLE_MUTATIONS_TAG = new TupleTag<Iterable<MutationGroup>>("unbatchableMutations"){};
        private static final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @Nullable @Initialized Void> MAIN_OUT_TAG = new TupleTag<Void>("mainOut"){};
        private static final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized MutationGroup> FAILED_MUTATIONS_TAG = new TupleTag<MutationGroup>("failedMutations"){};
        private static final @UnknownKeyFor @NonNull @Initialized SerializableCoder<@UnknownKeyFor @NonNull @Initialized MutationGroup> CODER = SerializableCoder.of(MutationGroup.class);

        public WriteGrouped(@UnknownKeyFor @NonNull @Initialized Write spec) {
            this.spec = spec;
        }

        public void populateDisplayData(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            this.spec.populateDisplayDataWithParamaters(builder);
        }

        public @UnknownKeyFor @NonNull @Initialized SpannerWriteResult expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized MutationGroup> input) {
            PCollection batches;
            PCollectionView dialectView = this.spec.getDialectView();
            if (dialectView == null) {
                dialectView = (PCollectionView)((PCollection)input.getPipeline().apply("CreateSingleton", (PTransform)Create.of((Object)Dialect.GOOGLE_STANDARD_SQL, (Object[])new Dialect[0]))).apply("As PCollectionView", (PTransform)View.asSingleton());
            }
            if (this.spec.getBatchSizeBytes() <= 1L || this.spec.getMaxNumMutations() <= 1L || this.spec.getMaxNumRows() <= 1L) {
                LOG.info("Batching of mutationGroups is disabled");
                TypeDescriptor<Iterable<MutationGroup>> descriptor = new TypeDescriptor<Iterable<MutationGroup>>(){};
                batches = (PCollection)input.apply((PTransform)MapElements.into((TypeDescriptor)descriptor).via(ImmutableList::of));
            } else {
                PCollection schemaSeed = (PCollection)input.getPipeline().apply("Create Seed", (PTransform)Create.of((Object)null, (Object[])new Void[0]));
                if (this.spec.getSchemaReadySignal() != null) {
                    schemaSeed = (PCollection)schemaSeed.apply("Wait for schema", (PTransform)Wait.on((PCollection[])new PCollection[]{this.spec.getSchemaReadySignal()}));
                }
                PCollectionView schemaView = (PCollectionView)((PCollection)schemaSeed.apply("Read information schema", (PTransform)ParDo.of((DoFn)new ReadSpannerSchema(this.spec.getSpannerConfig(), (PCollectionView<Dialect>)dialectView)).withSideInputs(new PCollectionView[]{dialectView}))).apply("Schema View", (PTransform)View.asSingleton());
                PCollectionTuple filteredMutations = (PCollectionTuple)((PCollection)input.apply("RewindowIntoGlobal", (PTransform)Window.into((WindowFn)new GlobalWindows()).triggering((Trigger)DefaultTrigger.of()).discardingFiredPanes())).apply("Filter Unbatchable Mutations", (PTransform)ParDo.of((DoFn)new BatchableMutationFilterFn((PCollectionView<SpannerSchema>)schemaView, UNBATCHABLE_MUTATIONS_TAG, this.spec.getBatchSizeBytes(), this.spec.getMaxNumMutations(), this.spec.getMaxNumRows())).withSideInputs(new PCollectionView[]{schemaView}).withOutputTags(BATCHABLE_MUTATIONS_TAG, TupleTagList.of(UNBATCHABLE_MUTATIONS_TAG)));
                PCollection batchedMutations = (PCollection)filteredMutations.get(BATCHABLE_MUTATIONS_TAG).apply("Gather Sort And Create Batches", (PTransform)ParDo.of((DoFn)new GatherSortCreateBatchesFn(this.spec.getBatchSizeBytes(), this.spec.getMaxNumMutations(), this.spec.getMaxNumRows(), this.spec.getGroupingFactor().orElse(input.isBounded() == PCollection.IsBounded.BOUNDED ? 1000 : 1), (PCollectionView<SpannerSchema>)schemaView)).withSideInputs(new PCollectionView[]{schemaView}));
                batches = (PCollection)PCollectionList.of((PCollection)filteredMutations.get(UNBATCHABLE_MUTATIONS_TAG)).and(batchedMutations).apply("Merge", (PTransform)Flatten.pCollections());
            }
            PCollectionTuple result = (PCollectionTuple)batches.apply("Write batches to Spanner", (PTransform)ParDo.of((DoFn)new WriteToSpannerFn(this.spec.getSpannerConfig(), this.spec.getFailureMode(), FAILED_MUTATIONS_TAG)).withOutputTags(MAIN_OUT_TAG, TupleTagList.of(FAILED_MUTATIONS_TAG)));
            return new SpannerWriteResult(input.getPipeline(), (PCollection<Void>)result.get(MAIN_OUT_TAG), (PCollection<MutationGroup>)result.get(FAILED_MUTATIONS_TAG), FAILED_MUTATIONS_TAG);
        }

        @VisibleForTesting
        static @UnknownKeyFor @NonNull @Initialized MutationGroup decode(@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] bytes) {
            ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
            try {
                return (MutationGroup)CODER.decode((InputStream)bis);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @VisibleForTesting
        static @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] encode(@UnknownKeyFor @NonNull @Initialized MutationGroup g) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try {
                CODER.encode((Serializable)g, (OutputStream)bos);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return bos.toByteArray();
        }
    }

    static class WriteRows
    extends PTransform<PCollection<Row>, PDone> {
        private final @UnknownKeyFor @NonNull @Initialized Write write;
        private final // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Mutation.Op operation;
        private final @UnknownKeyFor @NonNull @Initialized String table;

        private WriteRows(@UnknownKeyFor @NonNull @Initialized Write write, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Mutation.Op operation, @UnknownKeyFor @NonNull @Initialized String table) {
            this.write = write;
            this.operation = operation;
            this.table = table;
        }

        public static @UnknownKeyFor @NonNull @Initialized WriteRows of(@UnknownKeyFor @NonNull @Initialized Write write, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Mutation.Op operation, @UnknownKeyFor @NonNull @Initialized String table) {
            return new WriteRows(write, operation, table);
        }

        public @UnknownKeyFor @NonNull @Initialized PDone expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> input) {
            ((PCollection)input.apply((PTransform)MapElements.into((TypeDescriptor)TypeDescriptor.of(Mutation.class)).via(MutationUtils.beamRowToMutationFn(this.operation, this.table)))).apply((PTransform)this.write);
            return PDone.in((Pipeline)input.getPipeline());
        }
    }

    @AutoValue
    public static abstract class Write
    extends PTransform<PCollection<Mutation>, SpannerWriteResult> {
        abstract @UnknownKeyFor @NonNull @Initialized SpannerConfig getSpannerConfig();

        abstract @UnknownKeyFor @NonNull @Initialized long getBatchSizeBytes();

        abstract @UnknownKeyFor @NonNull @Initialized long getMaxNumMutations();

        abstract @UnknownKeyFor @NonNull @Initialized long getMaxNumRows();

        abstract @UnknownKeyFor @NonNull @Initialized FailureMode getFailureMode();

        abstract /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @Nullable @UnknownKeyFor @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> getSchemaReadySignal();

        abstract @UnknownKeyFor @NonNull @Initialized OptionalInt getGroupingFactor();

        abstract @Nullable @UnknownKeyFor @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Dialect> getDialectView();

        abstract @UnknownKeyFor @NonNull @Initialized Builder toBuilder();

        public @UnknownKeyFor @NonNull @Initialized Write withSpannerConfig(@UnknownKeyFor @NonNull @Initialized SpannerConfig spannerConfig) {
            return this.toBuilder().setSpannerConfig(spannerConfig).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write withProjectId(@UnknownKeyFor @NonNull @Initialized String projectId) {
            return this.withProjectId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)projectId));
        }

        public @UnknownKeyFor @NonNull @Initialized Write withProjectId(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> projectId) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withProjectId(projectId));
        }

        public @UnknownKeyFor @NonNull @Initialized Write withInstanceId(@UnknownKeyFor @NonNull @Initialized String instanceId) {
            return this.withInstanceId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)instanceId));
        }

        public @UnknownKeyFor @NonNull @Initialized Write withInstanceId(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> instanceId) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withInstanceId(instanceId));
        }

        public @UnknownKeyFor @NonNull @Initialized Write withDatabaseId(@UnknownKeyFor @NonNull @Initialized String databaseId) {
            return this.withDatabaseId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)databaseId));
        }

        public @UnknownKeyFor @NonNull @Initialized Write withDatabaseId(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> databaseId) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withDatabaseId(databaseId));
        }

        public @UnknownKeyFor @NonNull @Initialized Write withHost(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> host) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withHost(host));
        }

        public @UnknownKeyFor @NonNull @Initialized Write withHost(@UnknownKeyFor @NonNull @Initialized String host) {
            return this.withHost((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)host));
        }

        public @UnknownKeyFor @NonNull @Initialized Write withEmulatorHost(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> emulatorHost) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withEmulatorHost(emulatorHost));
        }

        public @UnknownKeyFor @NonNull @Initialized Write withEmulatorHost(@UnknownKeyFor @NonNull @Initialized String emulatorHost) {
            return this.withEmulatorHost((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)emulatorHost));
        }

        public @UnknownKeyFor @NonNull @Initialized Write withDialectView(@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Dialect> dialect) {
            return this.toBuilder().setDialectView(dialect).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write withCommitDeadline(@UnknownKeyFor @NonNull @Initialized Duration commitDeadline) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withCommitDeadline(commitDeadline));
        }

        public @UnknownKeyFor @NonNull @Initialized Write withMaxCumulativeBackoff(@UnknownKeyFor @NonNull @Initialized Duration maxCumulativeBackoff) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withMaxCumulativeBackoff(maxCumulativeBackoff));
        }

        @VisibleForTesting
        @UnknownKeyFor @NonNull @Initialized Write withServiceFactory(@UnknownKeyFor @NonNull @Initialized ServiceFactory<@UnknownKeyFor @NonNull @Initialized Spanner, @UnknownKeyFor @NonNull @Initialized SpannerOptions> serviceFactory) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withServiceFactory(serviceFactory));
        }

        public @UnknownKeyFor @NonNull @Initialized WriteGrouped grouped() {
            return new WriteGrouped(this);
        }

        public @UnknownKeyFor @NonNull @Initialized Write withBatchSizeBytes(@UnknownKeyFor @NonNull @Initialized long batchSizeBytes) {
            return this.toBuilder().setBatchSizeBytes(batchSizeBytes).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write withFailureMode(@UnknownKeyFor @NonNull @Initialized FailureMode failureMode) {
            return this.toBuilder().setFailureMode(failureMode).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write withMaxNumMutations(@UnknownKeyFor @NonNull @Initialized long maxNumMutations) {
            return this.toBuilder().setMaxNumMutations(maxNumMutations).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write withMaxNumRows(@UnknownKeyFor @NonNull @Initialized long maxNumRows) {
            return this.toBuilder().setMaxNumRows(maxNumRows).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write withSchemaReadySignal(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> signal) {
            return this.toBuilder().setSchemaReadySignal(signal).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write withGroupingFactor(@UnknownKeyFor @NonNull @Initialized int groupingFactor) {
            return this.toBuilder().setGroupingFactor(groupingFactor).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write withLowPriority() {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withRpcPriority(Options.RpcPriority.LOW));
        }

        public @UnknownKeyFor @NonNull @Initialized Write withHighPriority() {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withRpcPriority(Options.RpcPriority.HIGH));
        }

        public @UnknownKeyFor @NonNull @Initialized SpannerWriteResult expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Mutation> input) {
            this.getSpannerConfig().validate();
            return (SpannerWriteResult)((PCollection)input.apply("To mutation group", (PTransform)ParDo.of((DoFn)new ToMutationGroupFn()))).apply("Write mutations to Cloud Spanner", (PTransform)new WriteGrouped(this));
        }

        public void populateDisplayData(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            this.populateDisplayDataWithParamaters(builder);
        }

        private void populateDisplayDataWithParamaters(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            this.getSpannerConfig().populateDisplayData(builder);
            builder.add(DisplayData.item((String)"batchSizeBytes", (Long)this.getBatchSizeBytes()).withLabel("Max batch size in bytes"));
            builder.add(DisplayData.item((String)"maxNumMutations", (Long)this.getMaxNumMutations()).withLabel("Max number of mutated cells in each batch"));
            builder.add(DisplayData.item((String)"maxNumRows", (Long)this.getMaxNumRows()).withLabel("Max number of rows in each batch"));
            builder.add(DisplayData.item((String)"groupingFactor", (String)(this.getGroupingFactor().isPresent() ? Integer.toString(this.getGroupingFactor().getAsInt()) : "DEFAULT")).withLabel("Number of batches to sort over"));
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder setSpannerConfig(@UnknownKeyFor @NonNull @Initialized SpannerConfig var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setBatchSizeBytes(@UnknownKeyFor @NonNull @Initialized long var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setMaxNumMutations(@UnknownKeyFor @NonNull @Initialized long var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setMaxNumRows(@UnknownKeyFor @NonNull @Initialized long var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setFailureMode(@UnknownKeyFor @NonNull @Initialized FailureMode var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setSchemaReadySignal(/*
             * Issues handling annotations - annotations may be inaccurate
             */
            @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setGroupingFactor(@UnknownKeyFor @NonNull @Initialized int var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setDialectView(@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Dialect> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Write build();
        }
    }

    public static enum FailureMode {
        FAIL_FAST,
        REPORT_FAILURES;

    }

    @AutoValue
    public static abstract class CreateTransaction
    extends PTransform<PInput, PCollectionView<Transaction>> {
        abstract @UnknownKeyFor @NonNull @Initialized SpannerConfig getSpannerConfig();

        abstract @Nullable @UnknownKeyFor @Initialized TimestampBound getTimestampBound();

        abstract @UnknownKeyFor @NonNull @Initialized Builder toBuilder();

        public @UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Transaction> expand(@UnknownKeyFor @NonNull @Initialized PInput input) {
            this.getSpannerConfig().validate();
            PCollection collection = (PCollection)input.getPipeline().apply((PTransform)Create.of((Object)1, (Object[])new Integer[0]));
            if (input instanceof PCollection) {
                collection = (PCollection)collection.apply((PTransform)Wait.on((PCollection[])new PCollection[]{(PCollection)input}));
            } else if (!(input instanceof PBegin)) {
                throw new RuntimeException("input must be PBegin or PCollection");
            }
            return (PCollectionView)((PCollection)collection.apply("Create transaction", (PTransform)ParDo.of((DoFn)new CreateTransactionFn(this.getSpannerConfig(), this.getTimestampBound())))).apply("As PCollectionView", (PTransform)View.asSingleton());
        }

        public @UnknownKeyFor @NonNull @Initialized CreateTransaction withSpannerConfig(@UnknownKeyFor @NonNull @Initialized SpannerConfig spannerConfig) {
            return this.toBuilder().setSpannerConfig(spannerConfig).build();
        }

        public @UnknownKeyFor @NonNull @Initialized CreateTransaction withProjectId(@UnknownKeyFor @NonNull @Initialized String projectId) {
            return this.withProjectId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)projectId));
        }

        public @UnknownKeyFor @NonNull @Initialized CreateTransaction withProjectId(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> projectId) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withProjectId(projectId));
        }

        public @UnknownKeyFor @NonNull @Initialized CreateTransaction withInstanceId(@UnknownKeyFor @NonNull @Initialized String instanceId) {
            return this.withInstanceId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)instanceId));
        }

        public @UnknownKeyFor @NonNull @Initialized CreateTransaction withInstanceId(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> instanceId) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withInstanceId(instanceId));
        }

        public @UnknownKeyFor @NonNull @Initialized CreateTransaction withDatabaseId(@UnknownKeyFor @NonNull @Initialized String databaseId) {
            return this.withDatabaseId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)databaseId));
        }

        public @UnknownKeyFor @NonNull @Initialized CreateTransaction withDatabaseId(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> databaseId) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withDatabaseId(databaseId));
        }

        public @UnknownKeyFor @NonNull @Initialized CreateTransaction withHost(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> host) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withHost(host));
        }

        public @UnknownKeyFor @NonNull @Initialized CreateTransaction withHost(@UnknownKeyFor @NonNull @Initialized String host) {
            return this.withHost((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)host));
        }

        public @UnknownKeyFor @NonNull @Initialized CreateTransaction withEmulatorHost(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> emulatorHost) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withEmulatorHost(emulatorHost));
        }

        public @UnknownKeyFor @NonNull @Initialized CreateTransaction withEmulatorHost(@UnknownKeyFor @NonNull @Initialized String emulatorHost) {
            return this.withEmulatorHost((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)emulatorHost));
        }

        @VisibleForTesting
        @UnknownKeyFor @NonNull @Initialized CreateTransaction withServiceFactory(@UnknownKeyFor @NonNull @Initialized ServiceFactory<@UnknownKeyFor @NonNull @Initialized Spanner, @UnknownKeyFor @NonNull @Initialized SpannerOptions> serviceFactory) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withServiceFactory(serviceFactory));
        }

        public @UnknownKeyFor @NonNull @Initialized CreateTransaction withTimestampBound(@UnknownKeyFor @NonNull @Initialized TimestampBound timestampBound) {
            return this.toBuilder().setTimestampBound(timestampBound).build();
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract @UnknownKeyFor @NonNull @Initialized Builder setSpannerConfig(@UnknownKeyFor @NonNull @Initialized SpannerConfig var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setTimestampBound(@UnknownKeyFor @NonNull @Initialized TimestampBound var1);

            public abstract @UnknownKeyFor @NonNull @Initialized CreateTransaction build();
        }
    }

    static class ReadRows
    extends PTransform<PBegin, PCollection<Row>> {
        @UnknownKeyFor @NonNull @Initialized Read read;
        @UnknownKeyFor @NonNull @Initialized Schema schema;

        public ReadRows(@UnknownKeyFor @NonNull @Initialized Read read, @UnknownKeyFor @NonNull @Initialized Schema schema) {
            super("Read rows");
            this.read = read;
            this.schema = schema;
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Row> expand(@UnknownKeyFor @NonNull @Initialized PBegin input) {
            return ((PCollection)((PCollection)input.apply((PTransform)this.read)).apply((PTransform)MapElements.into((TypeDescriptor)TypeDescriptor.of(Row.class)).via((SerializableFunction & Serializable)struct -> StructUtils.structToBeamRow(struct, this.schema)))).setRowSchema(this.schema);
        }
    }

    @AutoValue
    public static abstract class Read
    extends PTransform<PBegin, PCollection<Struct>> {
        abstract @UnknownKeyFor @NonNull @Initialized SpannerConfig getSpannerConfig();

        abstract @UnknownKeyFor @NonNull @Initialized ReadOperation getReadOperation();

        abstract @Nullable @UnknownKeyFor @Initialized TimestampBound getTimestampBound();

        abstract @Nullable @UnknownKeyFor @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Transaction> getTransaction();

        abstract @Nullable @UnknownKeyFor @Initialized PartitionOptions getPartitionOptions();

        abstract @UnknownKeyFor @NonNull @Initialized Boolean getBatching();

        abstract @UnknownKeyFor @NonNull @Initialized Builder toBuilder();

        public @UnknownKeyFor @NonNull @Initialized Read withSpannerConfig(@UnknownKeyFor @NonNull @Initialized SpannerConfig spannerConfig) {
            return this.toBuilder().setSpannerConfig(spannerConfig).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withProjectId(@UnknownKeyFor @NonNull @Initialized String projectId) {
            return this.withProjectId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)projectId));
        }

        public @UnknownKeyFor @NonNull @Initialized Read withProjectId(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> projectId) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withProjectId(projectId));
        }

        public @UnknownKeyFor @NonNull @Initialized Read withInstanceId(@UnknownKeyFor @NonNull @Initialized String instanceId) {
            return this.withInstanceId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)instanceId));
        }

        public @UnknownKeyFor @NonNull @Initialized Read withInstanceId(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> instanceId) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withInstanceId(instanceId));
        }

        public @UnknownKeyFor @NonNull @Initialized Read withDatabaseId(@UnknownKeyFor @NonNull @Initialized String databaseId) {
            return this.withDatabaseId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)databaseId));
        }

        public @UnknownKeyFor @NonNull @Initialized Read withDatabaseId(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> databaseId) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withDatabaseId(databaseId));
        }

        public @UnknownKeyFor @NonNull @Initialized Read withHost(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> host) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withHost(host));
        }

        public @UnknownKeyFor @NonNull @Initialized Read withHost(@UnknownKeyFor @NonNull @Initialized String host) {
            return this.withHost((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)host));
        }

        public @UnknownKeyFor @NonNull @Initialized Read withEmulatorHost(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> emulatorHost) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withEmulatorHost(emulatorHost));
        }

        public @UnknownKeyFor @NonNull @Initialized Read withEmulatorHost(@UnknownKeyFor @NonNull @Initialized String emulatorHost) {
            return this.withEmulatorHost((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)emulatorHost));
        }

        public @UnknownKeyFor @NonNull @Initialized Read withBatching(@UnknownKeyFor @NonNull @Initialized boolean batching) {
            return this.toBuilder().setBatching(batching).build();
        }

        @VisibleForTesting
        @UnknownKeyFor @NonNull @Initialized Read withServiceFactory(@UnknownKeyFor @NonNull @Initialized ServiceFactory<@UnknownKeyFor @NonNull @Initialized Spanner, @UnknownKeyFor @NonNull @Initialized SpannerOptions> serviceFactory) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withServiceFactory(serviceFactory));
        }

        public @UnknownKeyFor @NonNull @Initialized Read withTransaction(@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Transaction> transaction) {
            return this.toBuilder().setTransaction(transaction).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withTimestamp(@UnknownKeyFor @NonNull @Initialized Timestamp timestamp) {
            return this.withTimestampBound(TimestampBound.ofReadTimestamp((Timestamp)timestamp));
        }

        public @UnknownKeyFor @NonNull @Initialized Read withTimestampBound(@UnknownKeyFor @NonNull @Initialized TimestampBound timestampBound) {
            return this.toBuilder().setTimestampBound(timestampBound).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withTable(@UnknownKeyFor @NonNull @Initialized String table) {
            return this.withReadOperation(this.getReadOperation().withTable(table));
        }

        public @UnknownKeyFor @NonNull @Initialized Read withReadOperation(@UnknownKeyFor @NonNull @Initialized ReadOperation operation) {
            return this.toBuilder().setReadOperation(operation).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read withColumns(String ... columns) {
            return this.withColumns(Arrays.asList(columns));
        }

        public @UnknownKeyFor @NonNull @Initialized Read withColumns(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> columns) {
            return this.withReadOperation(this.getReadOperation().withColumns(columns));
        }

        public @UnknownKeyFor @NonNull @Initialized Read withQuery(@UnknownKeyFor @NonNull @Initialized Statement statement) {
            return this.withReadOperation(this.getReadOperation().withQuery(statement));
        }

        public @UnknownKeyFor @NonNull @Initialized Read withQuery(@UnknownKeyFor @NonNull @Initialized String sql) {
            return this.withQuery(Statement.of((String)sql));
        }

        public @UnknownKeyFor @NonNull @Initialized Read withQueryName(@UnknownKeyFor @NonNull @Initialized String queryName) {
            return this.withReadOperation(this.getReadOperation().withQueryName(queryName));
        }

        public @UnknownKeyFor @NonNull @Initialized Read withKeySet(@UnknownKeyFor @NonNull @Initialized KeySet keySet) {
            return this.withReadOperation(this.getReadOperation().withKeySet(keySet));
        }

        public @UnknownKeyFor @NonNull @Initialized Read withIndex(@UnknownKeyFor @NonNull @Initialized String index) {
            return this.withReadOperation(this.getReadOperation().withIndex(index));
        }

        public @UnknownKeyFor @NonNull @Initialized Read withPartitionOptions(@UnknownKeyFor @NonNull @Initialized PartitionOptions partitionOptions) {
            return this.withReadOperation(this.getReadOperation().withPartitionOptions(partitionOptions));
        }

        public @UnknownKeyFor @NonNull @Initialized Read withLowPriority() {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withRpcPriority(Options.RpcPriority.LOW));
        }

        public @UnknownKeyFor @NonNull @Initialized Read withHighPriority() {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withRpcPriority(Options.RpcPriority.HIGH));
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Struct> expand(@UnknownKeyFor @NonNull @Initialized PBegin input) {
            this.getSpannerConfig().validate();
            Preconditions.checkArgument((this.getTimestampBound() != null ? 1 : 0) != 0, (Object)"SpannerIO.read() runs in a read only transaction and requires timestamp to be set with withTimestampBound or withTimestamp method");
            if (this.getReadOperation().getQuery() == null) {
                if (this.getReadOperation().getTable() != null) {
                    Preconditions.checkNotNull(this.getReadOperation().getColumns(), (Object)"For a read operation SpannerIO.read() requires a list of columns to set with withColumns method");
                    Preconditions.checkArgument((!this.getReadOperation().getColumns().isEmpty() ? 1 : 0) != 0, (Object)"For a read operation SpannerIO.read() requires a non-empty list of columns to set with withColumns method");
                } else {
                    throw new IllegalArgumentException("SpannerIO.read() requires configuring query or read operation.");
                }
            }
            ReadAll readAll = SpannerIO.readAll().withSpannerConfig(this.getSpannerConfig()).withTimestampBound(this.getTimestampBound()).withBatching(this.getBatching()).withTransaction(this.getTransaction());
            return (PCollection)((PCollection)input.apply((PTransform)Create.of((Object)this.getReadOperation(), (Object[])new ReadOperation[0]))).apply("Execute query", (PTransform)readAll);
        }

        @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Struct, @UnknownKeyFor @NonNull @Initialized Row> getFormatFn() {
            return (SerializableFunction & Serializable)input -> Row.withSchema((Schema)Schema.builder().addInt64Field("Key").build()).withFieldValue("Key", (Object)3L).build();
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder setSpannerConfig(@UnknownKeyFor @NonNull @Initialized SpannerConfig var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setReadOperation(@UnknownKeyFor @NonNull @Initialized ReadOperation var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setTimestampBound(@UnknownKeyFor @NonNull @Initialized TimestampBound var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setTransaction(@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Transaction> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setPartitionOptions(@UnknownKeyFor @NonNull @Initialized PartitionOptions var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setBatching(@UnknownKeyFor @NonNull @Initialized Boolean var1);

            abstract @UnknownKeyFor @NonNull @Initialized Read build();
        }
    }

    @AutoValue
    public static abstract class ReadAll
    extends PTransform<PCollection<ReadOperation>, PCollection<Struct>> {
        abstract @UnknownKeyFor @NonNull @Initialized SpannerConfig getSpannerConfig();

        abstract @Nullable @UnknownKeyFor @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Transaction> getTransaction();

        abstract @Nullable @UnknownKeyFor @Initialized TimestampBound getTimestampBound();

        abstract @UnknownKeyFor @NonNull @Initialized Builder toBuilder();

        public @UnknownKeyFor @NonNull @Initialized ReadAll withSpannerConfig(@UnknownKeyFor @NonNull @Initialized SpannerConfig spannerConfig) {
            return this.toBuilder().setSpannerConfig(spannerConfig).build();
        }

        public @UnknownKeyFor @NonNull @Initialized ReadAll withProjectId(@UnknownKeyFor @NonNull @Initialized String projectId) {
            return this.withProjectId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)projectId));
        }

        public @UnknownKeyFor @NonNull @Initialized ReadAll withProjectId(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> projectId) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withProjectId(projectId));
        }

        public @UnknownKeyFor @NonNull @Initialized ReadAll withInstanceId(@UnknownKeyFor @NonNull @Initialized String instanceId) {
            return this.withInstanceId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)instanceId));
        }

        public @UnknownKeyFor @NonNull @Initialized ReadAll withInstanceId(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> instanceId) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withInstanceId(instanceId));
        }

        public @UnknownKeyFor @NonNull @Initialized ReadAll withDatabaseId(@UnknownKeyFor @NonNull @Initialized String databaseId) {
            return this.withDatabaseId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)databaseId));
        }

        public @UnknownKeyFor @NonNull @Initialized ReadAll withHost(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> host) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withHost(host));
        }

        public @UnknownKeyFor @NonNull @Initialized ReadAll withHost(@UnknownKeyFor @NonNull @Initialized String host) {
            return this.withHost((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)host));
        }

        public @UnknownKeyFor @NonNull @Initialized ReadAll withEmulatorHost(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> emulatorHost) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withEmulatorHost(emulatorHost));
        }

        public @UnknownKeyFor @NonNull @Initialized ReadAll withEmulatorHost(@UnknownKeyFor @NonNull @Initialized String emulatorHost) {
            return this.withEmulatorHost((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)emulatorHost));
        }

        public @UnknownKeyFor @NonNull @Initialized ReadAll withDatabaseId(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> databaseId) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withDatabaseId(databaseId));
        }

        @VisibleForTesting
        @UnknownKeyFor @NonNull @Initialized ReadAll withServiceFactory(@UnknownKeyFor @NonNull @Initialized ServiceFactory<@UnknownKeyFor @NonNull @Initialized Spanner, @UnknownKeyFor @NonNull @Initialized SpannerOptions> serviceFactory) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withServiceFactory(serviceFactory));
        }

        public @UnknownKeyFor @NonNull @Initialized ReadAll withTransaction(@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Transaction> transaction) {
            return this.toBuilder().setTransaction(transaction).build();
        }

        public @UnknownKeyFor @NonNull @Initialized ReadAll withTimestamp(@UnknownKeyFor @NonNull @Initialized Timestamp timestamp) {
            return this.withTimestampBound(TimestampBound.ofReadTimestamp((Timestamp)timestamp));
        }

        public @UnknownKeyFor @NonNull @Initialized ReadAll withTimestampBound(@UnknownKeyFor @NonNull @Initialized TimestampBound timestampBound) {
            return this.toBuilder().setTimestampBound(timestampBound).build();
        }

        public @UnknownKeyFor @NonNull @Initialized ReadAll withBatching(@UnknownKeyFor @NonNull @Initialized boolean batching) {
            return this.toBuilder().setBatching(batching).build();
        }

        public @UnknownKeyFor @NonNull @Initialized ReadAll withLowPriority() {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withRpcPriority(Options.RpcPriority.LOW));
        }

        public @UnknownKeyFor @NonNull @Initialized ReadAll withHighPriority() {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withRpcPriority(Options.RpcPriority.HIGH));
        }

        abstract @UnknownKeyFor @NonNull @Initialized Boolean getBatching();

        public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized Struct> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized ReadOperation> input) {
            if (PCollection.IsBounded.UNBOUNDED == input.isBounded()) {
                LOG.warn("SpannerIO.ReadAll({}) is being applied to an unbounded input. This is not supported and can lead to runtime failures.", (Object)this.getName());
            }
            PTransform readTransform = this.getBatching() != false ? BatchSpannerRead.create(this.getSpannerConfig(), this.getTransaction(), this.getTimestampBound()) : NaiveSpannerRead.create(this.getSpannerConfig(), this.getTransaction(), this.getTimestampBound());
            return (PCollection)((PCollection)input.apply("Reshuffle", (PTransform)Reshuffle.viaRandomKey())).apply("Read from Cloud Spanner", readTransform);
        }

        static @UnknownKeyFor @NonNull @Initialized ServiceCallMetric buildServiceCallMetricForReadOp(@UnknownKeyFor @NonNull @Initialized SpannerConfig config, @UnknownKeyFor @NonNull @Initialized ReadOperation op) {
            HashMap baseLabels = SpannerIO.buildServiceCallMetricLabels(config);
            baseLabels.put("METHOD", "Read");
            if (op.getQuery() != null) {
                String queryName = op.getQueryName();
                if (queryName == null || queryName.isEmpty()) {
                    queryName = String.format("UNNAMED_QUERY#%08x", op.getQuery().getSql().hashCode());
                }
                baseLabels.put("RESOURCE", GcpResourceIdentifiers.spannerQuery((String)((String)baseLabels.get("SPANNER_PROJECT_ID")), (String)((String)config.getInstanceId().get()), (String)((String)config.getDatabaseId().get()), (String)queryName));
                baseLabels.put("SPANNER_QUERY_NAME", queryName);
            } else {
                baseLabels.put("RESOURCE", GcpResourceIdentifiers.spannerTable((String)((String)baseLabels.get("SPANNER_PROJECT_ID")), (String)((String)config.getInstanceId().get()), (String)((String)config.getDatabaseId().get()), (String)op.getTable()));
                baseLabels.put("TABLE_ID", op.getTable());
            }
            return new ServiceCallMetric(MonitoringInfoConstants.Urns.API_REQUEST_COUNT, baseLabels);
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder setSpannerConfig(@UnknownKeyFor @NonNull @Initialized SpannerConfig var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setTransaction(@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @NonNull @Initialized Transaction> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setTimestampBound(@UnknownKeyFor @NonNull @Initialized TimestampBound var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder setBatching(@UnknownKeyFor @NonNull @Initialized Boolean var1);

            abstract @UnknownKeyFor @NonNull @Initialized ReadAll build();
        }
    }
}

