/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsub;

import com.google.auto.service.AutoService;
import java.util.Collections;
import java.util.Map;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.core.construction.PTransformTranslation;
import org.apache.beam.runners.core.construction.SdkComponents;
import org.apache.beam.runners.core.construction.TransformPayloadTranslatorRegistrar;
import org.apache.beam.sdk.io.Read;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubClient;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubUnboundedSink;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubUnboundedSource;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.runners.AppliedPTransform;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;

public class PubSubPayloadTranslation {

    @AutoService(value={TransformPayloadTranslatorRegistrar.class})
    public static class ReadRegistrar
    implements TransformPayloadTranslatorRegistrar {
        public Map<? extends Class<? extends PTransform>, ? extends PTransformTranslation.TransformPayloadTranslator> getTransformPayloadTranslators() {
            return Collections.singletonMap(Read.Unbounded.class, new PubSubReadPayloadTranslator());
        }
    }

    @AutoService(value={TransformPayloadTranslatorRegistrar.class})
    public static class WriteRegistrar
    implements TransformPayloadTranslatorRegistrar {
        public Map<? extends Class<? extends PTransform>, ? extends PTransformTranslation.TransformPayloadTranslator> getTransformPayloadTranslators() {
            return ImmutableMap.of(PubsubUnboundedSink.PubsubSink.class, (Object)new PubSubWritePayloadTranslator(), PubsubUnboundedSink.PubsubDynamicSink.class, (Object)new PubSubDynamicWritePayloadTranslator());
        }
    }

    static class PubSubDynamicWritePayloadTranslator
    implements PTransformTranslation.TransformPayloadTranslator<PubsubUnboundedSink.PubsubDynamicSink> {
        PubSubDynamicWritePayloadTranslator() {
        }

        public String getUrn() {
            return "beam:transform:pubsub_write:v2";
        }

        public RunnerApi.FunctionSpec translate(AppliedPTransform<?, ?, PubsubUnboundedSink.PubsubDynamicSink> transform, SdkComponents components) {
            RunnerApi.PubSubWritePayload.Builder payloadBuilder = RunnerApi.PubSubWritePayload.newBuilder();
            if (((PubsubUnboundedSink.PubsubDynamicSink)transform.getTransform()).outer.getTimestampAttribute() != null) {
                payloadBuilder.setTimestampAttribute(((PubsubUnboundedSink.PubsubDynamicSink)transform.getTransform()).outer.getTimestampAttribute());
            }
            if (((PubsubUnboundedSink.PubsubDynamicSink)transform.getTransform()).outer.getIdAttribute() != null) {
                payloadBuilder.setIdAttribute(((PubsubUnboundedSink.PubsubDynamicSink)transform.getTransform()).outer.getIdAttribute());
            }
            return RunnerApi.FunctionSpec.newBuilder().setUrn(this.getUrn((PubsubUnboundedSink.PubsubDynamicSink)transform.getTransform())).setPayload(payloadBuilder.build().toByteString()).build();
        }
    }

    static class PubSubWritePayloadTranslator
    implements PTransformTranslation.TransformPayloadTranslator<PubsubUnboundedSink.PubsubSink> {
        PubSubWritePayloadTranslator() {
        }

        public String getUrn() {
            return "beam:transform:pubsub_write:v1";
        }

        public RunnerApi.FunctionSpec translate(AppliedPTransform<?, ?, PubsubUnboundedSink.PubsubSink> transform, SdkComponents components) {
            RunnerApi.PubSubWritePayload.Builder payloadBuilder = RunnerApi.PubSubWritePayload.newBuilder();
            ValueProvider topicProvider = (ValueProvider)Preconditions.checkStateNotNull(((PubsubUnboundedSink.PubsubSink)transform.getTransform()).outer.getTopicProvider());
            if (topicProvider.isAccessible()) {
                payloadBuilder.setTopic(((PubsubClient.TopicPath)topicProvider.get()).getFullPath());
            } else {
                payloadBuilder.setTopicRuntimeOverridden(((ValueProvider.NestedValueProvider)topicProvider).propertyName());
            }
            if (((PubsubUnboundedSink.PubsubSink)transform.getTransform()).outer.getTimestampAttribute() != null) {
                payloadBuilder.setTimestampAttribute(((PubsubUnboundedSink.PubsubSink)transform.getTransform()).outer.getTimestampAttribute());
            }
            if (((PubsubUnboundedSink.PubsubSink)transform.getTransform()).outer.getIdAttribute() != null) {
                payloadBuilder.setIdAttribute(((PubsubUnboundedSink.PubsubSink)transform.getTransform()).outer.getIdAttribute());
            }
            return RunnerApi.FunctionSpec.newBuilder().setUrn(this.getUrn((PubsubUnboundedSink.PubsubSink)transform.getTransform())).setPayload(payloadBuilder.build().toByteString()).build();
        }
    }

    static class PubSubReadPayloadTranslator
    implements PTransformTranslation.TransformPayloadTranslator<Read.Unbounded<?>> {
        PubSubReadPayloadTranslator() {
        }

        public String getUrn() {
            return "beam:transform:pubsub_read:v1";
        }

        public RunnerApi.FunctionSpec translate(AppliedPTransform<?, ?, Read.Unbounded<?>> transform, SdkComponents components) {
            ValueProvider<PubsubClient.SubscriptionPath> subscriptionProvider;
            if (!(((Read.Unbounded)transform.getTransform()).getSource() instanceof PubsubUnboundedSource.PubsubSource)) {
                return null;
            }
            RunnerApi.PubSubReadPayload.Builder payloadBuilder = RunnerApi.PubSubReadPayload.newBuilder();
            PubsubUnboundedSource pubsubUnboundedSource = ((PubsubUnboundedSource.PubsubSource)((Read.Unbounded)transform.getTransform()).getSource()).outer;
            ValueProvider<PubsubClient.TopicPath> topicProvider = pubsubUnboundedSource.getTopicProvider();
            if (topicProvider != null) {
                if (topicProvider.isAccessible()) {
                    payloadBuilder.setTopic(((PubsubClient.TopicPath)topicProvider.get()).getFullPath());
                } else {
                    payloadBuilder.setTopicRuntimeOverridden(((ValueProvider.NestedValueProvider)topicProvider).propertyName());
                }
            }
            if ((subscriptionProvider = pubsubUnboundedSource.getSubscriptionProvider()) != null) {
                if (subscriptionProvider.isAccessible()) {
                    payloadBuilder.setSubscription(((PubsubClient.SubscriptionPath)subscriptionProvider.get()).getFullPath());
                } else {
                    payloadBuilder.setSubscriptionRuntimeOverridden(((ValueProvider.NestedValueProvider)subscriptionProvider).propertyName());
                }
            }
            if (pubsubUnboundedSource.getTimestampAttribute() != null) {
                payloadBuilder.setTimestampAttribute(pubsubUnboundedSource.getTimestampAttribute());
            }
            if (pubsubUnboundedSource.getIdAttribute() != null) {
                payloadBuilder.setIdAttribute(pubsubUnboundedSource.getIdAttribute());
            }
            payloadBuilder.setWithAttributes(pubsubUnboundedSource.getNeedsAttributes() || pubsubUnboundedSource.getNeedsMessageId());
            return RunnerApi.FunctionSpec.newBuilder().setUrn(this.getUrn((PTransform)((Read.Unbounded)transform.getTransform()))).setPayload(payloadBuilder.build().toByteString()).build();
        }
    }
}

