/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableCell;
import com.google.api.services.bigquery.model.TableFieldSchema;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.auto.value.AutoValue;
import java.io.Serializable;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.avro.Conversions;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.util.Utf8;
import org.apache.beam.runners.core.metrics.GcpResourceIdentifiers;
import org.apache.beam.runners.core.metrics.MonitoringInfoConstants;
import org.apache.beam.runners.core.metrics.ServiceCallMetric;
import org.apache.beam.sdk.io.gcp.bigquery.AutoValue_BigQueryUtils_ConversionOptions;
import org.apache.beam.sdk.io.gcp.bigquery.AutoValue_BigQueryUtils_SchemaConversionOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryAvroUtils;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.bigquery.CivilTimeEncoder;
import org.apache.beam.sdk.io.gcp.bigquery.Mode;
import org.apache.beam.sdk.io.gcp.bigquery.StandardSQLTypeName;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.logicaltypes.EnumerationType;
import org.apache.beam.sdk.schemas.logicaltypes.PassThroughLogicalType;
import org.apache.beam.sdk.schemas.logicaltypes.SqlTypes;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.SerializableFunctions;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Strings;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableSet;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.io.BaseEncoding;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;
import org.joda.time.chrono.ISOChronology;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;

public class BigQueryUtils {
    private static final @UnknownKeyFor @NonNull @Initialized Pattern TABLE_RESOURCE_PATTERN = Pattern.compile("^projects/(?<PROJECT>[^/]+)/datasets/(?<DATASET>[^/]+)/tables/(?<TABLE>[^/]+)$");
    private static final @UnknownKeyFor @NonNull @Initialized Pattern SIMPLE_TABLE_PATTERN = Pattern.compile("^(?<PROJECT>[a-z][a-z0-9.\\-:]{4,28}[a-z0-9])[\\:.](?<DATASET>[a-zA-Z0-9_]{1,1024})[\\.](?<TABLE>[\\p{L}\\p{M}\\p{N}\\p{Pc}\\p{Pd}\\p{Zs}$]{1,1024})$");
    private static final @UnknownKeyFor @NonNull @Initialized String BIGQUERY_TIME_PATTERN = "HH:mm:ss[.SSSSSS]";
    private static final @UnknownKeyFor @NonNull @Initialized java.time.format.DateTimeFormatter BIGQUERY_TIME_FORMATTER = java.time.format.DateTimeFormatter.ofPattern("HH:mm:ss[.SSSSSS]");
    private static final @UnknownKeyFor @NonNull @Initialized java.time.format.DateTimeFormatter BIGQUERY_DATETIME_FORMATTER = java.time.format.DateTimeFormatter.ofPattern("uuuu-MM-dd'T'HH:mm:ss[.SSSSSS]");
    private static final @UnknownKeyFor @NonNull @Initialized DateTimeFormatter BIGQUERY_TIMESTAMP_PRINTER;
    private static final @UnknownKeyFor @NonNull @Initialized DateTimeFormatter BIGQUERY_TIMESTAMP_PARSER;
    private static final @UnknownKeyFor @NonNull @Initialized Map<// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.TypeName, @UnknownKeyFor @NonNull @Initialized StandardSQLTypeName> BEAM_TO_BIGQUERY_TYPE_MAPPING;
    private static final @UnknownKeyFor @NonNull @Initialized Map<// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.TypeName, @UnknownKeyFor @NonNull @Initialized Function<@UnknownKeyFor @NonNull @Initialized String, @Nullable @UnknownKeyFor @Initialized Object>> JSON_VALUE_PARSERS;
    static final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized StandardSQLTypeName> BEAM_TO_BIGQUERY_LOGICAL_MAPPING;
    private static final @UnknownKeyFor @NonNull @Initialized String BIGQUERY_MAP_KEY_FIELD_NAME = "key";
    private static final @UnknownKeyFor @NonNull @Initialized String BIGQUERY_MAP_VALUE_FIELD_NAME = "value";
    private static final  @UnknownKeyFor @NonNull @Initialized BigQueryIO.TypedRead.ToBeamRowFunction<@UnknownKeyFor @NonNull @Initialized TableRow> TABLE_ROW_TO_BEAM_ROW_FUNCTION;
    private static final  @UnknownKeyFor @NonNull @Initialized BigQueryIO.TypedRead.FromBeamRowFunction<@UnknownKeyFor @NonNull @Initialized TableRow> TABLE_ROW_FROM_BEAM_ROW_FUNCTION;
    private static final @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Row, @UnknownKeyFor @NonNull @Initialized TableRow> ROW_TO_TABLE_ROW;
    private static final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> SQL_DATE_TIME_TYPES;

    static @UnknownKeyFor @NonNull @Initialized StandardSQLTypeName toStandardSQLTypeName(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.FieldType fieldType) {
        StandardSQLTypeName ret;
        if (fieldType.getTypeName().isLogicalType()) {
            Schema.LogicalType logicalType = (Schema.LogicalType)Preconditions.checkArgumentNotNull((Object)fieldType.getLogicalType());
            ret = BEAM_TO_BIGQUERY_LOGICAL_MAPPING.get(logicalType.getIdentifier());
            if (ret == null) {
                if (logicalType instanceof PassThroughLogicalType) {
                    return BigQueryUtils.toStandardSQLTypeName(logicalType.getBaseType());
                }
                throw new IllegalArgumentException("Cannot convert Beam logical type: " + logicalType.getIdentifier() + " to BigQuery type.");
            }
        } else {
            ret = BEAM_TO_BIGQUERY_TYPE_MAPPING.get(fieldType.getTypeName());
            if (ret == null) {
                throw new IllegalArgumentException("Cannot convert Beam type: " + fieldType.getTypeName() + " to BigQuery type.");
            }
        }
        return ret;
    }

    private static // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.FieldType fromTableFieldSchemaType(@UnknownKeyFor @NonNull @Initialized String typeName, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TableFieldSchema> nestedFields, @UnknownKeyFor @NonNull @Initialized SchemaConversionOptions options) {
        switch (typeName) {
            case "STRING": {
                return Schema.FieldType.STRING;
            }
            case "BYTES": {
                return Schema.FieldType.BYTES;
            }
            case "INT64": 
            case "INTEGER": {
                return Schema.FieldType.INT64;
            }
            case "FLOAT64": 
            case "FLOAT": {
                return Schema.FieldType.DOUBLE;
            }
            case "BOOL": 
            case "BOOLEAN": {
                return Schema.FieldType.BOOLEAN;
            }
            case "NUMERIC": {
                return Schema.FieldType.DECIMAL;
            }
            case "TIMESTAMP": {
                return Schema.FieldType.DATETIME;
            }
            case "TIME": {
                return Schema.FieldType.logicalType((Schema.LogicalType)SqlTypes.TIME);
            }
            case "DATE": {
                return Schema.FieldType.logicalType((Schema.LogicalType)SqlTypes.DATE);
            }
            case "DATETIME": {
                return Schema.FieldType.logicalType((Schema.LogicalType)SqlTypes.DATETIME);
            }
            case "STRUCT": 
            case "RECORD": {
                if (options.getInferMaps() && nestedFields.size() == 2) {
                    TableFieldSchema key = nestedFields.get(0);
                    TableFieldSchema value = nestedFields.get(1);
                    if (BIGQUERY_MAP_KEY_FIELD_NAME.equals(key.getName()) && BIGQUERY_MAP_VALUE_FIELD_NAME.equals(value.getName())) {
                        return Schema.FieldType.map((Schema.FieldType)BigQueryUtils.fromTableFieldSchemaType(key.getType(), key.getFields(), options), (Schema.FieldType)BigQueryUtils.fromTableFieldSchemaType(value.getType(), value.getFields(), options));
                    }
                }
                Schema rowSchema = BigQueryUtils.fromTableFieldSchema(nestedFields, options);
                return Schema.FieldType.row((Schema)rowSchema);
            }
        }
        throw new UnsupportedOperationException("Converting BigQuery type " + typeName + " to Beam type is unsupported");
    }

    private static @UnknownKeyFor @NonNull @Initialized Schema fromTableFieldSchema(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TableFieldSchema> tableFieldSchemas, @UnknownKeyFor @NonNull @Initialized SchemaConversionOptions options) {
        Schema.Builder schemaBuilder = Schema.builder();
        for (TableFieldSchema tableFieldSchema : tableFieldSchemas) {
            Schema.FieldType fieldType = BigQueryUtils.fromTableFieldSchemaType(tableFieldSchema.getType(), tableFieldSchema.getFields(), options);
            Optional<Mode> fieldMode = Optional.ofNullable(tableFieldSchema.getMode()).map(Mode::valueOf);
            if (fieldMode.filter(m -> m == Mode.REPEATED).isPresent() && !fieldType.getTypeName().isMapType()) {
                fieldType = Schema.FieldType.array((Schema.FieldType)fieldType);
            }
            boolean nullable = !fieldMode.isPresent() || fieldMode.filter(m -> m == Mode.NULLABLE).isPresent();
            Schema.Field field = Schema.Field.of((String)tableFieldSchema.getName(), (Schema.FieldType)fieldType).withNullable(nullable);
            if (tableFieldSchema.getDescription() != null && !"".equals(tableFieldSchema.getDescription())) {
                field = field.withDescription(tableFieldSchema.getDescription());
            }
            schemaBuilder.addField(field);
        }
        return schemaBuilder.build();
    }

    private static @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TableFieldSchema> toTableFieldSchema(@UnknownKeyFor @NonNull @Initialized Schema schema) {
        ArrayList<TableFieldSchema> fields = new ArrayList<TableFieldSchema>(schema.getFieldCount());
        for (Schema.Field schemaField : schema.getFields()) {
            Schema.FieldType type = schemaField.getType();
            TableFieldSchema field = new TableFieldSchema().setName(schemaField.getName());
            if (schemaField.getDescription() != null && !"".equals(schemaField.getDescription())) {
                field.setDescription(schemaField.getDescription());
            }
            if (!schemaField.getType().getNullable().booleanValue()) {
                field.setMode(Mode.REQUIRED.toString());
            }
            if (type.getTypeName().isCollectionType()) {
                if ((type = (Schema.FieldType)Preconditions.checkArgumentNotNull((Object)type.getCollectionElementType())).getTypeName().isCollectionType() || type.getTypeName().isMapType()) {
                    throw new IllegalArgumentException("Array of collection is not supported in BigQuery.");
                }
                field.setMode(Mode.REPEATED.toString());
            }
            if (Schema.TypeName.ROW == type.getTypeName()) {
                Schema subType = (Schema)Preconditions.checkArgumentNotNull((Object)type.getRowSchema());
                field.setFields(BigQueryUtils.toTableFieldSchema(subType));
            }
            if (Schema.TypeName.MAP == type.getTypeName()) {
                Schema.FieldType mapKeyType = (Schema.FieldType)Preconditions.checkArgumentNotNull((Object)type.getMapKeyType());
                Schema.FieldType mapValueType = (Schema.FieldType)Preconditions.checkArgumentNotNull((Object)type.getMapValueType());
                Schema mapSchema = Schema.builder().addField(BIGQUERY_MAP_KEY_FIELD_NAME, mapKeyType).addField(BIGQUERY_MAP_VALUE_FIELD_NAME, mapValueType).build();
                type = Schema.FieldType.row((Schema)mapSchema);
                field.setFields(BigQueryUtils.toTableFieldSchema(mapSchema));
                field.setMode(Mode.REPEATED.toString());
            }
            field.setType(BigQueryUtils.toStandardSQLTypeName(type).toString());
            fields.add(field);
        }
        return fields;
    }

    public static @UnknownKeyFor @NonNull @Initialized TableSchema toTableSchema(@UnknownKeyFor @NonNull @Initialized Schema schema) {
        return new TableSchema().setFields(BigQueryUtils.toTableFieldSchema(schema));
    }

    public static @UnknownKeyFor @NonNull @Initialized Schema fromTableSchema(@UnknownKeyFor @NonNull @Initialized TableSchema tableSchema) {
        return BigQueryUtils.fromTableSchema(tableSchema, SchemaConversionOptions.builder().build());
    }

    public static @UnknownKeyFor @NonNull @Initialized Schema fromTableSchema(@UnknownKeyFor @NonNull @Initialized TableSchema tableSchema, @UnknownKeyFor @NonNull @Initialized SchemaConversionOptions options) {
        return BigQueryUtils.fromTableFieldSchema(tableSchema.getFields(), options);
    }

    public static @UnknownKeyFor @NonNull @Initialized org.apache.avro.Schema toGenericAvroSchema(@UnknownKeyFor @NonNull @Initialized String schemaName, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized TableFieldSchema> fieldSchemas) {
        return BigQueryAvroUtils.toGenericAvroSchema(schemaName, fieldSchemas);
    }

    public static final  @UnknownKeyFor @NonNull @Initialized BigQueryIO.TypedRead.ToBeamRowFunction<@UnknownKeyFor @NonNull @Initialized TableRow> tableRowToBeamRow() {
        return TABLE_ROW_TO_BEAM_ROW_FUNCTION;
    }

    public static final  @UnknownKeyFor @NonNull @Initialized BigQueryIO.TypedRead.FromBeamRowFunction<@UnknownKeyFor @NonNull @Initialized TableRow> tableRowFromBeamRow() {
        return TABLE_ROW_FROM_BEAM_ROW_FUNCTION;
    }

    public static @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Row, @UnknownKeyFor @NonNull @Initialized TableRow> toTableRow() {
        return ROW_TO_TABLE_ROW;
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized SerializableFunction<T, @UnknownKeyFor @NonNull @Initialized TableRow> toTableRow(@UnknownKeyFor @NonNull @Initialized SerializableFunction<T, @UnknownKeyFor @NonNull @Initialized Row> toRow) {
        return new ToTableRow<T>(toRow);
    }

    public static @UnknownKeyFor @NonNull @Initialized Row toBeamRow(@UnknownKeyFor @NonNull @Initialized GenericRecord record, @UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized ConversionOptions options) {
        List valuesInOrder = schema.getFields().stream().map(field -> {
            try {
                return BigQueryUtils.convertAvroFormat(field.getType(), record.get(field.getName()), options);
            }
            catch (Exception cause) {
                throw new IllegalArgumentException("Error converting field " + field + ": " + cause.getMessage(), cause);
            }
        }).collect(Collectors.toList());
        return Row.withSchema((Schema)schema).addValues(valuesInOrder).build();
    }

    public static @UnknownKeyFor @NonNull @Initialized TableRow convertGenericRecordToTableRow(@UnknownKeyFor @NonNull @Initialized GenericRecord record, @UnknownKeyFor @NonNull @Initialized TableSchema tableSchema) {
        return BigQueryAvroUtils.convertGenericRecordToTableRow(record, tableSchema);
    }

    public static @UnknownKeyFor @NonNull @Initialized TableRow toTableRow(@UnknownKeyFor @NonNull @Initialized Row row) {
        TableRow output = new TableRow();
        for (int i = 0; i < row.getFieldCount(); ++i) {
            Object value = row.getValue(i);
            Schema.Field schemaField = row.getSchema().getField(i);
            output = output.set(schemaField.getName(), BigQueryUtils.fromBeamField(schemaField.getType(), value));
        }
        return output;
    }

    private static @Nullable @UnknownKeyFor @Initialized Object fromBeamField(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.FieldType fieldType, @UnknownKeyFor @NonNull @Initialized Object fieldValue) {
        if (fieldValue == null) {
            if (!fieldType.getNullable().booleanValue()) {
                throw new IllegalArgumentException("Field is not nullable.");
            }
            return null;
        }
        switch (fieldType.getTypeName()) {
            case ARRAY: 
            case ITERABLE: {
                Schema.FieldType elementType = fieldType.getCollectionElementType();
                Iterable items = (Iterable)fieldValue;
                ArrayList convertedItems = Lists.newArrayListWithCapacity((int)Iterables.size((Iterable)items));
                for (Object item : items) {
                    convertedItems.add(BigQueryUtils.fromBeamField(elementType, item));
                }
                return convertedItems;
            }
            case MAP: {
                Schema.FieldType keyElementType = fieldType.getMapKeyType();
                Schema.FieldType valueElementType = fieldType.getMapValueType();
                Map pairs = (Map)fieldValue;
                ArrayList convertedItems = Lists.newArrayListWithCapacity((int)pairs.size());
                for (Map.Entry pair : pairs.entrySet()) {
                    convertedItems.add(new TableRow().set(BIGQUERY_MAP_KEY_FIELD_NAME, BigQueryUtils.fromBeamField(keyElementType, pair.getKey())).set(BIGQUERY_MAP_VALUE_FIELD_NAME, BigQueryUtils.fromBeamField(valueElementType, pair.getValue())));
                }
                return convertedItems;
            }
            case ROW: {
                return BigQueryUtils.toTableRow((Row)fieldValue);
            }
            case DATETIME: {
                return ((Instant)fieldValue).toDateTime(DateTimeZone.UTC).toString(BIGQUERY_TIMESTAMP_PRINTER);
            }
            case INT16: 
            case INT32: 
            case FLOAT: 
            case BOOLEAN: 
            case DOUBLE: {
                return fieldValue.toString();
            }
            case STRING: 
            case INT64: 
            case DECIMAL: {
                return fieldValue.toString();
            }
            case BYTES: {
                return BaseEncoding.base64().encode((byte[])fieldValue);
            }
            case LOGICAL_TYPE: {
                String identifier = fieldType.getLogicalType().getIdentifier();
                if (SqlTypes.DATE.getIdentifier().equals(identifier)) {
                    return fieldValue.toString();
                }
                if (SqlTypes.TIME.getIdentifier().equals(identifier)) {
                    LocalTime localTime = (LocalTime)fieldValue;
                    java.time.format.DateTimeFormatter localTimeFormatter = 0 == localTime.getNano() ? java.time.format.DateTimeFormatter.ISO_LOCAL_TIME : BIGQUERY_TIME_FORMATTER;
                    return localTimeFormatter.format(localTime);
                }
                if (SqlTypes.DATETIME.getIdentifier().equals(identifier)) {
                    LocalDateTime localDateTime = (LocalDateTime)fieldValue;
                    java.time.format.DateTimeFormatter localDateTimeFormatter = 0 == localDateTime.getNano() ? java.time.format.DateTimeFormatter.ISO_LOCAL_DATE_TIME : BIGQUERY_DATETIME_FORMATTER;
                    return localDateTimeFormatter.format(localDateTime);
                }
                if (!"Enum".equals(identifier)) break;
                return ((EnumerationType)fieldType.getLogicalType(EnumerationType.class)).toString((EnumerationType.Value)fieldValue);
            }
        }
        return fieldValue.toString();
    }

    public static @UnknownKeyFor @NonNull @Initialized Row toBeamRow(@UnknownKeyFor @NonNull @Initialized Schema rowSchema, @UnknownKeyFor @NonNull @Initialized TableRow jsonBqRow) {
        return (Row)rowSchema.getFields().stream().map(field -> BigQueryUtils.toBeamValue(field, jsonBqRow.get((Object)field.getName()))).collect(Row.toRow((Schema)rowSchema));
    }

    public static @UnknownKeyFor @NonNull @Initialized Row toBeamRow(@UnknownKeyFor @NonNull @Initialized Schema rowSchema, @UnknownKeyFor @NonNull @Initialized TableSchema bqSchema, @UnknownKeyFor @NonNull @Initialized TableRow jsonBqRow) {
        List bqFields = bqSchema.getFields();
        Map<String, Integer> bqFieldIndices = IntStream.range(0, bqFields.size()).boxed().collect(Collectors.toMap(i -> ((TableFieldSchema)bqFields.get((int)i)).getName(), i -> i));
        List rawJsonValues = rowSchema.getFields().stream().map(field -> (Integer)bqFieldIndices.get(field.getName())).map(index -> ((TableCell)jsonBqRow.getF().get((int)index)).getV()).collect(Collectors.toList());
        return (Row)IntStream.range(0, rowSchema.getFieldCount()).boxed().map(index -> BigQueryUtils.toBeamValue(rowSchema.getField(index.intValue()), rawJsonValues.get((int)index))).collect(Row.toRow((Schema)rowSchema));
    }

    private static @Nullable @UnknownKeyFor @Initialized Object toBeamValue(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.Field field, @UnknownKeyFor @NonNull @Initialized Object jsonBQValue) {
        Schema.FieldType fieldType = field.getType();
        if (jsonBQValue == null) {
            if (fieldType.getNullable().booleanValue()) {
                return null;
            }
            throw new IllegalArgumentException("Received null value for non-nullable field \"" + field.getName() + "\"");
        }
        if (jsonBQValue instanceof String || jsonBQValue instanceof Number || jsonBQValue instanceof Boolean) {
            String jsonBQString = jsonBQValue.toString();
            if (JSON_VALUE_PARSERS.containsKey(fieldType.getTypeName())) {
                return JSON_VALUE_PARSERS.get(fieldType.getTypeName()).apply(jsonBQString);
            }
            if (fieldType.isLogicalType(SqlTypes.DATETIME.getIdentifier())) {
                try {
                    Long value = Long.parseLong(jsonBQString);
                    return CivilTimeEncoder.decodePacked64DatetimeMicrosAsJavaTime(value);
                }
                catch (NumberFormatException e) {
                    return LocalDateTime.parse(jsonBQString, BIGQUERY_DATETIME_FORMATTER);
                }
            }
            if (fieldType.isLogicalType(SqlTypes.DATE.getIdentifier())) {
                return LocalDate.parse(jsonBQString);
            }
            if (fieldType.isLogicalType(SqlTypes.TIME.getIdentifier())) {
                return LocalTime.parse(jsonBQString);
            }
        }
        if (jsonBQValue instanceof byte[] && fieldType.getTypeName() == Schema.TypeName.BYTES) {
            return jsonBQValue;
        }
        if (jsonBQValue instanceof List) {
            if (fieldType.getCollectionElementType() == null) {
                throw new IllegalArgumentException("Cannot convert BigQuery type '" + jsonBQValue.getClass() + "' to '" + fieldType + "' because the BigQuery type is a List, while the output type is not a collection.");
            }
            boolean innerTypeIsMap = fieldType.getCollectionElementType().getTypeName().equals((Object)Schema.TypeName.MAP);
            return ((List)jsonBQValue).stream().map(v -> !innerTypeIsMap && v instanceof Map ? ((Map)v).get("v") : v).map(v -> BigQueryUtils.toBeamValue(field.withType(fieldType.getCollectionElementType()), v)).collect(Collectors.toList());
        }
        if (jsonBQValue instanceof Map) {
            TableRow tr = new TableRow();
            tr.putAll((Map)jsonBQValue);
            return BigQueryUtils.toBeamRow(fieldType.getRowSchema(), tr);
        }
        throw new UnsupportedOperationException("Converting BigQuery type '" + jsonBQValue.getClass() + "' to '" + fieldType + "' is not supported");
    }

    public static @UnknownKeyFor @NonNull @Initialized Object convertAvroFormat(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.FieldType beamFieldType, @UnknownKeyFor @NonNull @Initialized Object avroValue, @UnknownKeyFor @NonNull @Initialized ConversionOptions options) {
        Schema.TypeName beamFieldTypeName = beamFieldType.getTypeName();
        if (avroValue == null) {
            if (beamFieldType.getNullable().booleanValue()) {
                return null;
            }
            throw new IllegalArgumentException(String.format("Field %s not nullable", beamFieldType));
        }
        switch (beamFieldTypeName) {
            case INT16: 
            case INT32: 
            case FLOAT: 
            case BOOLEAN: 
            case DOUBLE: 
            case STRING: 
            case INT64: 
            case BYTES: 
            case BYTE: {
                return BigQueryUtils.convertAvroPrimitiveTypes(beamFieldTypeName, avroValue);
            }
            case DATETIME: {
                switch (options.getTruncateTimestamps()) {
                    case TRUNCATE: {
                        return BigQueryUtils.truncateToMillis(avroValue);
                    }
                    case REJECT: {
                        return BigQueryUtils.safeToMillis(avroValue);
                    }
                }
                throw new IllegalArgumentException(String.format("Unknown timestamp truncation option: %s", new Object[]{options.getTruncateTimestamps()}));
            }
            case DECIMAL: {
                return BigQueryUtils.convertAvroNumeric(avroValue);
            }
            case ARRAY: {
                return BigQueryUtils.convertAvroArray(beamFieldType, avroValue, options);
            }
            case LOGICAL_TYPE: {
                Schema.LogicalType logicalType = beamFieldType.getLogicalType();
                assert (logicalType != null);
                String identifier = logicalType.getIdentifier();
                if (SqlTypes.DATE.getIdentifier().equals(identifier)) {
                    return BigQueryUtils.convertAvroDate(avroValue);
                }
                if (SqlTypes.TIME.getIdentifier().equals(identifier)) {
                    return BigQueryUtils.convertAvroTime(avroValue);
                }
                if (SqlTypes.DATETIME.getIdentifier().equals(identifier)) {
                    return BigQueryUtils.convertAvroDateTime(avroValue);
                }
                if (SQL_DATE_TIME_TYPES.contains(identifier)) {
                    switch (options.getTruncateTimestamps()) {
                        case TRUNCATE: {
                            return BigQueryUtils.truncateToMillis(avroValue);
                        }
                        case REJECT: {
                            return BigQueryUtils.safeToMillis(avroValue);
                        }
                    }
                    throw new IllegalArgumentException(String.format("Unknown timestamp truncation option: %s", new Object[]{options.getTruncateTimestamps()}));
                }
                if (logicalType instanceof PassThroughLogicalType) {
                    return BigQueryUtils.convertAvroFormat(logicalType.getBaseType(), avroValue, options);
                }
                throw new RuntimeException("Unknown logical type " + identifier);
            }
            case ROW: {
                Schema rowSchema = beamFieldType.getRowSchema();
                if (rowSchema == null) {
                    throw new IllegalArgumentException("Nested ROW missing row schema");
                }
                GenericData.Record record = (GenericData.Record)avroValue;
                return BigQueryUtils.toBeamRow((GenericRecord)record, rowSchema, options);
            }
            case MAP: {
                return BigQueryUtils.convertAvroRecordToMap(beamFieldType, avroValue, options);
            }
        }
        throw new RuntimeException("Does not support converting unknown type value: " + beamFieldTypeName);
    }

    private static @UnknownKeyFor @NonNull @Initialized ReadableInstant safeToMillis(@UnknownKeyFor @NonNull @Initialized Object value) {
        long subMilliPrecision = (Long)value % 1000L;
        if (subMilliPrecision != 0L) {
            throw new IllegalArgumentException(String.format("BigQuery data contained value %s with sub-millisecond precision, which Beam does not currently support. You can enable truncating timestamps to millisecond precision by using BigQueryIO.withTruncatedTimestamps", value));
        }
        return BigQueryUtils.truncateToMillis(value);
    }

    private static @UnknownKeyFor @NonNull @Initialized ReadableInstant truncateToMillis(@UnknownKeyFor @NonNull @Initialized Object value) {
        return new Instant((Long)value / 1000L);
    }

    private static @UnknownKeyFor @NonNull @Initialized Object convertAvroArray(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.FieldType beamField, @UnknownKeyFor @NonNull @Initialized Object value, @UnknownKeyFor @NonNull @Initialized ConversionOptions options) {
        List values = (List)value;
        ArrayList<Object> ret = new ArrayList<Object>();
        Schema.FieldType collectionElement = beamField.getCollectionElementType();
        for (Object v : values) {
            ret.add(BigQueryUtils.convertAvroFormat(collectionElement, v, options));
        }
        return ret;
    }

    private static @UnknownKeyFor @NonNull @Initialized Object convertAvroRecordToMap(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.FieldType beamField, @UnknownKeyFor @NonNull @Initialized Object value, @UnknownKeyFor @NonNull @Initialized ConversionOptions options) {
        List records = (List)value;
        ImmutableMap.Builder ret = ImmutableMap.builder();
        Schema.FieldType keyElement = beamField.getMapKeyType();
        Schema.FieldType valueElement = beamField.getMapValueType();
        for (GenericData.Record record : records) {
            ret.put(BigQueryUtils.convertAvroFormat(keyElement, record.get(0), options), BigQueryUtils.convertAvroFormat(valueElement, record.get(1), options));
        }
        return ret.build();
    }

    private static @UnknownKeyFor @NonNull @Initialized Object convertAvroPrimitiveTypes(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.TypeName beamType, @UnknownKeyFor @NonNull @Initialized Object value) {
        switch (beamType) {
            case BYTE: {
                return ((Long)value).byteValue();
            }
            case INT16: {
                return ((Long)value).shortValue();
            }
            case INT32: {
                return ((Long)value).intValue();
            }
            case INT64: {
                return value;
            }
            case FLOAT: {
                return Float.valueOf(((Double)value).floatValue());
            }
            case DOUBLE: {
                return value;
            }
            case BOOLEAN: {
                return value;
            }
            case DECIMAL: {
                throw new RuntimeException("Does not support converting DECIMAL type value");
            }
            case STRING: {
                return BigQueryUtils.convertAvroString(value);
            }
            case BYTES: {
                return BigQueryUtils.convertAvroBytes(value);
            }
        }
        throw new RuntimeException(beamType + " is not primitive type.");
    }

    private static @UnknownKeyFor @NonNull @Initialized Object convertAvroString(@UnknownKeyFor @NonNull @Initialized Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Utf8) {
            return ((Utf8)value).toString();
        }
        if (value instanceof String) {
            return value;
        }
        throw new RuntimeException("Does not support converting avro format: " + value.getClass().getName());
    }

    private static @UnknownKeyFor @NonNull @Initialized Object convertAvroBytes(@UnknownKeyFor @NonNull @Initialized Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof ByteBuffer) {
            ByteBuffer bf = (ByteBuffer)value;
            byte[] result = new byte[bf.limit()];
            bf.get(result);
            return result;
        }
        throw new RuntimeException("Does not support converting avro format: " + value.getClass().getName());
    }

    private static @UnknownKeyFor @NonNull @Initialized Object convertAvroDate(@UnknownKeyFor @NonNull @Initialized Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Integer) {
            return LocalDate.ofEpochDay(((Integer)value).intValue());
        }
        throw new RuntimeException("Does not support converting avro format: " + value.getClass().getName());
    }

    private static @UnknownKeyFor @NonNull @Initialized Object convertAvroTime(@UnknownKeyFor @NonNull @Initialized Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Long) {
            return LocalTime.ofNanoOfDay((Long)value * 1000L);
        }
        throw new RuntimeException("Does not support converting avro format: " + value.getClass().getName());
    }

    private static @UnknownKeyFor @NonNull @Initialized Object convertAvroDateTime(@UnknownKeyFor @NonNull @Initialized Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Utf8) {
            return LocalDateTime.parse(value.toString());
        }
        throw new RuntimeException("Does not support converting avro format: " + value.getClass().getName());
    }

    private static @UnknownKeyFor @NonNull @Initialized Object convertAvroNumeric(@UnknownKeyFor @NonNull @Initialized Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof ByteBuffer) {
            return new Conversions.DecimalConversion().fromBytes((ByteBuffer)value, null, (LogicalType)LogicalTypes.decimal((int)38, (int)9));
        }
        throw new RuntimeException("Does not support converting avro format: " + value.getClass().getName());
    }

    public static @Nullable @UnknownKeyFor @Initialized TableReference toTableReference(@UnknownKeyFor @NonNull @Initialized String fullTableId) {
        Matcher m = TABLE_RESOURCE_PATTERN.matcher(fullTableId);
        if (m.matches()) {
            return new TableReference().setProjectId(m.group("PROJECT")).setDatasetId(m.group("DATASET")).setTableId(m.group("TABLE"));
        }
        m = SIMPLE_TABLE_PATTERN.matcher(fullTableId);
        if (m.matches()) {
            return new TableReference().setProjectId(m.group("PROJECT")).setDatasetId(m.group("DATASET")).setTableId(m.group("TABLE"));
        }
        return null;
    }

    public static @Nullable @UnknownKeyFor @Initialized String toTableSpec(@UnknownKeyFor @NonNull @Initialized TableReference tableReference) {
        if (tableReference.getDatasetId() == null || tableReference.getTableId() == null) {
            throw new IllegalArgumentException(String.format("Table reference [%s] must include at least a dataset and a table.", tableReference));
        }
        String tableSpec = String.format("%s.%s", tableReference.getDatasetId(), tableReference.getTableId());
        if (!Strings.isNullOrEmpty((String)tableReference.getProjectId())) {
            tableSpec = String.format("%s.%s", tableReference.getProjectId(), tableSpec);
        }
        return tableSpec;
    }

    private static @Nullable @UnknownKeyFor @Initialized ServiceCallMetric callMetricForMethod(@Nullable @UnknownKeyFor @Initialized TableReference tableReference, @UnknownKeyFor @NonNull @Initialized String method) {
        if (tableReference != null) {
            HashMap<String, String> baseLabels = new HashMap<String, String>();
            baseLabels.put("PTRANSFORM", "");
            baseLabels.put("SERVICE", "BigQuery");
            baseLabels.put("METHOD", method);
            baseLabels.put("RESOURCE", GcpResourceIdentifiers.bigQueryTable((String)tableReference.getProjectId(), (String)tableReference.getDatasetId(), (String)tableReference.getTableId()));
            baseLabels.put("BIGQUERY_PROJECT_ID", tableReference.getProjectId());
            baseLabels.put("BIGQUERY_DATASET", tableReference.getDatasetId());
            baseLabels.put("BIGQUERY_TABLE", tableReference.getTableId());
            return new ServiceCallMetric(MonitoringInfoConstants.Urns.API_REQUEST_COUNT, baseLabels);
        }
        return null;
    }

    public static @Nullable @UnknownKeyFor @Initialized ServiceCallMetric readCallMetric(@Nullable @UnknownKeyFor @Initialized TableReference tableReference) {
        return BigQueryUtils.callMetricForMethod(tableReference, "BigQueryBatchRead");
    }

    public static @UnknownKeyFor @NonNull @Initialized ServiceCallMetric writeCallMetric(@UnknownKeyFor @NonNull @Initialized TableReference tableReference) {
        return BigQueryUtils.callMetricForMethod(tableReference, "BigQueryBatchWrite");
    }

    static {
        DateTimeFormatter dateTimePart = new DateTimeFormatterBuilder().appendYear(4, 4).appendLiteral('-').appendMonthOfYear(2).appendLiteral('-').appendDayOfMonth(2).appendLiteral(' ').appendHourOfDay(2).appendLiteral(':').appendMinuteOfHour(2).appendLiteral(':').appendSecondOfMinute(2).toFormatter().withZoneUTC();
        BIGQUERY_TIMESTAMP_PARSER = new DateTimeFormatterBuilder().append(dateTimePart).appendOptional(new DateTimeFormatterBuilder().appendLiteral('.').appendFractionOfSecond(3, 6).toParser()).appendLiteral(" UTC").toFormatter().withZoneUTC();
        BIGQUERY_TIMESTAMP_PRINTER = new DateTimeFormatterBuilder().append(dateTimePart).appendLiteral('.').appendFractionOfSecond(3, 3).appendLiteral(" UTC").toFormatter();
        BEAM_TO_BIGQUERY_TYPE_MAPPING = ImmutableMap.builder().put((Object)Schema.TypeName.BYTE, (Object)StandardSQLTypeName.INT64).put((Object)Schema.TypeName.INT16, (Object)StandardSQLTypeName.INT64).put((Object)Schema.TypeName.INT32, (Object)StandardSQLTypeName.INT64).put((Object)Schema.TypeName.INT64, (Object)StandardSQLTypeName.INT64).put((Object)Schema.TypeName.FLOAT, (Object)StandardSQLTypeName.FLOAT64).put((Object)Schema.TypeName.DOUBLE, (Object)StandardSQLTypeName.FLOAT64).put((Object)Schema.TypeName.DECIMAL, (Object)StandardSQLTypeName.NUMERIC).put((Object)Schema.TypeName.BOOLEAN, (Object)StandardSQLTypeName.BOOL).put((Object)Schema.TypeName.ARRAY, (Object)StandardSQLTypeName.ARRAY).put((Object)Schema.TypeName.ITERABLE, (Object)StandardSQLTypeName.ARRAY).put((Object)Schema.TypeName.ROW, (Object)StandardSQLTypeName.STRUCT).put((Object)Schema.TypeName.DATETIME, (Object)StandardSQLTypeName.TIMESTAMP).put((Object)Schema.TypeName.STRING, (Object)StandardSQLTypeName.STRING).put((Object)Schema.TypeName.BYTES, (Object)StandardSQLTypeName.BYTES).build();
        JSON_VALUE_PARSERS = ImmutableMap.builder().put((Object)Schema.TypeName.BYTE, Byte::valueOf).put((Object)Schema.TypeName.INT16, Short::valueOf).put((Object)Schema.TypeName.INT32, Integer::valueOf).put((Object)Schema.TypeName.INT64, Long::valueOf).put((Object)Schema.TypeName.FLOAT, Float::valueOf).put((Object)Schema.TypeName.DOUBLE, Double::valueOf).put((Object)Schema.TypeName.DECIMAL, BigDecimal::new).put((Object)Schema.TypeName.BOOLEAN, Boolean::valueOf).put((Object)Schema.TypeName.STRING, str -> str).put((Object)Schema.TypeName.DATETIME, str -> {
            if (str == null || str.length() == 0) {
                return null;
            }
            if (str.endsWith("UTC")) {
                return BIGQUERY_TIMESTAMP_PARSER.parseDateTime(str).toDateTime(DateTimeZone.UTC);
            }
            return new DateTime((long)(Double.parseDouble(str) * 1000.0), (Chronology)ISOChronology.getInstanceUTC());
        }).put((Object)Schema.TypeName.BYTES, str -> BaseEncoding.base64().decode((CharSequence)str)).build();
        BEAM_TO_BIGQUERY_LOGICAL_MAPPING = ImmutableMap.builder().put((Object)SqlTypes.DATE.getIdentifier(), (Object)StandardSQLTypeName.DATE).put((Object)SqlTypes.TIME.getIdentifier(), (Object)StandardSQLTypeName.TIME).put((Object)SqlTypes.DATETIME.getIdentifier(), (Object)StandardSQLTypeName.DATETIME).put((Object)SqlTypes.TIMESTAMP.getIdentifier(), (Object)StandardSQLTypeName.TIMESTAMP).put((Object)"SqlTimeWithLocalTzType", (Object)StandardSQLTypeName.TIME).put((Object)"Enum", (Object)StandardSQLTypeName.STRING).build();
        TABLE_ROW_TO_BEAM_ROW_FUNCTION = (BigQueryIO.TypedRead.ToBeamRowFunction & Serializable)beamSchema -> (SerializableFunction & Serializable)tr -> BigQueryUtils.toBeamRow(beamSchema, tr);
        TABLE_ROW_FROM_BEAM_ROW_FUNCTION = (BigQueryIO.TypedRead.FromBeamRowFunction & Serializable)ignored -> BigQueryUtils::toTableRow;
        ROW_TO_TABLE_ROW = new ToTableRow<Row>(SerializableFunctions.identity());
        SQL_DATE_TIME_TYPES = ImmutableSet.of((Object)"SqlTimeWithLocalTzType");
    }

    private static class ToTableRow<@UnknownKeyFor T>
    implements SerializableFunction<T, TableRow> {
        private final @UnknownKeyFor @NonNull @Initialized SerializableFunction<T, @UnknownKeyFor @NonNull @Initialized Row> toRow;

        ToTableRow(@UnknownKeyFor @NonNull @Initialized SerializableFunction<T, @UnknownKeyFor @NonNull @Initialized Row> toRow) {
            this.toRow = toRow;
        }

        public @UnknownKeyFor @NonNull @Initialized TableRow apply(T input) {
            return BigQueryUtils.toTableRow((Row)this.toRow.apply(input));
        }
    }

    @AutoValue
    public static abstract class SchemaConversionOptions
    implements Serializable {
        public abstract @UnknownKeyFor @NonNull @Initialized boolean getInferMaps();

        public static @UnknownKeyFor @NonNull @Initialized Builder builder() {
            return new AutoValue_BigQueryUtils_SchemaConversionOptions.Builder().setInferMaps(false);
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract @UnknownKeyFor @NonNull @Initialized Builder setInferMaps(@UnknownKeyFor @NonNull @Initialized boolean var1);

            public abstract @UnknownKeyFor @NonNull @Initialized SchemaConversionOptions build();
        }
    }

    @AutoValue
    public static abstract class ConversionOptions
    implements Serializable {
        public abstract @UnknownKeyFor @NonNull @Initialized TruncateTimestamps getTruncateTimestamps();

        public static @UnknownKeyFor @NonNull @Initialized Builder builder() {
            return new AutoValue_BigQueryUtils_ConversionOptions.Builder().setTruncateTimestamps(TruncateTimestamps.REJECT);
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract @UnknownKeyFor @NonNull @Initialized Builder setTruncateTimestamps(@UnknownKeyFor @NonNull @Initialized TruncateTimestamps var1);

            public abstract @UnknownKeyFor @NonNull @Initialized ConversionOptions build();
        }

        public static enum TruncateTimestamps {
            REJECT,
            TRUNCATE;

        }
    }
}

