/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.auto.value.AutoValue;
import com.google.auto.value.extension.memoized.Memoized;
import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.Message;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.gcp.bigquery.;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.TableRowToStorageApiProto;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@AutoValue
abstract class AppendClientInfo {
    AppendClientInfo() {
    }

    @Nullable
    abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized BigQueryServices.StreamAppendClient getStreamAppendClient();

    abstract @UnknownKeyFor @NonNull @Initialized com.google.cloud.bigquery.storage.v1.TableSchema getTableSchema();

    abstract @UnknownKeyFor @NonNull @Initialized Consumer<@UnknownKeyFor @NonNull @Initialized BigQueryServices.StreamAppendClient> getCloseAppendClient();

    abstract @UnknownKeyFor @NonNull @Initialized TableSchema getJsonTableSchema();

    abstract @UnknownKeyFor @NonNull @Initialized TableRowToStorageApiProto.SchemaInformation getSchemaInformation();

    @Nullable
    abstract @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String getStreamName();

    abstract // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized DescriptorProtos.DescriptorProto getDescriptor();

    abstract @UnknownKeyFor @NonNull @Initialized Builder toBuilder();

    static @UnknownKeyFor @NonNull @Initialized AppendClientInfo of(@UnknownKeyFor @NonNull @Initialized com.google.cloud.bigquery.storage.v1.TableSchema tableSchema, // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized DescriptorProtos.DescriptorProto descriptor, @UnknownKeyFor @NonNull @Initialized Consumer<@UnknownKeyFor @NonNull @Initialized BigQueryServices.StreamAppendClient> closeAppendClient) throws @UnknownKeyFor @NonNull @Initialized Exception {
        return new .AutoValue_AppendClientInfo.Builder().setTableSchema(tableSchema).setCloseAppendClient(closeAppendClient).setJsonTableSchema(TableRowToStorageApiProto.protoSchemaToTableSchema(tableSchema)).setSchemaInformation(TableRowToStorageApiProto.SchemaInformation.fromTableSchema(tableSchema)).setDescriptor(descriptor).build();
    }

    static @UnknownKeyFor @NonNull @Initialized AppendClientInfo of(@UnknownKeyFor @NonNull @Initialized com.google.cloud.bigquery.storage.v1.TableSchema tableSchema, @UnknownKeyFor @NonNull @Initialized Consumer<@UnknownKeyFor @NonNull @Initialized BigQueryServices.StreamAppendClient> closeAppendClient, @UnknownKeyFor @NonNull @Initialized boolean includeCdcColumns) throws @UnknownKeyFor @NonNull @Initialized Exception {
        return AppendClientInfo.of(tableSchema, TableRowToStorageApiProto.descriptorSchemaFromTableSchema(tableSchema, true, includeCdcColumns), closeAppendClient);
    }

    public @UnknownKeyFor @NonNull @Initialized AppendClientInfo withNoAppendClient() {
        return this.toBuilder().setStreamAppendClient(null).build();
    }

    public @UnknownKeyFor @NonNull @Initialized AppendClientInfo withAppendClient(@UnknownKeyFor @NonNull @Initialized BigQueryServices.DatasetService datasetService, @UnknownKeyFor @NonNull @Initialized Supplier<@UnknownKeyFor @NonNull @Initialized String> getStreamName, @UnknownKeyFor @NonNull @Initialized boolean useConnectionPool) throws @UnknownKeyFor @NonNull @Initialized Exception {
        if (this.getStreamAppendClient() != null) {
            return this;
        }
        String streamName = getStreamName.get();
        return this.toBuilder().setStreamName(streamName).setStreamAppendClient(datasetService.getStreamAppendClient(streamName, this.getDescriptor(), useConnectionPool)).build();
    }

    public void close() {
        BigQueryServices.StreamAppendClient client = this.getStreamAppendClient();
        if (client != null) {
            this.getCloseAppendClient().accept(client);
        }
    }

    @UnknownKeyFor @NonNull @Initialized boolean hasSchemaChanged(@UnknownKeyFor @NonNull @Initialized com.google.cloud.bigquery.storage.v1.TableSchema updatedTableSchema) {
        return updatedTableSchema.hashCode() != this.getTableSchema().hashCode();
    }

    public @UnknownKeyFor @NonNull @Initialized ByteString encodeUnknownFields(@UnknownKeyFor @NonNull @Initialized TableRow unknown, @UnknownKeyFor @NonNull @Initialized boolean ignoreUnknownValues) throws @UnknownKeyFor @NonNull @Initialized TableRowToStorageApiProto.SchemaConversionException {
        DynamicMessage msg = TableRowToStorageApiProto.messageFromTableRow(this.getSchemaInformation(), this.getDescriptorIgnoreRequired(), unknown, ignoreUnknownValues, true, null, null, -1L);
        return msg.toByteString();
    }

    @Memoized
    // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Descriptors.Descriptor getDescriptorIgnoreRequired() {
        try {
            return TableRowToStorageApiProto.getDescriptorFromTableSchema(this.getTableSchema(), false, false);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public @UnknownKeyFor @NonNull @Initialized TableRow toTableRow(@UnknownKeyFor @NonNull @Initialized ByteString protoBytes) {
        try {
            return TableRowToStorageApiProto.tableRowFromMessage((Message)DynamicMessage.parseFrom((Descriptors.Descriptor)TableRowToStorageApiProto.wrapDescriptorProto(this.getDescriptor()), (ByteString)protoBytes), true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        abstract @UnknownKeyFor @NonNull @Initialized Builder setStreamAppendClient(@Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized BigQueryServices.StreamAppendClient var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setTableSchema(@UnknownKeyFor @NonNull @Initialized com.google.cloud.bigquery.storage.v1.TableSchema var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setCloseAppendClient(@UnknownKeyFor @NonNull @Initialized Consumer<@UnknownKeyFor @NonNull @Initialized BigQueryServices.StreamAppendClient> var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setJsonTableSchema(@UnknownKeyFor @NonNull @Initialized TableSchema var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setSchemaInformation(@UnknownKeyFor @NonNull @Initialized TableRowToStorageApiProto.SchemaInformation var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setDescriptor(// Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @NonNull @Initialized DescriptorProtos.DescriptorProto var1);

        abstract @UnknownKeyFor @NonNull @Initialized Builder setStreamName(@Nullable @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized String var1);

        abstract @UnknownKeyFor @NonNull @Initialized AppendClientInfo build();
    }
}

