/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigtable.changestreams.reconciler;

import com.google.cloud.bigtable.data.v2.models.Range;
import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.ByteStringRangeHelper;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.ChangeStreamMetrics;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.dao.MetadataTableDao;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.model.NewPartition;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.model.PartitionRecord;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;
import org.joda.time.ReadableInstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class PartitionReconciler {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(PartitionReconciler.class);
    private @UnknownKeyFor @NonNull @Initialized HashMap<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Range.ByteStringRange, @UnknownKeyFor @NonNull @Initialized Instant> missingPartitionDurations = new HashMap();
    private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized NewPartition> newPartitions = new ArrayList<NewPartition>();
    private final @UnknownKeyFor @NonNull @Initialized MetadataTableDao metadataTableDao;
    private final @UnknownKeyFor @NonNull @Initialized ChangeStreamMetrics metrics;
    private @UnknownKeyFor @NonNull @Initialized boolean hasAddedMissingPartitions = false;
    private static final @UnknownKeyFor @NonNull @Initialized Duration MISSING_PARTITION_SHORT_DELAY = Duration.standardMinutes((long)2L);
    private static final @UnknownKeyFor @NonNull @Initialized Duration MISSING_PARTITION_LONG_DELAY = Duration.standardMinutes((long)20L);

    public PartitionReconciler(@UnknownKeyFor @NonNull @Initialized MetadataTableDao metadataTableDao, @UnknownKeyFor @NonNull @Initialized ChangeStreamMetrics metrics) {
        this.metadataTableDao = metadataTableDao;
        this.metrics = metrics;
    }

    public void addMissingPartitions(@UnknownKeyFor @NonNull @Initialized List<// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Range.ByteStringRange> missingPartitions) {
        this.hasAddedMissingPartitions = true;
        HashMap<Range.ByteStringRange, Instant> alreadyMissingPartitionDurations = this.metadataTableDao.readDetectNewPartitionMissingPartitions();
        this.missingPartitionDurations = new HashMap();
        Instant now = Instant.now();
        for (Range.ByteStringRange missingPartition : missingPartitions) {
            this.missingPartitionDurations.put(missingPartition, alreadyMissingPartitionDurations.getOrDefault(missingPartition, now));
        }
        this.metadataTableDao.writeDetectNewPartitionMissingPartitions(this.missingPartitionDurations);
    }

    public void addIncompleteNewPartitions(@UnknownKeyFor @NonNull @Initialized NewPartition newPartition) {
        this.newPartitions.add(newPartition);
    }

    private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized NewPartition> findOverlappingNewPartitions(// Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @NonNull @Initialized Range.ByteStringRange missingPartition) {
        ArrayList<NewPartition> overlappingNewPartitions = new ArrayList<NewPartition>();
        for (NewPartition newPartition : this.newPartitions) {
            for (Range.ByteStringRange parentPartition : newPartition.getParentPartitions()) {
                NewPartition splicedNewPartition;
                if (!ByteStringRangeHelper.doPartitionsOverlap(parentPartition, missingPartition) || (splicedNewPartition = newPartition.getSingleTokenNewPartition(parentPartition)) == null) continue;
                overlappingNewPartitions.add(splicedNewPartition);
            }
        }
        return overlappingNewPartitions;
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized PartitionRecord> getPartitionsToReconcile(@UnknownKeyFor @NonNull @Initialized Instant lowWatermark, @UnknownKeyFor @NonNull @Initialized Instant startTime) {
        if (!this.hasAddedMissingPartitions) {
            return Collections.emptyList();
        }
        this.hasAddedMissingPartitions = false;
        Instant reconciledTime = lowWatermark.minus((ReadableDuration)Duration.standardMinutes((long)60L));
        if (reconciledTime.compareTo((ReadableInstant)startTime) < 0) {
            reconciledTime = startTime;
        }
        ArrayList<PartitionRecord> partitionsToReconcile = new ArrayList<PartitionRecord>();
        ArrayList<Range.ByteStringRange> missingPartitionsToRemove = new ArrayList<Range.ByteStringRange>();
        for (Map.Entry<Range.ByteStringRange, Instant> partitionDuration : this.missingPartitionDurations.entrySet()) {
            if (!partitionDuration.getValue().plus((ReadableDuration)MISSING_PARTITION_SHORT_DELAY).isBeforeNow()) continue;
            Range.ByteStringRange missingPartition = partitionDuration.getKey();
            List<NewPartition> overlappingNewPartitions = this.findOverlappingNewPartitions(missingPartition);
            ArrayList<Range.ByteStringRange> overlappingParentPartitions = new ArrayList<Range.ByteStringRange>();
            for (NewPartition newPartition : overlappingNewPartitions) {
                overlappingParentPartitions.add(newPartition.getParentPartitions().get(0));
            }
            if (ByteStringRangeHelper.coverSameKeySpace(overlappingParentPartitions, missingPartition)) {
                ArrayList allTokens = new ArrayList();
                for (NewPartition newPartition2 : overlappingNewPartitions) {
                    allTokens.add(newPartition2.getChangeStreamContinuationTokens().get(0));
                }
                this.metrics.incPartitionReconciledWithTokenCount();
                PartitionRecord partitionRecord = new PartitionRecord(missingPartition, allTokens, lowWatermark, overlappingNewPartitions);
                missingPartitionsToRemove.add(missingPartition);
                partitionsToReconcile.add(partitionRecord);
                continue;
            }
            if (!partitionDuration.getValue().plus((ReadableDuration)MISSING_PARTITION_LONG_DELAY).isBeforeNow()) continue;
            for (NewPartition newPartition : overlappingNewPartitions) {
                this.metrics.incPartitionReconciledWithTokenCount();
                PartitionRecord record = new PartitionRecord(newPartition.getChangeStreamContinuationTokens().get(0).getPartition(), newPartition.getChangeStreamContinuationTokens(), lowWatermark, Collections.singletonList(newPartition));
                partitionsToReconcile.add(record);
            }
            List<Range.ByteStringRange> missingPartitionsFromParents = ByteStringRangeHelper.getMissingPartitionsFrom(overlappingParentPartitions, (ByteString)missingPartition.getStart(), (ByteString)missingPartition.getEnd());
            for (Range.ByteStringRange missing : missingPartitionsFromParents) {
                this.metrics.incPartitionReconciledWithoutTokenCount();
                PartitionRecord record = new PartitionRecord(missing, reconciledTime, lowWatermark, Collections.emptyList());
                partitionsToReconcile.add(record);
                LOG.error("DNP: Reconciling partition because we're missing a token {}", (Object)record);
            }
            missingPartitionsToRemove.add(missingPartition);
        }
        for (Range.ByteStringRange missingPartitionToRemove : missingPartitionsToRemove) {
            this.missingPartitionDurations.remove(missingPartitionToRemove);
        }
        this.metadataTableDao.writeDetectNewPartitionMissingPartitions(this.missingPartitionDurations);
        return partitionsToReconcile;
    }
}

