/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsub;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubClient;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubGrpcClient;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubMessage;
import org.apache.beam.sdk.io.gcp.pubsub.TestPubsubOptions;
import org.apache.beam.sdk.testing.TestPipeline;
import org.joda.time.DateTime;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class TestPubsub
implements TestRule {
    private static final DateTimeFormatter DATETIME_FORMAT = DateTimeFormat.forPattern((String)"YYYY-MM-dd-HH-mm-ss-SSS");
    private static final String TOPIC_FORMAT = "projects/%s/topics/%s";
    private static final String TOPIC_PREFIX = "integ-test-";
    private static final String NO_ID_ATTRIBUTE = null;
    private static final String NO_TIMESTAMP_ATTRIBUTE = null;
    PubsubClient pubsub;
    private TestPubsubOptions pipelineOptions;
    private String eventsTopicPath;

    public static TestPubsub create() {
        TestPubsubOptions options = (TestPubsubOptions)TestPipeline.testingPipelineOptions().as(TestPubsubOptions.class);
        return new TestPubsub(options);
    }

    private TestPubsub(TestPubsubOptions pipelineOptions) {
        this.pipelineOptions = pipelineOptions;
    }

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                if (TestPubsub.this.pubsub != null) {
                    throw new AssertionError((Object)("Pubsub client was not shutdown in previous test. Topic path is'" + TestPubsub.this.eventsTopicPath + "'. Current test: " + description.getDisplayName()));
                }
                try {
                    TestPubsub.this.initializePubsub(description);
                    base.evaluate();
                }
                finally {
                    TestPubsub.this.tearDown();
                }
            }
        };
    }

    private void initializePubsub(Description description) throws IOException {
        this.pubsub = PubsubGrpcClient.FACTORY.newClient(NO_TIMESTAMP_ATTRIBUTE, NO_ID_ATTRIBUTE, this.pipelineOptions);
        String eventsTopicPathTmp = String.format(TOPIC_FORMAT, this.pipelineOptions.getProject(), TestPubsub.createTopicName(description));
        this.pubsub.createTopic(new PubsubClient.TopicPath(eventsTopicPathTmp));
        this.eventsTopicPath = eventsTopicPathTmp;
    }

    private void tearDown() throws IOException {
        if (this.pubsub == null) {
            return;
        }
        try {
            if (this.eventsTopicPath != null) {
                this.pubsub.deleteTopic(new PubsubClient.TopicPath(this.eventsTopicPath));
            }
        }
        finally {
            this.pubsub.close();
            this.pubsub = null;
            this.eventsTopicPath = null;
        }
    }

    static String createTopicName(Description description) throws IOException {
        StringBuilder topicName = new StringBuilder(TOPIC_PREFIX);
        if (description.getClassName() != null) {
            try {
                topicName.append(Class.forName(description.getClassName()).getSimpleName()).append("-");
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        if (description.getMethodName() != null) {
            topicName.append(description.getMethodName()).append("-");
        }
        DATETIME_FORMAT.printTo((Appendable)topicName, (ReadableInstant)Instant.now());
        return topicName.toString() + "-" + String.valueOf(ThreadLocalRandom.current().nextLong());
    }

    public String topicPath() {
        return this.eventsTopicPath;
    }

    public void publish(List<PubsubMessage> messages) throws IOException {
        List<PubsubClient.OutgoingMessage> outgoingMessages = messages.stream().map(this::toOutgoingMessage).collect(Collectors.toList());
        this.pubsub.publish(new PubsubClient.TopicPath(this.eventsTopicPath), outgoingMessages);
    }

    private PubsubClient.OutgoingMessage toOutgoingMessage(PubsubMessage message) {
        return new PubsubClient.OutgoingMessage(message.getPayload(), message.getAttributeMap(), DateTime.now().getMillis(), null);
    }
}

