/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsublite;

import com.google.auto.service.AutoService;
import com.google.auto.value.AutoValue;
import com.google.cloud.pubsublite.CloudRegionOrZone;
import com.google.cloud.pubsublite.ProjectId;
import com.google.cloud.pubsublite.SubscriptionName;
import com.google.cloud.pubsublite.SubscriptionPath;
import com.google.cloud.pubsublite.proto.SequencedMessage;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.avro.Schema;
import org.apache.beam.sdk.extensions.avro.schemas.utils.AvroUtils;
import org.apache.beam.sdk.extensions.gcp.options.GcpOptions;
import org.apache.beam.sdk.io.gcp.pubsublite.AutoValue_PubsubLiteReadSchemaTransformProvider_PubsubLiteReadSchemaTransformConfiguration;
import org.apache.beam.sdk.io.gcp.pubsublite.PubsubLiteIO;
import org.apache.beam.sdk.io.gcp.pubsublite.SubscriberOptions;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.schemas.AutoValueSchema;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.annotations.DefaultSchema;
import org.apache.beam.sdk.schemas.annotations.SchemaFieldDescription;
import org.apache.beam.sdk.schemas.transforms.SchemaTransform;
import org.apache.beam.sdk.schemas.transforms.SchemaTransformProvider;
import org.apache.beam.sdk.schemas.transforms.TypedSchemaTransformProvider;
import org.apache.beam.sdk.schemas.utils.JsonUtils;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionRowTuple;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Strings;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Sets;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={SchemaTransformProvider.class})
public class PubsubLiteReadSchemaTransformProvider
extends TypedSchemaTransformProvider<PubsubLiteReadSchemaTransformConfiguration> {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(PubsubLiteReadSchemaTransformProvider.class);
    public static final @UnknownKeyFor @NonNull @Initialized String VALID_FORMATS_STR = "AVRO,JSON";
    public static final @UnknownKeyFor @NonNull @Initialized Set<@UnknownKeyFor @NonNull @Initialized String> VALID_DATA_FORMATS = Sets.newHashSet((Object[])"AVRO,JSON".split(","));
    public static final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized Row> OUTPUT_TAG = new TupleTag<Row>(){};
    public static final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized Row> ERROR_TAG = new TupleTag<Row>(){};
    public static final @UnknownKeyFor @NonNull @Initialized Schema ERROR_SCHEMA = Schema.builder().addStringField("error").addNullableByteArrayField("row").build();

    protected @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized PubsubLiteReadSchemaTransformConfiguration> configurationClass() {
        return PubsubLiteReadSchemaTransformConfiguration.class;
    }

    public @UnknownKeyFor @NonNull @Initialized SchemaTransform from(final @UnknownKeyFor @NonNull @Initialized PubsubLiteReadSchemaTransformConfiguration configuration) {
        if (!VALID_DATA_FORMATS.contains(configuration.getFormat())) {
            throw new IllegalArgumentException(String.format("Format %s not supported. Only supported formats are %s", configuration.getFormat(), VALID_FORMATS_STR));
        }
        Schema beamSchema = Objects.equals(configuration.getFormat(), "JSON") ? JsonUtils.beamSchemaFromJsonSchema((String)configuration.getSchema()) : AvroUtils.toBeamSchema((org.apache.avro.Schema)new Schema.Parser().parse(configuration.getSchema()));
        SimpleFunction valueMapper = Objects.equals(configuration.getFormat(), "JSON") ? JsonUtils.getJsonBytesToRowFunction((Schema)beamSchema) : AvroUtils.getAvroBytesToRowFunction((Schema)beamSchema);
        return new SchemaTransform((SerializableFunction)valueMapper, beamSchema){
            final /* synthetic */ SerializableFunction val$valueMapper;
            final /* synthetic */ Schema val$beamSchema;
            {
                this.val$valueMapper = serializableFunction;
                this.val$beamSchema = schema;
            }

            public @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollectionRowTuple, @UnknownKeyFor @NonNull @Initialized PCollectionRowTuple> buildTransform() {
                return new PTransform<PCollectionRowTuple, PCollectionRowTuple>(){

                    public @UnknownKeyFor @NonNull @Initialized PCollectionRowTuple expand(@UnknownKeyFor @NonNull @Initialized PCollectionRowTuple input) {
                        String project = configuration.getProject();
                        if (Strings.isNullOrEmpty((String)project)) {
                            project = ((GcpOptions)input.getPipeline().getOptions().as(GcpOptions.class)).getProject();
                        }
                        if (project == null) {
                            throw new IllegalArgumentException("Unable to infer the project to read from Pubsub Lite. Please provide a project.");
                        }
                        PCollectionTuple outputTuple = (PCollectionTuple)((PCollection)input.getPipeline().apply(PubsubLiteIO.read(SubscriberOptions.newBuilder().setSubscriptionPath(((SubscriptionPath.Builder)((SubscriptionPath.Builder)SubscriptionPath.newBuilder().setLocation(CloudRegionOrZone.parse((String)configuration.getLocation()))).setProject(ProjectId.of((String)project))).setName(SubscriptionName.of((String)configuration.getSubscriptionName())).build()).build()))).apply((PTransform)ParDo.of((DoFn)new ErrorFn("PubsubLite-read-error-counter", (SerializableFunction<byte[], Row>)val$valueMapper)).withOutputTags(OUTPUT_TAG, TupleTagList.of(ERROR_TAG)));
                        return PCollectionRowTuple.of((String)"output", (PCollection)outputTuple.get(OUTPUT_TAG).setRowSchema(val$beamSchema), (String)"errors", (PCollection)outputTuple.get(ERROR_TAG).setRowSchema(ERROR_SCHEMA));
                    }
                };
            }
        };
    }

    public @UnknownKeyFor @NonNull @Initialized String identifier() {
        return "beam:schematransform:org.apache.beam:pubsublite_read:v1";
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> inputCollectionNames() {
        return Collections.emptyList();
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> outputCollectionNames() {
        return Arrays.asList("output", "errors");
    }

    @DefaultSchema(value=AutoValueSchema.class)
    @AutoValue
    public static abstract class PubsubLiteReadSchemaTransformConfiguration {
        @SchemaFieldDescription(value="The encoding format for the data stored in Pubsub Lite. Valid options are: AVRO,JSON")
        public abstract @UnknownKeyFor @NonNull @Initialized String getFormat();

        @SchemaFieldDescription(value="The schema in which the data is encoded in the Kafka topic. For AVRO data, this is a schema defined with AVRO schema syntax (https://avro.apache.org/docs/1.10.2/spec.html#schemas). For JSON data, this is a schema defined with JSON-schema syntax (https://json-schema.org/).")
        public abstract @UnknownKeyFor @NonNull @Initialized String getSchema();

        @SchemaFieldDescription(value="The GCP project where the Pubsub Lite reservation resides. This can be a project number of a project ID.")
        public abstract @Nullable @UnknownKeyFor @Initialized String getProject();

        @SchemaFieldDescription(value="The name of the subscription to consume data. This will be concatenated with the project and location parameters to build a full subscription path.")
        public abstract @UnknownKeyFor @NonNull @Initialized String getSubscriptionName();

        @SchemaFieldDescription(value="The region or zone where the Pubsub Lite reservation resides.")
        public abstract @UnknownKeyFor @NonNull @Initialized String getLocation();

        public static @UnknownKeyFor @NonNull @Initialized Builder builder() {
            return new AutoValue_PubsubLiteReadSchemaTransformProvider_PubsubLiteReadSchemaTransformConfiguration.Builder();
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract @UnknownKeyFor @NonNull @Initialized Builder setFormat(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setSchema(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setProject(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setSubscriptionName(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized Builder setLocation(@UnknownKeyFor @NonNull @Initialized String var1);

            public abstract @UnknownKeyFor @NonNull @Initialized PubsubLiteReadSchemaTransformConfiguration build();
        }
    }

    public static class ErrorFn
    extends DoFn<SequencedMessage, Row> {
        private @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized Row> valueMapper;
        private @UnknownKeyFor @NonNull @Initialized Counter errorCounter;
        private @UnknownKeyFor @NonNull @Initialized Long errorsInBundle = 0L;

        public ErrorFn(@UnknownKeyFor @NonNull @Initialized String name, @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [], @UnknownKeyFor @NonNull @Initialized Row> valueMapper) {
            this.errorCounter = Metrics.counter(PubsubLiteReadSchemaTransformProvider.class, (String)name);
            this.valueMapper = valueMapper;
        }

        @DoFn.ProcessElement
        public void process(@DoFn.Element @UnknownKeyFor @NonNull @Initialized SequencedMessage seqMessage, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DoFn.MultiOutputReceiver receiver) {
            try {
                receiver.get(OUTPUT_TAG).output((Object)((Row)this.valueMapper.apply((Object)seqMessage.getMessage().getData().toByteArray())));
            }
            catch (Exception e) {
                this.errorsInBundle = this.errorsInBundle + 1L;
                LOG.warn("Error while parsing the element", (Throwable)e);
                receiver.get(ERROR_TAG).output((Object)Row.withSchema((Schema)ERROR_SCHEMA).addValues(new Object[]{e.toString(), seqMessage.getMessage().getData().toByteArray()}).build());
            }
        }

        @DoFn.FinishBundle
        public void finish(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized FinishBundleContext c) {
            this.errorCounter.inc(this.errorsInBundle.longValue());
            this.errorsInBundle = 0L;
        }
    }
}

