/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableSchema;
import java.util.ArrayList;
import java.util.Map;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServicesImpl;
import org.apache.beam.sdk.io.gcp.bigquery.CreateTableHelpers;
import org.apache.beam.sdk.io.gcp.bigquery.DynamicDestinations;
import org.apache.beam.sdk.io.gcp.bigquery.TableDestination;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Supplier;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Maps;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class CreateTableDestinations<@UnknownKeyFor DestinationT, @UnknownKeyFor ElementT>
extends PTransform<PCollection<KV<DestinationT, ElementT>>, PCollection<KV<DestinationT, ElementT>>> {
    private final  @UnknownKeyFor @NonNull @Initialized BigQueryIO.Write.CreateDisposition createDisposition;
    private final @UnknownKeyFor @NonNull @Initialized BigQueryServices bqServices;
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized DynamicDestinations<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, DestinationT> dynamicDestinations;
    private final @Nullable @UnknownKeyFor @Initialized String kmsKey;

    public CreateTableDestinations( @UnknownKeyFor @NonNull @Initialized BigQueryIO.Write.CreateDisposition createDisposition, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized DynamicDestinations<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, DestinationT> dynamicDestinations) {
        this(createDisposition, new BigQueryServicesImpl(), dynamicDestinations, null);
    }

    public CreateTableDestinations( @UnknownKeyFor @NonNull @Initialized BigQueryIO.Write.CreateDisposition createDisposition, @UnknownKeyFor @NonNull @Initialized BigQueryServices bqServices, /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized DynamicDestinations<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, DestinationT> dynamicDestinations, @Nullable @UnknownKeyFor @Initialized String kmsKey) {
        this.createDisposition = createDisposition;
        this.bqServices = bqServices;
        this.dynamicDestinations = dynamicDestinations;
        this.kmsKey = kmsKey;
    }

    @UnknownKeyFor @NonNull @Initialized CreateTableDestinations<DestinationT, ElementT> withKmsKey(@UnknownKeyFor @NonNull @Initialized String kmsKey) {
        return new CreateTableDestinations<DestinationT, ElementT>(this.createDisposition, this.bqServices, this.dynamicDestinations, kmsKey);
    }

    @UnknownKeyFor @NonNull @Initialized CreateTableDestinations<DestinationT, ElementT> withTestServices(@UnknownKeyFor @NonNull @Initialized BigQueryServices bqServices) {
        return new CreateTableDestinations<DestinationT, ElementT>(this.createDisposition, bqServices, this.dynamicDestinations, this.kmsKey);
    }

    public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<DestinationT, ElementT>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<DestinationT, ElementT>> input) {
        ArrayList sideInputs = Lists.newArrayList();
        sideInputs.addAll(this.dynamicDestinations.getSideInputs());
        return (PCollection)input.apply("CreateTables", (PTransform)ParDo.of((DoFn)new CreateTablesFn()).withSideInputs((Iterable)sideInputs));
    }

    private class CreateTablesFn
    extends DoFn<KV<DestinationT, ElementT>, KV<DestinationT, ElementT>> {
        private @UnknownKeyFor @NonNull @Initialized Map<DestinationT, @UnknownKeyFor @NonNull @Initialized TableDestination> destinations = Maps.newHashMap();

        private CreateTablesFn() {
        }

        @DoFn.StartBundle
        public void startBundle() {
            this.destinations = Maps.newHashMap();
        }

        @DoFn.ProcessElement
        public void processElement(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @NonNull @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext context, @DoFn.Element @UnknownKeyFor @NonNull @Initialized KV<DestinationT, ElementT> element, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized KV<DestinationT, ElementT>> o) {
            CreateTableDestinations.this.dynamicDestinations.setSideInputAccessorFromProcessContext(context);
            this.destinations.computeIfAbsent(element.getKey(), dest -> {
                @Nullable TableDestination tableDestination1 = CreateTableDestinations.this.dynamicDestinations.getTable(dest);
                Preconditions.checkArgument((tableDestination1 != null ? 1 : 0) != 0, (String)"DynamicDestinations.getTable() may not return null, but %s returned null for destination %s", (Object)CreateTableDestinations.this.dynamicDestinations, (Object)dest);
                @Nullable Coder<DestinationT> destinationCoder = CreateTableDestinations.this.dynamicDestinations.getDestinationCoder();
                @Nullable Supplier schemaSupplier = () -> CreateTableDestinations.this.dynamicDestinations.getSchema(dest);
                return CreateTableHelpers.possiblyCreateTable(context, tableDestination1, (Supplier<TableSchema>)schemaSupplier, CreateTableDestinations.this.createDisposition, destinationCoder, CreateTableDestinations.this.kmsKey, CreateTableDestinations.this.bqServices);
            });
            o.output(element);
        }
    }
}

