/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigtable.changestreams.restriction;

import com.google.cloud.bigtable.data.v2.models.ChangeStreamContinuationToken;
import com.google.cloud.bigtable.data.v2.models.CloseStream;
import java.io.Serializable;
import java.util.Objects;
import org.apache.beam.sdk.annotations.Internal;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.joda.time.Instant;

@Internal
public class StreamProgress
implements Serializable {
    private static final @UnknownKeyFor @NonNull @Initialized long serialVersionUID = -8597355120329526194L;
    private @Nullable @UnknownKeyFor @Initialized ChangeStreamContinuationToken currentToken;
    private @Nullable @UnknownKeyFor @Initialized Instant estimatedLowWatermark;
    private @Nullable @UnknownKeyFor @Initialized CloseStream closeStream;
    private @UnknownKeyFor @NonNull @Initialized boolean failToLock;

    public StreamProgress() {
    }

    public StreamProgress(@Nullable @UnknownKeyFor @Initialized ChangeStreamContinuationToken token, @UnknownKeyFor @NonNull @Initialized Instant estimatedLowWatermark) {
        this.currentToken = token;
        this.estimatedLowWatermark = estimatedLowWatermark;
    }

    public StreamProgress(@Nullable @UnknownKeyFor @Initialized CloseStream closeStream) {
        this.closeStream = closeStream;
    }

    public @Nullable @UnknownKeyFor @Initialized ChangeStreamContinuationToken getCurrentToken() {
        return this.currentToken;
    }

    public @Nullable @UnknownKeyFor @Initialized Instant getEstimatedLowWatermark() {
        return this.estimatedLowWatermark;
    }

    public @Nullable @UnknownKeyFor @Initialized CloseStream getCloseStream() {
        return this.closeStream;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean isFailToLock() {
        return this.failToLock;
    }

    public void setFailToLock(@UnknownKeyFor @NonNull @Initialized boolean failToLock) {
        this.failToLock = failToLock;
    }

    @EnsuresNonNullIf(expression={"#1"}, result=true)
    @Pure
    public @UnknownKeyFor @NonNull @Initialized boolean equals(@Nullable @UnknownKeyFor @Initialized Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StreamProgress)) {
            return false;
        }
        StreamProgress that = (StreamProgress)o;
        return Objects.equals(this.getCurrentToken(), that.getCurrentToken()) && Objects.equals(this.getEstimatedLowWatermark(), that.getEstimatedLowWatermark()) && Objects.equals(this.getCloseStream(), that.getCloseStream()) && this.isFailToLock() == that.isFailToLock();
    }

    @Pure
    public @UnknownKeyFor @NonNull @Initialized int hashCode() {
        return Objects.hash(this.getCurrentToken(), this.getCloseStream());
    }

    @SideEffectFree
    public @UnknownKeyFor @NonNull @Initialized String toString() {
        return "StreamProgress{currentToken=" + this.currentToken + ", estimatedLowWatermark=" + this.estimatedLowWatermark + ", closeStream=" + this.closeStream + ", failToLock=" + this.failToLock + '}';
    }
}

