/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigtable.changestreams.dao;

import com.google.cloud.bigtable.admin.v2.BigtableInstanceAdminClient;
import com.google.cloud.bigtable.admin.v2.BigtableTableAdminClient;
import com.google.cloud.bigtable.data.v2.BigtableDataClient;
import java.io.IOException;
import java.io.Serializable;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.io.gcp.bigtable.BigtableConfig;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.dao.BigtableChangeStreamAccessor;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.dao.ChangeStreamDao;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.dao.MetadataTableAdminDao;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.dao.MetadataTableDao;
import org.apache.beam.sdk.util.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@Internal
public class DaoFactory
implements Serializable {
    private static final @UnknownKeyFor @NonNull @Initialized long serialVersionUID = 3732208768248394205L;
    private transient @UnknownKeyFor @NonNull @Initialized ChangeStreamDao changeStreamDao;
    private transient @UnknownKeyFor @NonNull @Initialized MetadataTableAdminDao metadataTableAdminDao;
    private transient @UnknownKeyFor @NonNull @Initialized MetadataTableDao metadataTableDao;
    private final @UnknownKeyFor @NonNull @Initialized BigtableConfig changeStreamConfig;
    private final @UnknownKeyFor @NonNull @Initialized BigtableConfig metadataTableConfig;
    private final @UnknownKeyFor @NonNull @Initialized String tableId;
    private final @UnknownKeyFor @NonNull @Initialized String metadataTableId;
    private final @UnknownKeyFor @NonNull @Initialized String changeStreamName;

    public DaoFactory(@UnknownKeyFor @NonNull @Initialized BigtableConfig changeStreamConfig, @UnknownKeyFor @NonNull @Initialized BigtableConfig metadataTableConfig, @UnknownKeyFor @NonNull @Initialized String tableId, @UnknownKeyFor @NonNull @Initialized String metadataTableId, @UnknownKeyFor @NonNull @Initialized String changeStreamName) {
        this.changeStreamConfig = changeStreamConfig;
        this.metadataTableConfig = metadataTableConfig;
        this.changeStreamName = changeStreamName;
        this.tableId = tableId;
        this.metadataTableId = metadataTableId;
    }

    public @UnknownKeyFor @NonNull @Initialized String getChangeStreamName() {
        return this.changeStreamName;
    }

    public @UnknownKeyFor @NonNull @Initialized String getStreamTableDebugString() {
        return String.format("Stream Table:\nProject ID: %s\nInstance ID: %s\nTable Id: %s\nApp Profile Id: %s", this.changeStreamConfig.getProjectId(), this.changeStreamConfig.getInstanceId(), this.tableId, this.changeStreamConfig.getAppProfileId());
    }

    public @UnknownKeyFor @NonNull @Initialized String getMetadataTableDebugString() {
        return String.format("Metadata Table:\nProject ID: %s\nInstance ID: %s\nTable Id: %s\nApp Profile Id: %s", this.metadataTableConfig.getProjectId(), this.metadataTableConfig.getInstanceId(), this.metadataTableId, this.metadataTableConfig.getAppProfileId());
    }

    public synchronized @UnknownKeyFor @NonNull @Initialized ChangeStreamDao getChangeStreamDao() throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (this.changeStreamDao == null) {
            Preconditions.checkArgumentNotNull(this.changeStreamConfig.getProjectId());
            Preconditions.checkArgumentNotNull(this.changeStreamConfig.getInstanceId());
            String tableId = this.tableId;
            Preconditions.checkArgumentNotNull(this.changeStreamConfig.getAppProfileId());
            BigtableDataClient dataClient = BigtableChangeStreamAccessor.getOrCreate(this.changeStreamConfig).getDataClient();
            this.changeStreamDao = new ChangeStreamDao(dataClient, tableId);
        }
        return this.changeStreamDao;
    }

    public synchronized @UnknownKeyFor @NonNull @Initialized MetadataTableDao getMetadataTableDao() throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (this.metadataTableDao == null) {
            Preconditions.checkArgumentNotNull(this.metadataTableConfig.getProjectId());
            Preconditions.checkArgumentNotNull(this.metadataTableConfig.getInstanceId());
            Preconditions.checkArgumentNotNull((Object)this.metadataTableId);
            Preconditions.checkArgumentNotNull(this.metadataTableConfig.getAppProfileId());
            BigtableDataClient dataClient = BigtableChangeStreamAccessor.getOrCreate(this.metadataTableConfig).getDataClient();
            this.metadataTableDao = new MetadataTableDao(dataClient, this.getMetadataTableAdminDao().getTableId(), this.getMetadataTableAdminDao().getChangeStreamNamePrefix());
        }
        return this.metadataTableDao;
    }

    public synchronized @UnknownKeyFor @NonNull @Initialized MetadataTableAdminDao getMetadataTableAdminDao() throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (this.metadataTableAdminDao == null) {
            Preconditions.checkArgumentNotNull(this.metadataTableConfig.getProjectId());
            Preconditions.checkArgumentNotNull(this.metadataTableConfig.getInstanceId());
            String tableId = (String)Preconditions.checkArgumentNotNull((Object)this.metadataTableId);
            Preconditions.checkArgumentNotNull(this.metadataTableConfig.getAppProfileId());
            BigtableTableAdminClient tableAdminClient = BigtableChangeStreamAccessor.getOrCreate(this.metadataTableConfig).getTableAdminClient();
            BigtableInstanceAdminClient instanceAdminClient = BigtableChangeStreamAccessor.getOrCreate(this.metadataTableConfig).getInstanceAdminClient();
            this.metadataTableAdminDao = new MetadataTableAdminDao(tableAdminClient, instanceAdminClient, this.changeStreamName, tableId);
        }
        return this.metadataTableAdminDao;
    }
}

