/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigtable.changestreams.dao;

import com.google.api.gax.retrying.RetrySettings;
import com.google.cloud.bigtable.admin.v2.BigtableInstanceAdminClient;
import com.google.cloud.bigtable.admin.v2.BigtableInstanceAdminSettings;
import com.google.cloud.bigtable.admin.v2.BigtableTableAdminClient;
import com.google.cloud.bigtable.admin.v2.BigtableTableAdminSettings;
import com.google.cloud.bigtable.data.v2.BigtableDataClient;
import com.google.cloud.bigtable.data.v2.BigtableDataSettings;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.io.gcp.bigtable.BigtableConfig;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.util.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.threeten.bp.Duration;

@Internal
class BigtableChangeStreamAccessor {
    private static final @UnknownKeyFor @NonNull @Initialized ConcurrentHashMap<@UnknownKeyFor @NonNull @Initialized BigtableConfig, @UnknownKeyFor @NonNull @Initialized BigtableChangeStreamAccessor> bigtableAccessors = new ConcurrentHashMap();
    private final @UnknownKeyFor @NonNull @Initialized BigtableDataClient dataClient;
    private final @UnknownKeyFor @NonNull @Initialized BigtableTableAdminClient tableAdminClient;
    private final @UnknownKeyFor @NonNull @Initialized BigtableInstanceAdminClient instanceAdminClient;

    private BigtableChangeStreamAccessor(@UnknownKeyFor @NonNull @Initialized BigtableDataClient dataClient, @UnknownKeyFor @NonNull @Initialized BigtableTableAdminClient tableAdminClient, @UnknownKeyFor @NonNull @Initialized BigtableInstanceAdminClient instanceAdminClient) {
        this.dataClient = dataClient;
        this.tableAdminClient = tableAdminClient;
        this.instanceAdminClient = instanceAdminClient;
    }

    public static synchronized @UnknownKeyFor @NonNull @Initialized BigtableChangeStreamAccessor getOrCreate(@NonNull @UnknownKeyFor @Initialized BigtableConfig bigtableConfig) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (bigtableAccessors.get(bigtableConfig) == null) {
            BigtableChangeStreamAccessor bigtableAccessor = BigtableChangeStreamAccessor.createAccessor(bigtableConfig);
            bigtableAccessors.put(bigtableConfig, bigtableAccessor);
        }
        return (BigtableChangeStreamAccessor)Preconditions.checkStateNotNull((Object)bigtableAccessors.get(bigtableConfig));
    }

    private static @UnknownKeyFor @NonNull @Initialized BigtableChangeStreamAccessor createAccessor(@NonNull @UnknownKeyFor @Initialized BigtableConfig bigtableConfig) throws @UnknownKeyFor @NonNull @Initialized IOException {
        String projectId = (String)((ValueProvider)Preconditions.checkArgumentNotNull(bigtableConfig.getProjectId())).get();
        String instanceId = (String)((ValueProvider)Preconditions.checkArgumentNotNull(bigtableConfig.getInstanceId())).get();
        String appProfileId = (String)((ValueProvider)Preconditions.checkArgumentNotNull(bigtableConfig.getAppProfileId())).get();
        BigtableDataSettings.Builder dataSettingsBuilder = BigtableDataSettings.newBuilder();
        BigtableTableAdminSettings.Builder tableAdminSettingsBuilder = BigtableTableAdminSettings.newBuilder();
        BigtableInstanceAdminSettings.Builder instanceAdminSettingsBuilder = BigtableInstanceAdminSettings.newBuilder();
        dataSettingsBuilder.setProjectId(projectId);
        tableAdminSettingsBuilder.setProjectId(projectId);
        instanceAdminSettingsBuilder.setProjectId(projectId);
        dataSettingsBuilder.setInstanceId(instanceId);
        tableAdminSettingsBuilder.setInstanceId(instanceId);
        if (appProfileId != null) {
            dataSettingsBuilder.setAppProfileId(appProfileId);
        }
        RetrySettings.Builder readRowRetrySettings = dataSettingsBuilder.stubSettings().readRowSettings().retrySettings();
        dataSettingsBuilder.stubSettings().readRowSettings().setRetrySettings(readRowRetrySettings.setInitialRpcTimeout(Duration.ofSeconds((long)30L)).setTotalTimeout(Duration.ofSeconds((long)30L)).setMaxRpcTimeout(Duration.ofSeconds((long)30L)).setMaxAttempts(10).build());
        RetrySettings.Builder readRowsRetrySettings = dataSettingsBuilder.stubSettings().readRowsSettings().retrySettings();
        dataSettingsBuilder.stubSettings().readRowsSettings().setRetrySettings(readRowsRetrySettings.setInitialRpcTimeout(Duration.ofSeconds((long)30L)).setTotalTimeout(Duration.ofSeconds((long)30L)).setMaxRpcTimeout(Duration.ofSeconds((long)30L)).setMaxAttempts(10).build());
        RetrySettings.Builder mutateRowRetrySettings = dataSettingsBuilder.stubSettings().mutateRowSettings().retrySettings();
        dataSettingsBuilder.stubSettings().mutateRowSettings().setRetrySettings(mutateRowRetrySettings.setInitialRpcTimeout(Duration.ofSeconds((long)30L)).setTotalTimeout(Duration.ofSeconds((long)30L)).setMaxRpcTimeout(Duration.ofSeconds((long)30L)).setMaxAttempts(10).build());
        RetrySettings.Builder checkAndMutateRowRetrySettings = dataSettingsBuilder.stubSettings().checkAndMutateRowSettings().retrySettings();
        dataSettingsBuilder.stubSettings().checkAndMutateRowSettings().setRetrySettings(checkAndMutateRowRetrySettings.setInitialRpcTimeout(Duration.ofSeconds((long)30L)).setTotalTimeout(Duration.ofSeconds((long)30L)).setMaxRpcTimeout(Duration.ofSeconds((long)30L)).setMaxAttempts(10).build());
        RetrySettings.Builder readChangeStreamRetrySettings = dataSettingsBuilder.stubSettings().readChangeStreamSettings().retrySettings();
        dataSettingsBuilder.stubSettings().readChangeStreamSettings().setRetrySettings(readChangeStreamRetrySettings.setInitialRpcTimeout(Duration.ofSeconds((long)60L)).setTotalTimeout(Duration.ofSeconds((long)60L)).setMaxRpcTimeout(Duration.ofSeconds((long)60L)).setMaxAttempts(3).build());
        BigtableDataClient dataClient = BigtableDataClient.create((BigtableDataSettings)dataSettingsBuilder.build());
        BigtableTableAdminClient tableAdminClient = BigtableTableAdminClient.create((BigtableTableAdminSettings)tableAdminSettingsBuilder.build());
        BigtableInstanceAdminClient instanceAdminClient = BigtableInstanceAdminClient.create((BigtableInstanceAdminSettings)instanceAdminSettingsBuilder.build());
        return new BigtableChangeStreamAccessor(dataClient, tableAdminClient, instanceAdminClient);
    }

    public @UnknownKeyFor @NonNull @Initialized BigtableDataClient getDataClient() {
        return this.dataClient;
    }

    public @UnknownKeyFor @NonNull @Initialized BigtableTableAdminClient getTableAdminClient() {
        return this.tableAdminClient;
    }

    public @UnknownKeyFor @NonNull @Initialized BigtableInstanceAdminClient getInstanceAdminClient() {
        return this.instanceAdminClient;
    }
}

