/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.Table;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.auto.service.AutoService;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryFileLoadsWriteSchemaTransformConfiguration;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServicesImpl;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryUtils;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.io.InvalidConfigurationException;
import org.apache.beam.sdk.schemas.transforms.SchemaTransform;
import org.apache.beam.sdk.schemas.transforms.SchemaTransformProvider;
import org.apache.beam.sdk.schemas.transforms.TypedSchemaTransformProvider;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionRowTuple;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

@Internal
@Experimental(value=Experimental.Kind.SCHEMAS)
@AutoService(value={SchemaTransformProvider.class})
public class BigQueryFileLoadsWriteSchemaTransformProvider
extends TypedSchemaTransformProvider<BigQueryFileLoadsWriteSchemaTransformConfiguration> {
    private static final @UnknownKeyFor @NonNull @Initialized String IDENTIFIER = "beam:schematransform:org.apache.beam:bigquery_fileloads_write:v1";
    static final @UnknownKeyFor @NonNull @Initialized String INPUT_TAG = "INPUT";

    protected @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @NonNull @Initialized BigQueryFileLoadsWriteSchemaTransformConfiguration> configurationClass() {
        return BigQueryFileLoadsWriteSchemaTransformConfiguration.class;
    }

    protected @UnknownKeyFor @NonNull @Initialized SchemaTransform from(@UnknownKeyFor @NonNull @Initialized BigQueryFileLoadsWriteSchemaTransformConfiguration configuration) {
        return new BigQueryWriteSchemaTransform(configuration);
    }

    public @UnknownKeyFor @NonNull @Initialized String identifier() {
        return IDENTIFIER;
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> inputCollectionNames() {
        return Collections.singletonList(INPUT_TAG);
    }

    public @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> outputCollectionNames() {
        return Collections.emptyList();
    }

    static class PCollectionRowTupleTransform
    extends PTransform<PCollectionRowTuple, PCollectionRowTuple> {
        private final @UnknownKeyFor @NonNull @Initialized BigQueryFileLoadsWriteSchemaTransformConfiguration configuration;
        private @UnknownKeyFor @NonNull @Initialized BigQueryServices testBigQueryServices = null;

        PCollectionRowTupleTransform(@UnknownKeyFor @NonNull @Initialized BigQueryFileLoadsWriteSchemaTransformConfiguration configuration) {
            this.configuration = configuration;
        }

        public void validate(@UnknownKeyFor @NonNull @Initialized PipelineOptions options) {
            if (!this.configuration.getCreateDisposition().equals(BigQueryIO.Write.CreateDisposition.CREATE_NEVER.name())) {
                return;
            }
            BigQueryOptions bigQueryOptions = (BigQueryOptions)options.as(BigQueryOptions.class);
            BigQueryServices bigQueryServices = new BigQueryServicesImpl();
            if (this.testBigQueryServices != null) {
                bigQueryServices = this.testBigQueryServices;
            }
            BigQueryServices.DatasetService datasetService = bigQueryServices.getDatasetService(bigQueryOptions);
            TableReference tableReference = BigQueryUtils.toTableReference(this.configuration.getTableSpec());
            try {
                Table table = datasetService.getTable(tableReference);
                if (table == null) {
                    throw new NullPointerException();
                }
                if (table.getSchema() == null) {
                    throw new InvalidConfigurationException(String.format("could not fetch schema for table: %s", this.configuration.getTableSpec()));
                }
            }
            catch (IOException | InterruptedException | NullPointerException ex) {
                throw new InvalidConfigurationException(String.format("could not fetch table %s, error: %s", this.configuration.getTableSpec(), ex.getMessage()));
            }
        }

        public @UnknownKeyFor @NonNull @Initialized PCollectionRowTuple expand(@UnknownKeyFor @NonNull @Initialized PCollectionRowTuple input) {
            this.validate(input);
            PCollection rowPCollection = input.get(BigQueryFileLoadsWriteSchemaTransformProvider.INPUT_TAG);
            Schema schema = rowPCollection.getSchema();
            BigQueryIO.Write<TableRow> write = this.toWrite(schema);
            if (this.testBigQueryServices != null) {
                write = write.withTestServices(this.testBigQueryServices);
            }
            PCollection tableRowPCollection = (PCollection)rowPCollection.apply((PTransform)MapElements.into((TypeDescriptor)TypeDescriptor.of(TableRow.class)).via(BigQueryUtils::toTableRow));
            tableRowPCollection.apply(write);
            return PCollectionRowTuple.empty((Pipeline)input.getPipeline());
        }

        @UnknownKeyFor @NonNull @Initialized BigQueryIO.Write<@UnknownKeyFor @NonNull @Initialized TableRow> toWrite(@UnknownKeyFor @NonNull @Initialized Schema schema) {
            TableSchema tableSchema = BigQueryUtils.toTableSchema(schema);
            BigQueryIO.Write.CreateDisposition createDisposition = BigQueryIO.Write.CreateDisposition.valueOf(this.configuration.getCreateDisposition());
            BigQueryIO.Write.WriteDisposition writeDisposition = BigQueryIO.Write.WriteDisposition.valueOf(this.configuration.getWriteDisposition());
            return BigQueryIO.writeTableRows().to(this.configuration.getTableSpec()).withCreateDisposition(createDisposition).withWriteDisposition(writeDisposition).withSchema(tableSchema);
        }

        @VisibleForTesting
        void setTestBigQueryServices(@UnknownKeyFor @NonNull @Initialized BigQueryServices testBigQueryServices) {
            this.testBigQueryServices = testBigQueryServices;
        }

        void validate(@UnknownKeyFor @NonNull @Initialized PCollectionRowTuple input) {
            if (!input.has(BigQueryFileLoadsWriteSchemaTransformProvider.INPUT_TAG)) {
                throw new IllegalArgumentException(String.format("%s %s is missing expected tag: %s", ((Object)((Object)this)).getClass().getSimpleName(), input.getClass().getSimpleName(), BigQueryFileLoadsWriteSchemaTransformProvider.INPUT_TAG));
            }
            PCollection rowInput = input.get(BigQueryFileLoadsWriteSchemaTransformProvider.INPUT_TAG);
            Schema sourceSchema = rowInput.getSchema();
            if (sourceSchema == null) {
                throw new IllegalArgumentException(String.format("%s is null for input of tag: %s", Schema.class, BigQueryFileLoadsWriteSchemaTransformProvider.INPUT_TAG));
            }
            if (!this.configuration.getCreateDisposition().equals(BigQueryIO.Write.CreateDisposition.CREATE_NEVER.name())) {
                return;
            }
            BigQueryOptions bigQueryOptions = (BigQueryOptions)input.getPipeline().getOptions().as(BigQueryOptions.class);
            BigQueryServices bigQueryServices = new BigQueryServicesImpl();
            if (this.testBigQueryServices != null) {
                bigQueryServices = this.testBigQueryServices;
            }
            BigQueryServices.DatasetService datasetService = bigQueryServices.getDatasetService(bigQueryOptions);
            TableReference tableReference = BigQueryUtils.toTableReference(this.configuration.getTableSpec());
            try {
                Table table = datasetService.getTable(tableReference);
                if (table == null) {
                    throw new NullPointerException();
                }
                TableSchema tableSchema = table.getSchema();
                if (tableSchema == null) {
                    throw new NullPointerException();
                }
                Schema destinationSchema = BigQueryUtils.fromTableSchema(tableSchema);
                if (destinationSchema == null) {
                    throw new NullPointerException();
                }
                this.validateMatching(sourceSchema, destinationSchema);
            }
            catch (IOException | InterruptedException | NullPointerException e) {
                throw new InvalidConfigurationException(String.format("could not validate input for create disposition: %s and table: %s, error: %s", this.configuration.getCreateDisposition(), this.configuration.getTableSpec(), e.getMessage()));
            }
        }

        void validateMatching(@UnknownKeyFor @NonNull @Initialized Schema sourceSchema, @UnknownKeyFor @NonNull @Initialized Schema destinationSchema) {
            if (!sourceSchema.equals((Object)destinationSchema)) {
                throw new IllegalArgumentException(String.format("source and destination schema mismatch for table: %s", this.configuration.getTableSpec()));
            }
        }
    }

    private static class BigQueryWriteSchemaTransform
    implements SchemaTransform {
        private final @UnknownKeyFor @NonNull @Initialized BigQueryFileLoadsWriteSchemaTransformConfiguration configuration;

        BigQueryWriteSchemaTransform(@UnknownKeyFor @NonNull @Initialized BigQueryFileLoadsWriteSchemaTransformConfiguration configuration) {
            this.configuration = configuration;
        }

        public @UnknownKeyFor @NonNull @Initialized PTransform<@UnknownKeyFor @NonNull @Initialized PCollectionRowTuple, @UnknownKeyFor @NonNull @Initialized PCollectionRowTuple> buildTransform() {
            return new PCollectionRowTupleTransform(this.configuration);
        }
    }
}

