/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsub;

import java.util.Collection;
import java.util.Map;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubMessage;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubSchemaIOProvider;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.io.payloads.PayloadSerializer;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.util.Preconditions;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

class NestedRowToMessage
extends SimpleFunction<Row, PubsubMessage> {
    private static final @UnknownKeyFor @NonNull @Initialized long serialVersionUID = 65176815766314684L;
    private final @UnknownKeyFor @NonNull @Initialized PayloadSerializer serializer;
    private final @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Row, @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String>> attributesExtractor;
    private final @UnknownKeyFor @NonNull @Initialized SerializableFunction<@UnknownKeyFor @NonNull @Initialized Row, @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized []> payloadExtractor;

    NestedRowToMessage(@UnknownKeyFor @NonNull @Initialized PayloadSerializer serializer, @UnknownKeyFor @NonNull @Initialized Schema schema) {
        this.serializer = serializer;
        if (schema.getField("attributes").getType().equals((Object)PubsubSchemaIOProvider.ATTRIBUTE_MAP_FIELD_TYPE)) {
            this.attributesExtractor = NestedRowToMessage::getAttributesFromMap;
        } else {
            org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions.checkArgument((boolean)schema.getField("attributes").getType().equals((Object)PubsubSchemaIOProvider.ATTRIBUTE_ARRAY_FIELD_TYPE));
            this.attributesExtractor = NestedRowToMessage::getAttributesFromArray;
        }
        if (schema.getField("payload").getType().equals((Object)Schema.FieldType.BYTES)) {
            this.payloadExtractor = NestedRowToMessage::getPayloadFromBytes;
        } else {
            org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions.checkArgument((boolean)schema.getField("payload").getType().getTypeName().equals((Object)Schema.TypeName.ROW));
            this.payloadExtractor = this::getPayloadFromNested;
        }
    }

    private static @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> getAttributesFromMap(@UnknownKeyFor @NonNull @Initialized Row row) {
        return ImmutableMap.builder().putAll((Map)Preconditions.checkArgumentNotNull((Object)row.getMap("attributes"))).build();
    }

    private static @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> getAttributesFromArray(@UnknownKeyFor @NonNull @Initialized Row row) {
        ImmutableMap.Builder attributes = ImmutableMap.builder();
        Collection attributeEntries = (Collection)Preconditions.checkArgumentNotNull((Object)row.getArray("attributes"));
        for (Row entry : attributeEntries) {
            attributes.put((Object)((String)Preconditions.checkArgumentNotNull((Object)entry.getString("key"))), (Object)((String)Preconditions.checkArgumentNotNull((Object)entry.getString("value"))));
        }
        return attributes.build();
    }

    private static @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] getPayloadFromBytes(@UnknownKeyFor @NonNull @Initialized Row row) {
        return (byte[])Preconditions.checkArgumentNotNull((Object)row.getBytes("payload"));
    }

    private @UnknownKeyFor @NonNull @Initialized byte @UnknownKeyFor @NonNull @Initialized [] getPayloadFromNested(@UnknownKeyFor @NonNull @Initialized Row row) {
        return this.serializer.serialize((Row)Preconditions.checkArgumentNotNull((Object)row.getRow("payload")));
    }

    public @UnknownKeyFor @NonNull @Initialized PubsubMessage apply(@UnknownKeyFor @NonNull @Initialized Row row) {
        return new PubsubMessage((byte[])this.payloadExtractor.apply((Object)row), (Map)this.attributesExtractor.apply((Object)row));
    }
}

