/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableSchema;
import java.io.Serializable;
import java.util.List;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.io.gcp.bigquery.TableDestination;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.apache.beam.sdk.values.ValueInSingleWindow;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public abstract class DynamicDestinations<@UnknownKeyFor T, @UnknownKeyFor DestinationT>
implements Serializable {
    private transient @Nullable @UnknownKeyFor @Initialized SideInputAccessor sideInputAccessor;
    private transient @Nullable @UnknownKeyFor @Initialized PipelineOptions options;

    @Nullable @UnknownKeyFor @Initialized PipelineOptions getPipelineOptions() {
        return this.options;
    }

    public /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized PCollectionView<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?>> getSideInputs() {
        return Lists.newArrayList();
    }

    protected final <SideInputT> SideInputT sideInput(@UnknownKeyFor @NonNull @Initialized PCollectionView<SideInputT> view) {
        Preconditions.checkState((boolean)this.getSideInputs().contains(view), (String)"View %s not declared in getSideInputs() (%s)", view, this.getSideInputs());
        if (this.sideInputAccessor == null) {
            throw new IllegalStateException("sideInputAccessor (transient field) is null");
        }
        return this.sideInputAccessor.sideInput(view);
    }

    void setSideInputAccessorFromProcessContext(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    // Could not load outer class - annotation placement on inner may be incorrect
     @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @Nullable @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext context) {
        this.sideInputAccessor = new SideInputAccessorViaProcessContext(context);
        this.options = context.getPipelineOptions();
    }

    public abstract DestinationT getDestination(@Nullable @UnknownKeyFor @Initialized ValueInSingleWindow<T> var1);

    public @Nullable @UnknownKeyFor @Initialized Coder<DestinationT> getDestinationCoder() {
        return null;
    }

    public abstract @UnknownKeyFor @NonNull @Initialized TableDestination getTable(DestinationT var1);

    public abstract @Nullable @UnknownKeyFor @Initialized TableSchema getSchema(DestinationT var1);

    @UnknownKeyFor @NonNull @Initialized Coder<DestinationT> getDestinationCoderWithDefault(@UnknownKeyFor @NonNull @Initialized CoderRegistry registry) throws @UnknownKeyFor @NonNull @Initialized CannotProvideCoderException {
        Coder<DestinationT> destinationCoder = this.getDestinationCoder();
        if (destinationCoder != null) {
            return destinationCoder;
        }
        TypeDescriptor descriptor = TypeDescriptors.extractFromTypeParameters((Object)this, DynamicDestinations.class, (TypeDescriptors.TypeVariableExtractor)new TypeDescriptors.TypeVariableExtractor<DynamicDestinations<T, DestinationT>, DestinationT>(){});
        try {
            return registry.getCoder(descriptor);
        }
        catch (CannotProvideCoderException e) {
            throw new CannotProvideCoderException("Failed to infer coder for DestinationT from type " + descriptor + ", please provide it explicitly by overriding getDestinationCoder()", (Throwable)e);
        }
    }

    static class SideInputAccessorViaProcessContext
    implements SideInputAccessor {
        private /*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @Nullable @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext processContext;

        SideInputAccessorViaProcessContext(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        // Could not load outer class - annotation placement on inner may be incorrect
         @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized @Nullable @Initialized @NonNull @Initialized @NonNull @Initialized DoFn. @UnknownKeyFor @NonNull @Initialized ProcessContext processContext) {
            this.processContext = processContext;
        }

        @Override
        public <SideInputT> SideInputT sideInput(@UnknownKeyFor @NonNull @Initialized PCollectionView<SideInputT> view) {
            return (SideInputT)this.processContext.sideInput(view);
        }
    }

    static interface SideInputAccessor {
        public <SideInputT> SideInputT sideInput(@UnknownKeyFor @NonNull @Initialized PCollectionView<SideInputT> var1);
    }
}

