/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.beam.sdk.io.gcp.bigtable.changestreams.dofn;

import java.io.IOException;
import java.io.Serializable;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.io.gcp.bigtable.changestreams.dao.DaoFactory;
import org.apache.beam.sdk.transforms.DoFn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * A DoFn responsible to initialize the metadata table and prepare it for managing the state of the
 * pipeline.
 */
@SuppressWarnings("UnusedVariable")
@Internal
public class InitializeDoFn extends DoFn<byte[], com.google.cloud.Timestamp>
    implements Serializable {
  private static final long serialVersionUID = 1868189906451252363L;

  private static final Logger LOG = LoggerFactory.getLogger(InitializeDoFn.class);
  private final DaoFactory daoFactory;
  private final String metadataTableAppProfileId;
  private com.google.cloud.Timestamp startTime;

  public InitializeDoFn(
      DaoFactory daoFactory,
      String metadataTableAppProfileId,
      com.google.cloud.Timestamp startTime) {
    this.daoFactory = daoFactory;
    this.metadataTableAppProfileId = metadataTableAppProfileId;
    this.startTime = startTime;
  }

  @ProcessElement
  public void processElement(OutputReceiver<com.google.cloud.Timestamp> receiver)
      throws IOException {
    LOG.info(daoFactory.getStreamTableDebugString());
    LOG.info(daoFactory.getMetadataTableDebugString());
    LOG.info("ChangeStreamName: " + daoFactory.getChangeStreamName());

    receiver.output(startTime);
  }
}
