/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner.changestreams.dao;

import com.google.cloud.Timestamp;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.TransactionContext;
import com.google.cloud.spanner.TransactionRunner;
import com.google.cloud.spanner.Value;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.PartitionMetadata;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class PartitionMetadataDao {
    private final @UnknownKeyFor @NonNull @Initialized String metadataTableName;
    private final @UnknownKeyFor @NonNull @Initialized DatabaseClient databaseClient;
    private final @UnknownKeyFor @NonNull @Initialized Dialect dialect;

    PartitionMetadataDao(@UnknownKeyFor @NonNull @Initialized String metadataTableName, @UnknownKeyFor @NonNull @Initialized DatabaseClient databaseClient, @UnknownKeyFor @NonNull @Initialized Dialect dialect) {
        this.metadataTableName = metadataTableName;
        this.databaseClient = databaseClient;
        this.dialect = dialect;
    }

    public @UnknownKeyFor @NonNull @Initialized boolean tableExists() {
        String checkTableExistsStmt = "SELECT t.table_name FROM information_schema.tables AS t WHERE t.table_catalog = '' AND t.table_schema = '' AND t.table_name = '" + this.metadataTableName + "'";
        try (ResultSet queryResultSet = this.databaseClient.singleUseReadOnlyTransaction().executeQuery(Statement.of((String)checkTableExistsStmt), new Options.QueryOption[0]);){
            boolean bl = queryResultSet.next();
            return bl;
        }
    }

    @Nullable
    public @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Struct getPartition(@UnknownKeyFor @NonNull @Initialized String partitionToken) {
        Statement statement = this.isPostgres() ? ((Statement.Builder)Statement.newBuilder((String)("SELECT * FROM \"" + this.metadataTableName + "\" WHERE \"" + "PartitionToken" + "\" = $1")).bind("p1").to(partitionToken)).build() : ((Statement.Builder)Statement.newBuilder((String)("SELECT * FROM " + this.metadataTableName + " WHERE " + "PartitionToken" + " = @partition")).bind("partition").to(partitionToken)).build();
        try (ResultSet resultSet = this.databaseClient.singleUse().executeQuery(statement, new Options.QueryOption[0]);){
            if (resultSet.next()) {
                Struct struct = resultSet.getCurrentRowAsStruct();
                return struct;
            }
            Struct struct = null;
            return struct;
        }
    }

    @Nullable
    public @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Timestamp getUnfinishedMinWatermark() {
        Statement statement = this.isPostgres() ? ((Statement.Builder)Statement.newBuilder((String)("SELECT \"Watermark\" FROM \"" + this.metadataTableName + "\" WHERE \"" + "State" + "\" != $1 ORDER BY \"" + "Watermark" + "\" ASC LIMIT 1")).bind("p1").to(PartitionMetadata.State.FINISHED.name())).build() : ((Statement.Builder)Statement.newBuilder((String)("SELECT Watermark FROM " + this.metadataTableName + " WHERE " + "State" + " != @state ORDER BY " + "Watermark" + " ASC LIMIT 1")).bind("state").to(PartitionMetadata.State.FINISHED.name())).build();
        try (ResultSet resultSet = this.databaseClient.singleUse().executeQuery(statement, new Options.QueryOption[0]);){
            if (resultSet.next()) {
                Timestamp timestamp = resultSet.getTimestamp("Watermark");
                return timestamp;
            }
            Timestamp timestamp = null;
            return timestamp;
        }
    }

    public @UnknownKeyFor @NonNull @Initialized ResultSet getAllPartitionsCreatedAfter(@UnknownKeyFor @NonNull @Initialized Timestamp timestamp) {
        Statement statement = this.isPostgres() ? ((Statement.Builder)Statement.newBuilder((String)("SELECT * FROM \"" + this.metadataTableName + "\" WHERE \"" + "CreatedAt" + "\" > $1 ORDER BY \"" + "CreatedAt" + "\" ASC, \"" + "StartTimestamp" + "\" ASC")).bind("p1").to(timestamp)).build() : ((Statement.Builder)Statement.newBuilder((String)("SELECT * FROM " + this.metadataTableName + " WHERE " + "CreatedAt" + " > @timestamp ORDER BY " + "CreatedAt" + " ASC, " + "StartTimestamp" + " ASC")).bind("timestamp").to(timestamp)).build();
        return this.databaseClient.singleUse().executeQuery(statement, new Options.QueryOption[0]);
    }

    public @UnknownKeyFor @NonNull @Initialized long countPartitionsCreatedAfter(@UnknownKeyFor @NonNull @Initialized Timestamp timestamp) {
        Statement statement = this.isPostgres() ? ((Statement.Builder)Statement.newBuilder((String)("SELECT COUNT(*) as count FROM \"" + this.metadataTableName + "\" WHERE \"" + "CreatedAt" + "\" > $1")).bind("p1").to(timestamp)).build() : ((Statement.Builder)Statement.newBuilder((String)("SELECT COUNT(*) as count FROM " + this.metadataTableName + " WHERE " + "CreatedAt" + " > @timestamp")).bind("timestamp").to(timestamp)).build();
        try (ResultSet resultSet = this.databaseClient.singleUse().executeQuery(statement, new Options.QueryOption[0]);){
            if (resultSet.next()) {
                long l = resultSet.getLong("count");
                return l;
            }
            long l = 0L;
            return l;
        }
    }

    private @UnknownKeyFor @NonNull @Initialized boolean isPostgres() {
        return this.dialect == Dialect.POSTGRESQL;
    }

    public @UnknownKeyFor @NonNull @Initialized Timestamp insert(@UnknownKeyFor @NonNull @Initialized PartitionMetadata row) {
        TransactionResult<Void> transactionResult = this.runInTransaction(transaction -> transaction.insert(row));
        return transactionResult.getCommitTimestamp();
    }

    public @UnknownKeyFor @NonNull @Initialized Timestamp updateToScheduled(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> partitionTokens) {
        TransactionResult<Void> transactionResult = this.runInTransaction(transaction -> transaction.updateToScheduled(partitionTokens));
        return transactionResult.getCommitTimestamp();
    }

    public @UnknownKeyFor @NonNull @Initialized Timestamp updateToRunning(@UnknownKeyFor @NonNull @Initialized String partitionToken) {
        TransactionResult<Void> transactionResult = this.runInTransaction(transaction -> transaction.updateToRunning(partitionToken));
        return transactionResult.getCommitTimestamp();
    }

    public @UnknownKeyFor @NonNull @Initialized Timestamp updateToFinished(@UnknownKeyFor @NonNull @Initialized String partitionToken) {
        TransactionResult<Void> transactionResult = this.runInTransaction(transaction -> transaction.updateToFinished(partitionToken));
        return transactionResult.getCommitTimestamp();
    }

    public void updateWatermark(@UnknownKeyFor @NonNull @Initialized String partitionToken, @UnknownKeyFor @NonNull @Initialized Timestamp watermark) {
        this.runInTransaction(transaction -> transaction.updateWatermark(partitionToken, watermark));
    }

    public <T> @UnknownKeyFor @NonNull @Initialized TransactionResult<T> runInTransaction(@UnknownKeyFor @NonNull @Initialized Function<@UnknownKeyFor @NonNull @Initialized InTransactionContext, T> callable) {
        TransactionRunner readWriteTransaction = this.databaseClient.readWriteTransaction(new Options.TransactionOption[0]);
        Object result = readWriteTransaction.run(transaction -> {
            InTransactionContext transactionContext = new InTransactionContext(this.metadataTableName, transaction, this.dialect);
            return callable.apply(transactionContext);
        });
        return new TransactionResult<Object>(result, readWriteTransaction.getCommitTimestamp());
    }

    public static class TransactionResult<@UnknownKeyFor T> {
        @Nullable
        private final @org.checkerframework.checker.nullness.qual.Nullable T result;
        private final @UnknownKeyFor @NonNull @Initialized Timestamp commitTimestamp;

        public TransactionResult(@Nullable @org.checkerframework.checker.nullness.qual.Nullable T result, @UnknownKeyFor @NonNull @Initialized Timestamp commitTimestamp) {
            this.result = result;
            this.commitTimestamp = commitTimestamp;
        }

        @Nullable
        public @org.checkerframework.checker.nullness.qual.Nullable T getResult() {
            return this.result;
        }

        public @UnknownKeyFor @NonNull @Initialized Timestamp getCommitTimestamp() {
            return this.commitTimestamp;
        }

        @SideEffectFree
        public @UnknownKeyFor @NonNull @Initialized String toString() {
            return "CommitResponse{result=" + this.result + ", commitTimestamp=" + this.commitTimestamp + '}';
        }
    }

    public static class InTransactionContext {
        private final @UnknownKeyFor @NonNull @Initialized String metadataTableName;
        private final @UnknownKeyFor @NonNull @Initialized TransactionContext transaction;
        private final @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized PartitionMetadata.State, @UnknownKeyFor @NonNull @Initialized String> stateToTimestampColumn;
        private final @UnknownKeyFor @NonNull @Initialized Dialect dialect;

        public InTransactionContext(@UnknownKeyFor @NonNull @Initialized String metadataTableName, @UnknownKeyFor @NonNull @Initialized TransactionContext transaction, @UnknownKeyFor @NonNull @Initialized Dialect dialect) {
            this.metadataTableName = metadataTableName;
            this.transaction = transaction;
            this.stateToTimestampColumn = new HashMap<PartitionMetadata.State, String>();
            this.dialect = dialect;
            this.stateToTimestampColumn.put(PartitionMetadata.State.CREATED, "CreatedAt");
            this.stateToTimestampColumn.put(PartitionMetadata.State.SCHEDULED, "ScheduledAt");
            this.stateToTimestampColumn.put(PartitionMetadata.State.RUNNING, "RunningAt");
            this.stateToTimestampColumn.put(PartitionMetadata.State.FINISHED, "FinishedAt");
        }

        public @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Void insert(@UnknownKeyFor @NonNull @Initialized PartitionMetadata row) {
            this.transaction.buffer((Iterable)ImmutableList.of((Object)this.createInsertMetadataMutationFrom(row)));
            return null;
        }

        public @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Void updateToScheduled(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> partitionTokens) {
            List mutations = partitionTokens.stream().map(token -> this.createUpdateMetadataStateMutationFrom((String)token, PartitionMetadata.State.SCHEDULED)).collect(Collectors.toList());
            this.transaction.buffer(mutations);
            return null;
        }

        public @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Void updateToRunning(@UnknownKeyFor @NonNull @Initialized String partitionToken) {
            this.transaction.buffer((Iterable)ImmutableList.of((Object)this.createUpdateMetadataStateMutationFrom(partitionToken, PartitionMetadata.State.RUNNING)));
            return null;
        }

        public @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Void updateToFinished(@UnknownKeyFor @NonNull @Initialized String partitionToken) {
            this.transaction.buffer((Iterable)ImmutableList.of((Object)this.createUpdateMetadataStateMutationFrom(partitionToken, PartitionMetadata.State.FINISHED)));
            return null;
        }

        public @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Void updateWatermark(@UnknownKeyFor @NonNull @Initialized String partitionToken, @UnknownKeyFor @NonNull @Initialized Timestamp watermark) {
            this.transaction.buffer(this.createUpdateMetadataWatermarkMutationFrom(partitionToken, watermark));
            return null;
        }

        @Nullable
        public @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized Struct getPartition(@UnknownKeyFor @NonNull @Initialized String partitionToken) {
            Statement statement = this.dialect == Dialect.POSTGRESQL ? ((Statement.Builder)Statement.newBuilder((String)("SELECT * FROM \"" + this.metadataTableName + "\" WHERE \"" + "PartitionToken" + "\" = $1")).bind("p1").to(partitionToken)).build() : ((Statement.Builder)Statement.newBuilder((String)("SELECT * FROM " + this.metadataTableName + " WHERE " + "PartitionToken" + " = @partition")).bind("partition").to(partitionToken)).build();
            try (ResultSet resultSet = this.transaction.executeQuery(statement, new Options.QueryOption[0]);){
                if (resultSet.next()) {
                    Struct struct = resultSet.getCurrentRowAsStruct();
                    return struct;
                }
                Struct struct = null;
                return struct;
            }
        }

        private @UnknownKeyFor @NonNull @Initialized Mutation createInsertMetadataMutationFrom(@UnknownKeyFor @NonNull @Initialized PartitionMetadata partitionMetadata) {
            return ((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)this.metadataTableName).set("PartitionToken").to(partitionMetadata.getPartitionToken())).set("ParentTokens").toStringArray(partitionMetadata.getParentTokens())).set("StartTimestamp").to(partitionMetadata.getStartTimestamp())).set("EndTimestamp").to(partitionMetadata.getEndTimestamp())).set("HeartbeatMillis").to(partitionMetadata.getHeartbeatMillis())).set("State").to(partitionMetadata.getState().toString())).set("Watermark").to(partitionMetadata.getWatermark())).set("CreatedAt").to(Value.COMMIT_TIMESTAMP)).build();
        }

        private @UnknownKeyFor @NonNull @Initialized Mutation createUpdateMetadataStateMutationFrom(@UnknownKeyFor @NonNull @Initialized String partitionToken, @UnknownKeyFor @NonNull @Initialized PartitionMetadata.State state) {
            String timestampColumn = this.stateToTimestampColumn.get((Object)state);
            if (timestampColumn == null) {
                throw new IllegalArgumentException("No timestamp column name found for state " + (Object)((Object)state));
            }
            return ((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newUpdateBuilder((String)this.metadataTableName).set("PartitionToken").to(partitionToken)).set("State").to(state.toString())).set(timestampColumn).to(Value.COMMIT_TIMESTAMP)).build();
        }

        private @UnknownKeyFor @NonNull @Initialized Mutation createUpdateMetadataWatermarkMutationFrom(@UnknownKeyFor @NonNull @Initialized String partitionToken, @UnknownKeyFor @NonNull @Initialized Timestamp watermark) {
            return ((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newUpdateBuilder((String)this.metadataTableName).set("PartitionToken").to(partitionToken)).set("Watermark").to(watermark)).build();
        }
    }
}

