/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryOptions;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryStorageApiInsertError;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryStorageApiInsertErrorCoder;
import org.apache.beam.sdk.io.gcp.bigquery.CreateTableDestinations;
import org.apache.beam.sdk.io.gcp.bigquery.StorageApiConvertMessages;
import org.apache.beam.sdk.io.gcp.bigquery.StorageApiDynamicDestinations;
import org.apache.beam.sdk.io.gcp.bigquery.StorageApiWritePayload;
import org.apache.beam.sdk.io.gcp.bigquery.StorageApiWriteRecordsInconsistent;
import org.apache.beam.sdk.io.gcp.bigquery.StorageApiWriteUnshardedRecords;
import org.apache.beam.sdk.io.gcp.bigquery.StorageApiWritesShardedRecords;
import org.apache.beam.sdk.io.gcp.bigquery.WriteResult;
import org.apache.beam.sdk.schemas.NoSuchSchemaException;
import org.apache.beam.sdk.schemas.SchemaCoder;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.Flatten;
import org.apache.beam.sdk.transforms.GroupIntoBatches;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.windowing.GlobalWindows;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.util.ShardedKey;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.TupleTag;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Duration;

public class StorageApiLoads<@UnknownKeyFor DestinationT, @UnknownKeyFor ElementT>
extends PTransform<PCollection<KV<DestinationT, ElementT>>, WriteResult> {
    final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized KV<DestinationT, @UnknownKeyFor @NonNull @Initialized StorageApiWritePayload>> successfulRowsTag = new TupleTag("successfulRows");
    final @UnknownKeyFor @NonNull @Initialized TupleTag<@UnknownKeyFor @NonNull @Initialized BigQueryStorageApiInsertError> failedRowsTag = new TupleTag("failedRows");
    private final @UnknownKeyFor @NonNull @Initialized Coder<DestinationT> destinationCoder;
    private final @UnknownKeyFor @NonNull @Initialized StorageApiDynamicDestinations<ElementT, DestinationT> dynamicDestinations;
    private final  @UnknownKeyFor @NonNull @Initialized BigQueryIO.Write.CreateDisposition createDisposition;
    private final @UnknownKeyFor @NonNull @Initialized String kmsKey;
    private final @UnknownKeyFor @NonNull @Initialized Duration triggeringFrequency;
    private final @UnknownKeyFor @NonNull @Initialized BigQueryServices bqServices;
    private final @UnknownKeyFor @NonNull @Initialized int numShards;
    private final @UnknownKeyFor @NonNull @Initialized boolean allowInconsistentWrites;
    private final @UnknownKeyFor @NonNull @Initialized boolean allowAutosharding;

    public StorageApiLoads(@UnknownKeyFor @NonNull @Initialized Coder<DestinationT> destinationCoder, @UnknownKeyFor @NonNull @Initialized StorageApiDynamicDestinations<ElementT, DestinationT> dynamicDestinations,  @UnknownKeyFor @NonNull @Initialized BigQueryIO.Write.CreateDisposition createDisposition, @UnknownKeyFor @NonNull @Initialized String kmsKey, @UnknownKeyFor @NonNull @Initialized Duration triggeringFrequency, @UnknownKeyFor @NonNull @Initialized BigQueryServices bqServices, @UnknownKeyFor @NonNull @Initialized int numShards, @UnknownKeyFor @NonNull @Initialized boolean allowInconsistentWrites, @UnknownKeyFor @NonNull @Initialized boolean allowAutosharding) {
        this.destinationCoder = destinationCoder;
        this.dynamicDestinations = dynamicDestinations;
        this.createDisposition = createDisposition;
        this.kmsKey = kmsKey;
        this.triggeringFrequency = triggeringFrequency;
        this.bqServices = bqServices;
        this.numShards = numShards;
        this.allowInconsistentWrites = allowInconsistentWrites;
        this.allowAutosharding = allowAutosharding;
    }

    public @UnknownKeyFor @NonNull @Initialized WriteResult expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<DestinationT, ElementT>> input) {
        SchemaCoder payloadCoder;
        try {
            payloadCoder = input.getPipeline().getSchemaRegistry().getSchemaCoder(StorageApiWritePayload.class);
        }
        catch (NoSuchSchemaException e) {
            throw new RuntimeException(e);
        }
        KvCoder successCoder = KvCoder.of(this.destinationCoder, (Coder)payloadCoder);
        if (this.allowInconsistentWrites) {
            return this.expandInconsistent(input, (Coder<KV<DestinationT, StorageApiWritePayload>>)successCoder);
        }
        return this.triggeringFrequency != null ? this.expandTriggered(input, (Coder<KV<DestinationT, StorageApiWritePayload>>)successCoder, (Coder<StorageApiWritePayload>)payloadCoder) : this.expandUntriggered(input, (Coder<KV<DestinationT, StorageApiWritePayload>>)successCoder);
    }

    public @UnknownKeyFor @NonNull @Initialized WriteResult expandInconsistent(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<DestinationT, ElementT>> input, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized KV<DestinationT, @UnknownKeyFor @NonNull @Initialized StorageApiWritePayload>> successCoder) {
        PCollection inputInGlobalWindow = (PCollection)input.apply("rewindowIntoGlobal", (PTransform)Window.into((WindowFn)new GlobalWindows()));
        PCollectionTuple convertMessagesResult = (PCollectionTuple)((PCollection)inputInGlobalWindow.apply("CreateTables", new CreateTableDestinations(this.createDisposition, this.bqServices, this.dynamicDestinations, this.kmsKey))).apply("Convert", new StorageApiConvertMessages<DestinationT, ElementT>(this.dynamicDestinations, this.bqServices, this.failedRowsTag, this.successfulRowsTag, BigQueryStorageApiInsertErrorCoder.of(), successCoder));
        PCollectionTuple writeRecordsResult = (PCollectionTuple)convertMessagesResult.get(this.successfulRowsTag).apply("StorageApiWriteInconsistent", new StorageApiWriteRecordsInconsistent<DestinationT, ElementT>(this.dynamicDestinations, this.bqServices, this.failedRowsTag, BigQueryStorageApiInsertErrorCoder.of()));
        PCollection insertErrors = (PCollection)PCollectionList.of((PCollection)convertMessagesResult.get(this.failedRowsTag)).and(writeRecordsResult.get(this.failedRowsTag)).apply("flattenErrors", (PTransform)Flatten.pCollections());
        return WriteResult.in(input.getPipeline(), null, null, null, null, null, this.failedRowsTag, (PCollection<BigQueryStorageApiInsertError>)insertErrors);
    }

    public @UnknownKeyFor @NonNull @Initialized WriteResult expandTriggered(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<DestinationT, ElementT>> input, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized KV<DestinationT, @UnknownKeyFor @NonNull @Initialized StorageApiWritePayload>> successCoder, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized StorageApiWritePayload> payloadCoder) {
        PCollection groupedRecords;
        PCollection inputInGlobalWindow = (PCollection)input.apply("rewindowIntoGlobal", (PTransform)Window.into((WindowFn)new GlobalWindows()));
        PCollectionTuple convertMessagesResult = (PCollectionTuple)((PCollection)inputInGlobalWindow.apply("CreateTables", new CreateTableDestinations(this.createDisposition, this.bqServices, this.dynamicDestinations, this.kmsKey))).apply("Convert", new StorageApiConvertMessages<DestinationT, ElementT>(this.dynamicDestinations, this.bqServices, this.failedRowsTag, this.successfulRowsTag, BigQueryStorageApiInsertErrorCoder.of(), successCoder));
        int maxAppendBytes = ((BigQueryOptions)input.getPipeline().getOptions().as(BigQueryOptions.class)).getStorageApiAppendThresholdBytes();
        if (this.allowAutosharding) {
            groupedRecords = (PCollection)convertMessagesResult.get(this.successfulRowsTag).apply("GroupIntoBatches", (PTransform)GroupIntoBatches.ofByteSize((long)maxAppendBytes, (SerializableFunction & Serializable)e -> e.getPayload().length).withMaxBufferingDuration(this.triggeringFrequency).withShardedKey());
        } else {
            PCollection shardedRecords = this.createShardedKeyValuePairs(convertMessagesResult).setCoder((Coder)KvCoder.of((Coder)ShardedKey.Coder.of(this.destinationCoder), payloadCoder));
            groupedRecords = (PCollection)shardedRecords.apply("GroupIntoBatches", (PTransform)GroupIntoBatches.ofByteSize((long)maxAppendBytes, (SerializableFunction & Serializable)e -> e.getPayload().length).withMaxBufferingDuration(this.triggeringFrequency));
        }
        PCollectionTuple writeRecordsResult = (PCollectionTuple)groupedRecords.apply("StorageApiWriteSharded", new StorageApiWritesShardedRecords<DestinationT, ElementT>(this.dynamicDestinations, this.createDisposition, this.kmsKey, this.bqServices, this.destinationCoder, BigQueryStorageApiInsertErrorCoder.of(), this.failedRowsTag));
        PCollection insertErrors = (PCollection)PCollectionList.of((PCollection)convertMessagesResult.get(this.failedRowsTag)).and(writeRecordsResult.get(this.failedRowsTag)).apply("flattenErrors", (PTransform)Flatten.pCollections());
        return WriteResult.in(input.getPipeline(), null, null, null, null, null, this.failedRowsTag, (PCollection<BigQueryStorageApiInsertError>)insertErrors);
    }

    private @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized ShardedKey<DestinationT>, @UnknownKeyFor @NonNull @Initialized StorageApiWritePayload>> createShardedKeyValuePairs(@UnknownKeyFor @NonNull @Initialized PCollectionTuple pCollection) {
        return (PCollection)pCollection.get(this.successfulRowsTag).apply("AddShard", (PTransform)ParDo.of((DoFn)new DoFn<KV<DestinationT, StorageApiWritePayload>, KV<ShardedKey<DestinationT>, StorageApiWritePayload>>(){
            @UnknownKeyFor @NonNull @Initialized int shardNumber;

            @DoFn.Setup
            public void setup() {
                this.shardNumber = ThreadLocalRandom.current().nextInt(StorageApiLoads.this.numShards);
            }

            @DoFn.ProcessElement
            public void processElement(@DoFn.Element @UnknownKeyFor @NonNull @Initialized KV<DestinationT, @UnknownKeyFor @NonNull @Initialized StorageApiWritePayload> element, // Could not load outer class - annotation placement on inner may be incorrect
            @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized ShardedKey<DestinationT>, @UnknownKeyFor @NonNull @Initialized StorageApiWritePayload>> o) {
                Object destination = element.getKey();
                ByteBuffer buffer = ByteBuffer.allocate(4);
                buffer.putInt(++this.shardNumber % StorageApiLoads.this.numShards);
                o.output((Object)KV.of((Object)ShardedKey.of((Object)destination, (byte[])buffer.array()), (Object)((StorageApiWritePayload)element.getValue())));
            }
        }));
    }

    public @UnknownKeyFor @NonNull @Initialized WriteResult expandUntriggered(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KV<DestinationT, ElementT>> input, @UnknownKeyFor @NonNull @Initialized Coder<@UnknownKeyFor @NonNull @Initialized KV<DestinationT, @UnknownKeyFor @NonNull @Initialized StorageApiWritePayload>> successCoder) {
        PCollection inputInGlobalWindow = (PCollection)input.apply("rewindowIntoGlobal", (PTransform)Window.into((WindowFn)new GlobalWindows()));
        PCollectionTuple convertMessagesResult = (PCollectionTuple)((PCollection)inputInGlobalWindow.apply("CreateTables", new CreateTableDestinations(this.createDisposition, this.bqServices, this.dynamicDestinations, this.kmsKey))).apply("Convert", new StorageApiConvertMessages<DestinationT, ElementT>(this.dynamicDestinations, this.bqServices, this.failedRowsTag, this.successfulRowsTag, BigQueryStorageApiInsertErrorCoder.of(), successCoder));
        PCollectionTuple writeRecordsResult = (PCollectionTuple)convertMessagesResult.get(this.successfulRowsTag).apply("StorageApiWriteUnsharded", new StorageApiWriteUnshardedRecords<DestinationT, ElementT>(this.dynamicDestinations, this.bqServices, this.failedRowsTag, BigQueryStorageApiInsertErrorCoder.of()));
        PCollection insertErrors = (PCollection)PCollectionList.of((PCollection)convertMessagesResult.get(this.failedRowsTag)).and(writeRecordsResult.get(this.failedRowsTag)).apply("flattenErrors", (PTransform)Flatten.pCollections());
        return WriteResult.in(input.getPipeline(), null, null, null, null, null, this.failedRowsTag, (PCollection<BigQueryStorageApiInsertError>)insertErrors);
    }
}

