/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner.changestreams.dao;

import com.google.cloud.Timestamp;
import com.google.cloud.spanner.DatabaseClient;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.TransactionContext;
import com.google.cloud.spanner.TransactionRunner;
import com.google.cloud.spanner.Value;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.PartitionMetadata;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;

public class PartitionMetadataDao {
    private final String metadataTableName;
    private final DatabaseClient databaseClient;

    PartitionMetadataDao(String metadataTableName, DatabaseClient databaseClient) {
        this.metadataTableName = metadataTableName;
        this.databaseClient = databaseClient;
    }

    public boolean tableExists() {
        String checkTableExistsStmt = "SELECT t.table_name FROM information_schema.tables AS t WHERE t.table_catalog = '' AND t.table_schema = '' AND t.table_name = '" + this.metadataTableName + "'";
        try (ResultSet queryResultSet = this.databaseClient.singleUseReadOnlyTransaction().executeQuery(Statement.of((String)checkTableExistsStmt), new Options.QueryOption[0]);){
            boolean bl = queryResultSet.next();
            return bl;
        }
    }

    @Nullable
    public Struct getPartition(String partitionToken) {
        try (ResultSet resultSet = this.databaseClient.singleUse().executeQuery(((Statement.Builder)Statement.newBuilder((String)("SELECT * FROM " + this.metadataTableName + " WHERE " + "PartitionToken" + " = @partition")).bind("partition").to(partitionToken)).build(), new Options.QueryOption[0]);){
            if (resultSet.next()) {
                Struct struct = resultSet.getCurrentRowAsStruct();
                return struct;
            }
            Struct struct = null;
            return struct;
        }
    }

    @Nullable
    public Timestamp getUnfinishedMinWatermark() {
        Statement statement = ((Statement.Builder)Statement.newBuilder((String)("SELECT Watermark FROM " + this.metadataTableName + " WHERE " + "State" + " != @state ORDER BY " + "Watermark" + " ASC LIMIT 1")).bind("state").to(PartitionMetadata.State.FINISHED.name())).build();
        try (ResultSet resultSet = this.databaseClient.singleUse().executeQuery(statement, new Options.QueryOption[0]);){
            if (resultSet.next()) {
                Timestamp timestamp = resultSet.getTimestamp("Watermark");
                return timestamp;
            }
            Timestamp timestamp = null;
            return timestamp;
        }
    }

    public ResultSet getAllPartitionsCreatedAfter(Timestamp timestamp) {
        Statement statement = ((Statement.Builder)Statement.newBuilder((String)("SELECT * FROM " + this.metadataTableName + " WHERE " + "CreatedAt" + " > @timestamp ORDER BY " + "CreatedAt" + " ASC, " + "StartTimestamp" + " ASC")).bind("timestamp").to(timestamp)).build();
        return this.databaseClient.singleUse().executeQuery(statement, new Options.QueryOption[0]);
    }

    public Timestamp insert(PartitionMetadata row) {
        TransactionResult<Void> transactionResult = this.runInTransaction(transaction -> transaction.insert(row));
        return transactionResult.getCommitTimestamp();
    }

    public Timestamp updateToScheduled(List<String> partitionTokens) {
        TransactionResult<Void> transactionResult = this.runInTransaction(transaction -> transaction.updateToScheduled(partitionTokens));
        return transactionResult.getCommitTimestamp();
    }

    public Timestamp updateToRunning(String partitionToken) {
        TransactionResult<Void> transactionResult = this.runInTransaction(transaction -> transaction.updateToRunning(partitionToken));
        return transactionResult.getCommitTimestamp();
    }

    public Timestamp updateToFinished(String partitionToken) {
        TransactionResult<Void> transactionResult = this.runInTransaction(transaction -> transaction.updateToFinished(partitionToken));
        return transactionResult.getCommitTimestamp();
    }

    public void updateWatermark(String partitionToken, Timestamp watermark) {
        this.runInTransaction(transaction -> transaction.updateWatermark(partitionToken, watermark));
    }

    public <T> TransactionResult<T> runInTransaction(Function<InTransactionContext, T> callable) {
        TransactionRunner readWriteTransaction = this.databaseClient.readWriteTransaction(new Options.TransactionOption[0]);
        Object result = readWriteTransaction.run(transaction -> {
            InTransactionContext transactionContext = new InTransactionContext(this.metadataTableName, transaction);
            return callable.apply(transactionContext);
        });
        return new TransactionResult<Object>(result, readWriteTransaction.getCommitTimestamp());
    }

    public static class TransactionResult<T> {
        @Nullable
        private final T result;
        private final Timestamp commitTimestamp;

        public TransactionResult(@Nullable T result, Timestamp commitTimestamp) {
            this.result = result;
            this.commitTimestamp = commitTimestamp;
        }

        @Nullable
        public T getResult() {
            return this.result;
        }

        public Timestamp getCommitTimestamp() {
            return this.commitTimestamp;
        }

        public String toString() {
            return "CommitResponse{result=" + this.result + ", commitTimestamp=" + this.commitTimestamp + '}';
        }
    }

    public static class InTransactionContext {
        private final String metadataTableName;
        private final TransactionContext transaction;
        private final Map<PartitionMetadata.State, String> stateToTimestampColumn;

        public InTransactionContext(String metadataTableName, TransactionContext transaction) {
            this.metadataTableName = metadataTableName;
            this.transaction = transaction;
            this.stateToTimestampColumn = new HashMap<PartitionMetadata.State, String>();
            this.stateToTimestampColumn.put(PartitionMetadata.State.CREATED, "CreatedAt");
            this.stateToTimestampColumn.put(PartitionMetadata.State.SCHEDULED, "ScheduledAt");
            this.stateToTimestampColumn.put(PartitionMetadata.State.RUNNING, "RunningAt");
            this.stateToTimestampColumn.put(PartitionMetadata.State.FINISHED, "FinishedAt");
        }

        public Void insert(PartitionMetadata row) {
            this.transaction.buffer((Iterable)ImmutableList.of((Object)this.createInsertMetadataMutationFrom(row)));
            return null;
        }

        public Void updateToScheduled(List<String> partitionTokens) {
            List mutations = partitionTokens.stream().map(token -> this.createUpdateMetadataStateMutationFrom((String)token, PartitionMetadata.State.SCHEDULED)).collect(Collectors.toList());
            this.transaction.buffer(mutations);
            return null;
        }

        public Void updateToRunning(String partitionToken) {
            this.transaction.buffer((Iterable)ImmutableList.of((Object)this.createUpdateMetadataStateMutationFrom(partitionToken, PartitionMetadata.State.RUNNING)));
            return null;
        }

        public Void updateToFinished(String partitionToken) {
            this.transaction.buffer((Iterable)ImmutableList.of((Object)this.createUpdateMetadataStateMutationFrom(partitionToken, PartitionMetadata.State.FINISHED)));
            return null;
        }

        public Void updateWatermark(String partitionToken, Timestamp watermark) {
            this.transaction.buffer(this.createUpdateMetadataWatermarkMutationFrom(partitionToken, watermark));
            return null;
        }

        @Nullable
        public Struct getPartition(String partitionToken) {
            try (ResultSet resultSet = this.transaction.executeQuery(((Statement.Builder)Statement.newBuilder((String)("SELECT * FROM " + this.metadataTableName + " WHERE " + "PartitionToken" + " = @partition")).bind("partition").to(partitionToken)).build(), new Options.QueryOption[0]);){
                if (resultSet.next()) {
                    Struct struct = resultSet.getCurrentRowAsStruct();
                    return struct;
                }
                Struct struct = null;
                return struct;
            }
        }

        private Mutation createInsertMetadataMutationFrom(PartitionMetadata partitionMetadata) {
            return ((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newInsertBuilder((String)this.metadataTableName).set("PartitionToken").to(partitionMetadata.getPartitionToken())).set("ParentTokens").toStringArray(partitionMetadata.getParentTokens())).set("StartTimestamp").to(partitionMetadata.getStartTimestamp())).set("EndTimestamp").to(partitionMetadata.getEndTimestamp())).set("HeartbeatMillis").to(partitionMetadata.getHeartbeatMillis())).set("State").to(partitionMetadata.getState().toString())).set("Watermark").to(partitionMetadata.getWatermark())).set("CreatedAt").to(Value.COMMIT_TIMESTAMP)).build();
        }

        private Mutation createUpdateMetadataStateMutationFrom(String partitionToken, PartitionMetadata.State state) {
            String timestampColumn = this.stateToTimestampColumn.get((Object)state);
            if (timestampColumn == null) {
                throw new IllegalArgumentException("No timestamp column name found for state " + (Object)((Object)state));
            }
            return ((Mutation.WriteBuilder)((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newUpdateBuilder((String)this.metadataTableName).set("PartitionToken").to(partitionToken)).set("State").to(state.toString())).set(timestampColumn).to(Value.COMMIT_TIMESTAMP)).build();
        }

        private Mutation createUpdateMetadataWatermarkMutationFrom(String partitionToken, Timestamp watermark) {
            return ((Mutation.WriteBuilder)((Mutation.WriteBuilder)Mutation.newUpdateBuilder((String)this.metadataTableName).set("PartitionToken").to(partitionToken)).set("Watermark").to(watermark)).build();
        }
    }
}

