/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.TableRow;
import com.google.auto.service.AutoService;
import java.io.Serializable;
import java.util.HashMap;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryIO;
import org.apache.beam.sdk.io.gcp.testing.FakeBigQueryServices;
import org.apache.beam.sdk.io.gcp.testing.FakeDatasetService;
import org.apache.beam.sdk.io.gcp.testing.FakeJobService;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.io.SchemaIO;
import org.apache.beam.sdk.schemas.io.SchemaIOProvider;
import org.apache.beam.sdk.schemas.transforms.Convert;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.sdk.values.Row;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.Duration;

@Internal
@Experimental
@AutoService(value={SchemaIOProvider.class})
public class BigQuerySchemaIOProvider
implements SchemaIOProvider {
    private static final HashMap<String, BigQueryIO.Write.CreateDisposition> createDispositionsMap = new HashMap();

    public String identifier() {
        return "bigquery";
    }

    public Schema configurationSchema() {
        return Schema.builder().addNullableField("table", Schema.FieldType.STRING).addNullableField("query", Schema.FieldType.STRING).addNullableField("queryLocation", Schema.FieldType.STRING).addNullableField("createDisposition", Schema.FieldType.STRING).addNullableField("useTestingBigQueryServices", Schema.FieldType.BOOLEAN).build();
    }

    public BigQuerySchemaIO from(String location, Row configuration, @Nullable Schema dataSchema) {
        return new BigQuerySchemaIO(location, configuration);
    }

    public boolean requiresDataSchema() {
        return false;
    }

    public PCollection.IsBounded isBounded() {
        return PCollection.IsBounded.BOUNDED;
    }

    static {
        createDispositionsMap.put("Never", BigQueryIO.Write.CreateDisposition.CREATE_NEVER);
        createDispositionsMap.put("IfNeeded", BigQueryIO.Write.CreateDisposition.CREATE_IF_NEEDED);
    }

    static class BigQuerySchemaIO
    implements SchemaIO,
    Serializable {
        protected final Row config;
        protected final String location;

        BigQuerySchemaIO(String location, Row config) {
            this.config = config;
            this.location = location;
        }

        public Schema schema() {
            return null;
        }

        public PTransform<PBegin, PCollection<Row>> buildReader() {
            return new PTransform<PBegin, PCollection<Row>>(){

                public PCollection<Row> expand(PBegin input) {
                    String queryLocation;
                    String query;
                    BigQueryIO.TypedRead<TableRow> read = BigQueryIO.readTableRowsWithSchema();
                    read = read.withMethod(BigQueryIO.TypedRead.Method.EXPORT);
                    String table = config.getString("table");
                    if (table != null) {
                        read = read.from(table);
                    }
                    if ((query = config.getString("query")) != null) {
                        read = read.fromQuery(query).usingStandardSql();
                    }
                    if ((queryLocation = config.getString("queryLocation")) != null) {
                        read = read.withQueryLocation(queryLocation);
                    }
                    return (PCollection)((PCollection)input.apply(read)).apply(Convert.toRows());
                }
            };
        }

        public PTransform<PCollection<Row>, PDone> buildWriter() {
            return new PTransform<PCollection<Row>, PDone>(){

                public PDone expand(PCollection<Row> input) {
                    String createDisposition;
                    String table;
                    BigQueryIO.Write write = BigQueryIO.write().useBeamSchema().withMethod(BigQueryIO.Write.Method.STORAGE_WRITE_API).withTriggeringFrequency(Duration.standardSeconds((long)5L)).withWriteDisposition(BigQueryIO.Write.WriteDisposition.WRITE_APPEND).withAutoSharding();
                    Boolean useTestingBigQueryServices = config.getBoolean("useTestingBigQueryServices");
                    if (useTestingBigQueryServices != null && useTestingBigQueryServices.booleanValue()) {
                        FakeBigQueryServices fbqs = new FakeBigQueryServices().withDatasetService(new FakeDatasetService()).withJobService(new FakeJobService());
                        write = write.withTestServices(fbqs);
                    }
                    if ((table = config.getString("table")) != null) {
                        write = write.to(table);
                    }
                    if ((createDisposition = config.getString("createDisposition")) != null && createDispositionsMap.containsKey(createDisposition)) {
                        write = write.withCreateDisposition((BigQueryIO.Write.CreateDisposition)((Object)createDispositionsMap.get(createDisposition)));
                    }
                    input.apply(write);
                    return PDone.in((Pipeline)input.getPipeline());
                }
            };
        }
    }
}

