/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.NullableCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.io.gcp.bigquery.TableDestination;
import org.checkerframework.checker.nullness.qual.Nullable;

public class TableDestinationCoder
extends AtomicCoder<TableDestination> {
    private static final TableDestinationCoder INSTANCE = new TableDestinationCoder();
    private static final Coder<String> tableSpecCoder = StringUtf8Coder.of();
    private static final Coder<@Nullable String> tableDescriptionCoder = NullableCoder.of((Coder)StringUtf8Coder.of());

    private TableDestinationCoder() {
    }

    public static TableDestinationCoder of() {
        return INSTANCE;
    }

    public void encode(TableDestination value, OutputStream outStream) throws IOException {
        if (value == null) {
            throw new CoderException("cannot encode a null value");
        }
        tableSpecCoder.encode((Object)value.getTableSpec(), outStream);
        tableDescriptionCoder.encode((Object)value.getTableDescription(), outStream);
    }

    public TableDestination decode(InputStream inStream) throws IOException {
        String tableSpec = (String)tableSpecCoder.decode(inStream);
        String tableDescription = (String)tableDescriptionCoder.decode(inStream);
        return new TableDestination(tableSpec, tableDescription);
    }

    public void verifyDeterministic() throws Coder.NonDeterministicException {
    }
}

