/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner.changestreams.model;

import com.google.cloud.Timestamp;
import com.google.cloud.spanner.Value;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.avro.reflect.AvroEncode;
import org.apache.beam.sdk.coders.AvroCoder;
import org.apache.beam.sdk.coders.DefaultCoder;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.encoder.TimestampEncoding;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;

@DefaultCoder(value=AvroCoder.class)
public class PartitionMetadata
implements Serializable {
    private static final long serialVersionUID = 995720273301116075L;
    private String partitionToken;
    private HashSet<String> parentTokens;
    @AvroEncode(using=TimestampEncoding.class)
    private Timestamp startTimestamp;
    @Nullable
    @org.apache.avro.reflect.Nullable
    @AvroEncode(using=TimestampEncoding.class)
    private Timestamp endTimestamp;
    private long heartbeatMillis;
    private State state;
    @AvroEncode(using=TimestampEncoding.class)
    private Timestamp watermark;
    @AvroEncode(using=TimestampEncoding.class)
    private Timestamp createdAt;
    @Nullable
    @org.apache.avro.reflect.Nullable
    @AvroEncode(using=TimestampEncoding.class)
    private Timestamp scheduledAt;
    @Nullable
    @org.apache.avro.reflect.Nullable
    @AvroEncode(using=TimestampEncoding.class)
    private Timestamp runningAt;
    @Nullable
    @org.apache.avro.reflect.Nullable
    @AvroEncode(using=TimestampEncoding.class)
    private Timestamp finishedAt;

    private PartitionMetadata() {
    }

    public PartitionMetadata(String partitionToken, HashSet<String> parentTokens, Timestamp startTimestamp, @Nullable Timestamp endTimestamp, long heartbeatMillis, State state, Timestamp watermark, Timestamp createdAt, @Nullable Timestamp scheduledAt, @Nullable Timestamp runningAt, @Nullable Timestamp finishedAt) {
        this.partitionToken = partitionToken;
        this.parentTokens = parentTokens;
        this.startTimestamp = startTimestamp;
        this.endTimestamp = endTimestamp;
        this.heartbeatMillis = heartbeatMillis;
        this.state = state;
        this.watermark = watermark;
        this.createdAt = createdAt;
        this.scheduledAt = scheduledAt;
        this.runningAt = runningAt;
        this.finishedAt = finishedAt;
    }

    public String getPartitionToken() {
        return this.partitionToken;
    }

    public HashSet<String> getParentTokens() {
        return this.parentTokens;
    }

    public Timestamp getStartTimestamp() {
        return this.startTimestamp;
    }

    @Nullable
    public Timestamp getEndTimestamp() {
        return this.endTimestamp;
    }

    public long getHeartbeatMillis() {
        return this.heartbeatMillis;
    }

    public State getState() {
        return this.state;
    }

    public Timestamp getWatermark() {
        return this.watermark;
    }

    public Timestamp getCreatedAt() {
        return this.createdAt;
    }

    @Nullable
    public Timestamp getScheduledAt() {
        return this.scheduledAt;
    }

    @Nullable
    public Timestamp getRunningAt() {
        return this.runningAt;
    }

    @Nullable
    public Timestamp getFinishedAt() {
        return this.finishedAt;
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PartitionMetadata)) {
            return false;
        }
        PartitionMetadata that = (PartitionMetadata)o;
        return this.heartbeatMillis == that.heartbeatMillis && Objects.equals(this.partitionToken, that.partitionToken) && Objects.equals(this.parentTokens, that.parentTokens) && Objects.equals(this.startTimestamp, that.startTimestamp) && Objects.equals(this.endTimestamp, that.endTimestamp) && this.state == that.state && Objects.equals(this.watermark, that.watermark) && Objects.equals(this.createdAt, that.createdAt) && Objects.equals(this.scheduledAt, that.scheduledAt) && Objects.equals(this.runningAt, that.runningAt) && Objects.equals(this.finishedAt, that.finishedAt);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.partitionToken, this.parentTokens, this.startTimestamp, this.endTimestamp, this.heartbeatMillis, this.state, this.watermark, this.createdAt, this.scheduledAt, this.runningAt, this.finishedAt});
    }

    public String toString() {
        return "PartitionMetadata{partitionToken='" + this.partitionToken + '\'' + ", parentTokens=" + this.parentTokens + ", startTimestamp=" + this.startTimestamp + ", endTimestamp=" + this.endTimestamp + ", heartbeatMillis=" + this.heartbeatMillis + ", state=" + (Object)((Object)this.state) + ", watermark=" + this.watermark + ", createdAt=" + this.createdAt + ", scheduledAt=" + this.scheduledAt + ", runningAt=" + this.runningAt + ", finishedAt=" + this.finishedAt + '}';
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static class Builder {
        private String partitionToken;
        private HashSet<String> parentTokens;
        private Timestamp startTimestamp;
        @Nullable
        private Timestamp endTimestamp;
        private Long heartbeatMillis;
        private State state;
        private Timestamp watermark;
        private Timestamp createdAt;
        @Nullable
        private Timestamp scheduledAt;
        @Nullable
        private Timestamp runningAt;
        @Nullable
        private Timestamp finishedAt;

        public Builder() {
        }

        private Builder(PartitionMetadata partition) {
            this.partitionToken = partition.partitionToken;
            this.parentTokens = partition.parentTokens;
            this.startTimestamp = partition.startTimestamp;
            this.endTimestamp = partition.endTimestamp;
            this.heartbeatMillis = partition.heartbeatMillis;
            this.state = partition.state;
            this.watermark = partition.watermark;
            this.createdAt = partition.createdAt;
            this.scheduledAt = partition.scheduledAt;
            this.runningAt = partition.runningAt;
            this.finishedAt = partition.finishedAt;
        }

        public Builder setPartitionToken(String partitionToken) {
            this.partitionToken = partitionToken;
            return this;
        }

        public Builder setParentTokens(HashSet<String> parentTokens) {
            this.parentTokens = parentTokens;
            return this;
        }

        public Builder setStartTimestamp(Timestamp startTimestamp) {
            this.startTimestamp = startTimestamp;
            return this;
        }

        public Builder setEndTimestamp(@Nullable Timestamp endTimestamp) {
            this.endTimestamp = endTimestamp;
            return this;
        }

        public Builder setHeartbeatMillis(long heartbeatMillis) {
            this.heartbeatMillis = heartbeatMillis;
            return this;
        }

        public Builder setState(State state) {
            this.state = state;
            return this;
        }

        public Builder setWatermark(Timestamp watermark) {
            this.watermark = watermark;
            return this;
        }

        public Builder setCreatedAt(Timestamp createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public Builder setScheduledAt(@Nullable Timestamp scheduledAt) {
            this.scheduledAt = scheduledAt;
            return this;
        }

        public Builder setRunningAt(@Nullable Timestamp runningAt) {
            this.runningAt = runningAt;
            return this;
        }

        public Builder setFinishedAt(@Nullable Timestamp finishedAt) {
            this.finishedAt = finishedAt;
            return this;
        }

        public PartitionMetadata build() {
            Preconditions.checkState((this.partitionToken != null ? 1 : 0) != 0, (Object)"partitionToken");
            Preconditions.checkState((this.parentTokens != null ? 1 : 0) != 0, (Object)"parentTokens");
            Preconditions.checkState((this.startTimestamp != null ? 1 : 0) != 0, (Object)"startTimestamp");
            Preconditions.checkState((this.heartbeatMillis != null ? 1 : 0) != 0, (Object)"heartbeatMillis");
            Preconditions.checkState((this.state != null ? 1 : 0) != 0, (Object)"state");
            Preconditions.checkState((this.watermark != null ? 1 : 0) != 0, (Object)"watermark");
            if (this.createdAt == null) {
                this.createdAt = Value.COMMIT_TIMESTAMP;
            }
            return new PartitionMetadata(this.partitionToken, this.parentTokens, this.startTimestamp, this.endTimestamp, this.heartbeatMillis, this.state, this.watermark, this.createdAt, this.scheduledAt, this.runningAt, this.finishedAt);
        }
    }

    @DefaultCoder(value=AvroCoder.class)
    public static enum State {
        CREATED,
        SCHEDULED,
        RUNNING,
        FINISHED;

    }
}

