/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner.changestreams;

import com.google.cloud.Timestamp;
import java.math.BigDecimal;

public class TimestampConverter {
    public static final long MAX_MICROS = TimestampConverter.timestampToMicros(Timestamp.MAX_VALUE);

    public static long timestampToMicros(Timestamp timestamp) {
        BigDecimal seconds = BigDecimal.valueOf(timestamp.getSeconds());
        BigDecimal nanos = BigDecimal.valueOf(timestamp.getNanos());
        BigDecimal micros = nanos.scaleByPowerOfTen(-3);
        return seconds.scaleByPowerOfTen(6).add(micros).longValue();
    }

    public static Timestamp timestampFromMillis(long millis) {
        return Timestamp.ofTimeMicroseconds((long)(millis * 1000L));
    }

    public static Timestamp truncateNanos(Timestamp timestamp) {
        return Timestamp.ofTimeMicroseconds((long)TimestampConverter.timestampToMicros(timestamp));
    }
}

