/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsublite.internal;

import com.google.api.core.ApiService;
import com.google.cloud.pubsublite.Offset;
import com.google.cloud.pubsublite.cloudpubsub.FlowControlSettings;
import com.google.cloud.pubsublite.internal.CheckedApiException;
import com.google.cloud.pubsublite.internal.ExtractStatus;
import com.google.cloud.pubsublite.internal.wire.ApiServiceUtils;
import com.google.cloud.pubsublite.internal.wire.Subscriber;
import com.google.cloud.pubsublite.internal.wire.SystemExecutors;
import com.google.cloud.pubsublite.proto.FlowControlRequest;
import com.google.cloud.pubsublite.proto.SequencedMessage;
import com.google.protobuf.Timestamp;
import com.google.protobuf.util.Timestamps;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.OffsetByteProgress;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.OffsetByteRange;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.SubscriptionPartitionProcessor;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.util.concurrent.SettableFuture;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SubscriptionPartitionProcessorImpl
extends ApiService.Listener
implements SubscriptionPartitionProcessor,
AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(SubscriptionPartitionProcessorImpl.class);
    private final RestrictionTracker<OffsetByteRange, OffsetByteProgress> tracker;
    private final DoFn.OutputReceiver<SequencedMessage> receiver;
    private final Subscriber subscriber;
    private final SettableFuture<Void> completionFuture = SettableFuture.create();
    private final SynchronousQueue<List<SequencedMessage>> transfer = new SynchronousQueue();
    private final FlowControlSettings flowControlSettings;
    private Optional<Offset> lastClaimedOffset = Optional.empty();

    SubscriptionPartitionProcessorImpl(RestrictionTracker<OffsetByteRange, OffsetByteProgress> tracker, DoFn.OutputReceiver<SequencedMessage> receiver, Function<Consumer<List<SequencedMessage>>, Subscriber> subscriberFactory, FlowControlSettings flowControlSettings) {
        this.tracker = tracker;
        this.receiver = receiver;
        this.subscriber = subscriberFactory.apply(this::onSubscriberMessages);
        this.flowControlSettings = flowControlSettings;
    }

    public void failed(ApiService.State from, Throwable failure) {
        this.completionFuture.setException((Throwable)ExtractStatus.toCanonical((Throwable)failure));
    }

    private void onSubscriberMessages(List<SequencedMessage> messages) {
        try {
            while (!this.completionFuture.isDone()) {
                if (!this.transfer.offer(messages, 10L, TimeUnit.MILLISECONDS)) continue;
                return;
            }
        }
        catch (Throwable t) {
            throw ExtractStatus.toCanonical((Throwable)t).underlying;
        }
    }

    private void start() {
        this.subscriber.addListener((ApiService.Listener)this, SystemExecutors.getFuturesExecutor());
        this.subscriber.startAsync();
        this.subscriber.awaitRunning();
        try {
            this.subscriber.allowFlow(FlowControlRequest.newBuilder().setAllowedBytes(this.flowControlSettings.bytesOutstanding()).setAllowedMessages(this.flowControlSettings.messagesOutstanding()).build());
        }
        catch (Throwable t) {
            throw ExtractStatus.toCanonical((Throwable)t).underlying;
        }
    }

    private void handleMessages(List<SequencedMessage> messages) {
        long byteSize;
        if (this.completionFuture.isDone()) {
            return;
        }
        Offset lastOffset = Offset.of((long)((SequencedMessage)Iterables.getLast(messages)).getCursor().getOffset());
        if (this.tracker.tryClaim((Object)OffsetByteProgress.of(lastOffset, byteSize = messages.stream().mapToLong(SequencedMessage::getSizeBytes).sum()))) {
            this.lastClaimedOffset = Optional.of(lastOffset);
            messages.forEach(message -> this.receiver.outputWithTimestamp(message, new Instant(Timestamps.toMillis((Timestamp)message.getPublishTime()))));
            try {
                this.subscriber.allowFlow(FlowControlRequest.newBuilder().setAllowedBytes(byteSize).setAllowedMessages((long)messages.size()).build());
            }
            catch (CheckedApiException e) {
                this.completionFuture.setException((Throwable)e);
            }
        } else {
            this.completionFuture.set(null);
        }
    }

    @Override
    public DoFn.ProcessContinuation runFor(Duration duration) {
        Instant deadline = Instant.now().plus((ReadableDuration)duration);
        this.start();
        try (SubscriptionPartitionProcessorImpl closeThis = this;){
            while (!this.completionFuture.isDone() && deadline.isAfterNow()) {
                List<SequencedMessage> messages = this.transfer.poll(10L, TimeUnit.MILLISECONDS);
                if (messages == null) continue;
                this.handleMessages(messages);
            }
        }
        catch (Throwable t) {
            throw ExtractStatus.toCanonical((Throwable)t).underlying;
        }
        if (this.completionFuture.isDone()) {
            try {
                this.completionFuture.get();
            }
            catch (Throwable t) {
                throw ExtractStatus.toCanonical((Throwable)t).underlying;
            }
            return DoFn.ProcessContinuation.stop();
        }
        return DoFn.ProcessContinuation.resume();
    }

    @Override
    public void close() {
        try {
            ApiServiceUtils.blockingShutdown((ApiService)this.subscriber);
        }
        catch (Throwable t) {
            LOG.info("Error on subscriber shutdown.", t);
        }
    }

    @Override
    public Optional<Offset> lastClaimed() {
        return this.lastClaimedOffset;
    }
}

