/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsublite.internal;

import com.google.api.core.ApiService;
import com.google.api.gax.rpc.ApiException;
import com.google.cloud.pubsublite.MessageMetadata;
import com.google.cloud.pubsublite.internal.Publisher;
import com.google.cloud.pubsublite.internal.wire.SystemExecutors;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import java.util.HashMap;
import org.apache.beam.sdk.io.gcp.pubsublite.PublisherOptions;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.PublisherAssembler;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PublisherCache
implements AutoCloseable {
    private final Logger logger = LoggerFactory.getLogger(PublisherCache.class);
    @GuardedBy(value="this")
    private final HashMap<PublisherOptions, Publisher<MessageMetadata>> livePublishers = new HashMap();

    PublisherCache() {
    }

    private synchronized void evict(PublisherOptions options) {
        this.livePublishers.remove(options);
    }

    synchronized Publisher<MessageMetadata> get(final PublisherOptions options) throws ApiException {
        Publisher<MessageMetadata> publisher = this.livePublishers.get(options);
        if (publisher != null) {
            return publisher;
        }
        publisher = new PublisherAssembler(options).newPublisher();
        this.livePublishers.put(options, publisher);
        publisher.addListener(new ApiService.Listener(){

            public void failed(ApiService.State s, Throwable t) {
                PublisherCache.this.logger.warn("Publisher failed.", t);
                PublisherCache.this.evict(options);
            }
        }, SystemExecutors.getFuturesExecutor());
        publisher.startAsync().awaitRunning();
        return publisher;
    }

    @VisibleForTesting
    synchronized void set(PublisherOptions options, Publisher<MessageMetadata> toCache) {
        this.livePublishers.put(options, toCache);
    }

    @Override
    public synchronized void close() {
        this.livePublishers.forEach((options, publisher) -> publisher.stopAsync());
        this.livePublishers.clear();
    }
}

