/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsublite.internal;

import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.PartitionLookupUtils;
import com.google.cloud.pubsublite.SubscriptionPath;
import com.google.cloud.pubsublite.TopicPath;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.SubscriptionPartition;
import org.apache.beam.sdk.transforms.Contextful;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.Watch;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.joda.time.Duration;
import org.joda.time.Instant;

class SubscriptionPartitionLoader
extends PTransform<PBegin, PCollection<SubscriptionPartition>> {
    private final TopicPath topic;
    private final SubscriptionPath subscription;
    private final SerializableFunction<TopicPath, Integer> getPartitionCount;
    private final Duration pollDuration;
    private final boolean terminate;

    SubscriptionPartitionLoader(TopicPath topic, SubscriptionPath subscription) {
        this(topic, subscription, (SerializableFunction<TopicPath, Integer>)((SerializableFunction & Serializable)PartitionLookupUtils::numPartitions), Duration.standardMinutes((long)1L), false);
    }

    @VisibleForTesting
    SubscriptionPartitionLoader(TopicPath topic, SubscriptionPath subscription, SerializableFunction<TopicPath, Integer> getPartitionCount, Duration pollDuration, boolean terminate) {
        this.topic = topic;
        this.subscription = subscription;
        this.getPartitionCount = getPartitionCount;
        this.pollDuration = pollDuration;
        this.terminate = terminate;
    }

    public PCollection<SubscriptionPartition> expand(PBegin input) {
        PCollection start = (PCollection)input.apply((PTransform)Create.of((Iterable)ImmutableList.of((Object)this.topic)));
        PCollection partitions = (PCollection)start.apply((PTransform)Watch.growthOf((Watch.Growth.PollFn)new Watch.Growth.PollFn<TopicPath, Partition>(){

            public Watch.Growth.PollResult<Partition> apply(TopicPath element, Contextful.Fn.Context c) {
                Preconditions.checkArgument((boolean)element.equals(SubscriptionPartitionLoader.this.topic));
                int partitionCount = (Integer)SubscriptionPartitionLoader.this.getPartitionCount.apply((Object)element);
                List partitions = IntStream.range(0, partitionCount).mapToObj(Partition::of).collect(Collectors.toList());
                return Watch.Growth.PollResult.incomplete((Instant)Instant.now(), partitions).withWatermark(Instant.now());
            }
        }).withPollInterval(this.pollDuration).withTerminationPerInput((Watch.Growth.TerminationCondition)(this.terminate ? Watch.Growth.afterIterations((int)10) : Watch.Growth.never())));
        return (PCollection)partitions.apply((PTransform)MapElements.into((TypeDescriptor)TypeDescriptor.of(SubscriptionPartition.class)).via((SerializableFunction & Serializable)kv -> SubscriptionPartition.of(this.subscription, (Partition)kv.getValue())));
    }
}

