/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.cloud.bigquery.storage.v1.ArrowRecordBatch;
import com.google.cloud.bigquery.storage.v1.ArrowSchema;
import com.google.cloud.bigquery.storage.v1.ReadRowsResponse;
import com.google.cloud.bigquery.storage.v1.ReadSession;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nullable;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.types.pojo.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.beam.sdk.extensions.arrow.ArrowConversion;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryStorageReader;
import org.apache.beam.sdk.schemas.utils.AvroUtils;
import org.apache.beam.sdk.values.Row;

class BigQueryStorageArrowReader
implements BigQueryStorageReader {
    @Nullable
    private ArrowConversion.RecordBatchRowIterator recordBatchIterator;
    private long rowCount;
    private ArrowSchema protoSchema;
    @Nullable
    private RootAllocator alloc;

    BigQueryStorageArrowReader(ReadSession readSession) throws IOException {
        this.protoSchema = readSession.getArrowSchema();
        this.rowCount = 0L;
        this.alloc = null;
    }

    @Override
    public void processReadRowsResponse(ReadRowsResponse readRowsResponse) throws IOException {
        ArrowRecordBatch recordBatch = readRowsResponse.getArrowRecordBatch();
        this.rowCount = recordBatch.getRowCount();
        this.alloc = new RootAllocator(Long.MAX_VALUE);
        InputStream input = this.protoSchema.getSerializedSchema().newInput();
        Schema arrowSchema = ArrowConversion.arrowSchemaFromInput((InputStream)input);
        this.recordBatchIterator = ArrowConversion.rowsFromSerializedRecordBatch((Schema)arrowSchema, (InputStream)recordBatch.getSerializedRecordBatch().newInput(), (RootAllocator)this.alloc);
    }

    @Override
    public long getRowCount() {
        return this.rowCount;
    }

    @Override
    public GenericRecord readSingleRecord() throws IOException {
        if (this.recordBatchIterator == null) {
            throw new IOException("Not Initialized");
        }
        Row row = this.recordBatchIterator.next();
        return AvroUtils.toGenericRecord((Row)row, null);
    }

    @Override
    public boolean readyForNextReadResponse() throws IOException {
        return this.recordBatchIterator == null || !this.recordBatchIterator.hasNext();
    }

    @Override
    public void resetBuffer() {
        this.cleanUp();
    }

    private void cleanUp() {
        if (this.recordBatchIterator != null) {
            this.recordBatchIterator.close();
            this.recordBatchIterator = null;
        }
        if (this.alloc != null) {
            this.alloc.close();
            this.alloc = null;
        }
    }

    @Override
    public void close() {
        this.cleanUp();
    }
}

