/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner;

import com.google.auto.value.AutoValue;
import com.google.cloud.ServiceFactory;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerOptions;
import java.io.Serializable;
import org.apache.beam.sdk.io.gcp.spanner.AutoValue_SpannerConfig;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.Duration;

@AutoValue
public abstract class SpannerConfig
implements Serializable {
    private static final String DEFAULT_HOST = "https://batch-spanner.googleapis.com/";
    private static final Duration DEFAULT_COMMIT_DEADLINE = Duration.standardSeconds((long)15L);
    private static final Duration DEFAULT_MAX_CUMULATIVE_BACKOFF = Duration.standardMinutes((long)15L);
    private static final Options.RpcPriority DEFAULT_RPC_PRIORITY = Options.RpcPriority.MEDIUM;

    public abstract @Nullable ValueProvider<String> getProjectId();

    public abstract @Nullable ValueProvider<String> getInstanceId();

    public abstract @Nullable ValueProvider<String> getDatabaseId();

    public abstract @Nullable ValueProvider<String> getHost();

    public abstract @Nullable ValueProvider<String> getEmulatorHost();

    public abstract @Nullable ValueProvider<Duration> getCommitDeadline();

    public abstract @Nullable ValueProvider<Duration> getMaxCumulativeBackoff();

    public abstract Options.RpcPriority getRpcPriority();

    @VisibleForTesting
    abstract @Nullable ServiceFactory<Spanner, SpannerOptions> getServiceFactory();

    abstract Builder toBuilder();

    public static SpannerConfig create() {
        return SpannerConfig.builder().setHost((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)DEFAULT_HOST)).setCommitDeadline((ValueProvider<Duration>)ValueProvider.StaticValueProvider.of((Object)DEFAULT_COMMIT_DEADLINE)).setMaxCumulativeBackoff((ValueProvider<Duration>)ValueProvider.StaticValueProvider.of((Object)DEFAULT_MAX_CUMULATIVE_BACKOFF)).setRpcPriority(DEFAULT_RPC_PRIORITY).build();
    }

    static Builder builder() {
        return new AutoValue_SpannerConfig.Builder();
    }

    public void validate() {
        Preconditions.checkNotNull(this.getInstanceId(), (Object)"SpannerIO.read() requires instance id to be set with withInstanceId method");
        Preconditions.checkNotNull(this.getDatabaseId(), (Object)"SpannerIO.read() requires database id to be set with withDatabaseId method");
    }

    public void populateDisplayData(DisplayData.Builder builder) {
        builder.addIfNotNull(DisplayData.item((String)"projectId", this.getProjectId()).withLabel("Output Project")).addIfNotNull(DisplayData.item((String)"instanceId", this.getInstanceId()).withLabel("Output Instance")).addIfNotNull(DisplayData.item((String)"databaseId", this.getDatabaseId()).withLabel("Output Database"));
        if (this.getServiceFactory() != null) {
            builder.addIfNotNull(DisplayData.item((String)"serviceFactory", (String)this.getServiceFactory().getClass().getName()).withLabel("Service Factory"));
        }
    }

    public SpannerConfig withProjectId(ValueProvider<String> projectId) {
        return this.toBuilder().setProjectId(projectId).build();
    }

    public SpannerConfig withProjectId(String projectId) {
        return this.withProjectId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)projectId));
    }

    public SpannerConfig withInstanceId(ValueProvider<String> instanceId) {
        return this.toBuilder().setInstanceId(instanceId).build();
    }

    public SpannerConfig withInstanceId(String instanceId) {
        return this.withInstanceId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)instanceId));
    }

    public SpannerConfig withDatabaseId(ValueProvider<String> databaseId) {
        return this.toBuilder().setDatabaseId(databaseId).build();
    }

    public SpannerConfig withDatabaseId(String databaseId) {
        return this.withDatabaseId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)databaseId));
    }

    public SpannerConfig withHost(ValueProvider<String> host) {
        return this.toBuilder().setHost(host).build();
    }

    public SpannerConfig withEmulatorHost(ValueProvider<String> emulatorHost) {
        return this.toBuilder().setEmulatorHost(emulatorHost).build();
    }

    public SpannerConfig withCommitDeadline(Duration commitDeadline) {
        return this.withCommitDeadline((ValueProvider<Duration>)ValueProvider.StaticValueProvider.of((Object)commitDeadline));
    }

    public SpannerConfig withCommitDeadline(ValueProvider<Duration> commitDeadline) {
        return this.toBuilder().setCommitDeadline(commitDeadline).build();
    }

    public SpannerConfig withMaxCumulativeBackoff(Duration maxCumulativeBackoff) {
        return this.withMaxCumulativeBackoff((ValueProvider<Duration>)ValueProvider.StaticValueProvider.of((Object)maxCumulativeBackoff));
    }

    public SpannerConfig withMaxCumulativeBackoff(ValueProvider<Duration> maxCumulativeBackoff) {
        return this.toBuilder().setMaxCumulativeBackoff(maxCumulativeBackoff).build();
    }

    @VisibleForTesting
    SpannerConfig withServiceFactory(ServiceFactory<Spanner, SpannerOptions> serviceFactory) {
        return this.toBuilder().setServiceFactory(serviceFactory).build();
    }

    public SpannerConfig withRpcPriority(Options.RpcPriority rpcPriority) {
        return this.toBuilder().setRpcPriority(rpcPriority).build();
    }

    @AutoValue.Builder
    public static abstract class Builder {
        abstract Builder setProjectId(ValueProvider<String> var1);

        abstract Builder setInstanceId(ValueProvider<String> var1);

        abstract Builder setDatabaseId(ValueProvider<String> var1);

        abstract Builder setHost(ValueProvider<String> var1);

        abstract Builder setEmulatorHost(ValueProvider<String> var1);

        abstract Builder setCommitDeadline(ValueProvider<Duration> var1);

        abstract Builder setMaxCumulativeBackoff(ValueProvider<Duration> var1);

        abstract Builder setServiceFactory(ServiceFactory<Spanner, SpannerOptions> var1);

        abstract Builder setRpcPriority(Options.RpcPriority var1);

        public abstract SpannerConfig build();
    }
}

