/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsublite.internal;

import com.google.api.gax.rpc.ApiException;
import com.google.cloud.pubsublite.Offset;
import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.TopicPath;
import com.google.cloud.pubsublite.internal.ExtractStatus;
import com.google.cloud.pubsublite.internal.TopicStatsClient;
import com.google.cloud.pubsublite.proto.ComputeMessageStatsResponse;
import java.util.concurrent.ExecutionException;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.TopicBacklogReader;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class TopicBacklogReaderImpl
implements TopicBacklogReader {
    private static final Logger LOG = LoggerFactory.getLogger(TopicBacklogReaderImpl.class);
    private final TopicStatsClient client;
    private final TopicPath topicPath;
    private final Partition partition;

    public TopicBacklogReaderImpl(TopicStatsClient client, TopicPath topicPath, Partition partition) {
        this.client = client;
        this.topicPath = topicPath;
        this.partition = partition;
    }

    @Override
    public ComputeMessageStatsResponse computeMessageStats(Offset offset) throws ApiException {
        try {
            return (ComputeMessageStatsResponse)this.client.computeMessageStats(this.topicPath, this.partition, offset, Offset.of((long)Integer.MAX_VALUE)).get();
        }
        catch (ExecutionException e) {
            Throwable cause = (Throwable)Preconditions.checkNotNull((Object)e.getCause());
            throw ExtractStatus.toCanonical((Throwable)cause).underlying;
        }
        catch (InterruptedException e) {
            throw ExtractStatus.toCanonical((Throwable)e).underlying;
        }
    }

    @Override
    public void close() {
        try {
            this.client.close();
        }
        catch (Exception e) {
            LOG.warn("Failed to close topic stats client.", (Throwable)e);
        }
    }
}

