/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.healthcare;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import com.google.api.services.healthcare.v1.CloudHealthcare;
import com.google.api.services.healthcare.v1.model.CreateMessageRequest;
import com.google.api.services.healthcare.v1.model.DeidentifyConfig;
import com.google.api.services.healthcare.v1.model.DeidentifyFhirStoreRequest;
import com.google.api.services.healthcare.v1.model.DicomStore;
import com.google.api.services.healthcare.v1.model.Empty;
import com.google.api.services.healthcare.v1.model.ExportResourcesRequest;
import com.google.api.services.healthcare.v1.model.FhirStore;
import com.google.api.services.healthcare.v1.model.GoogleCloudHealthcareV1FhirGcsDestination;
import com.google.api.services.healthcare.v1.model.GoogleCloudHealthcareV1FhirGcsSource;
import com.google.api.services.healthcare.v1.model.Hl7V2Store;
import com.google.api.services.healthcare.v1.model.HttpBody;
import com.google.api.services.healthcare.v1.model.ImportResourcesRequest;
import com.google.api.services.healthcare.v1.model.IngestMessageRequest;
import com.google.api.services.healthcare.v1.model.IngestMessageResponse;
import com.google.api.services.healthcare.v1.model.ListFhirStoresResponse;
import com.google.api.services.healthcare.v1.model.ListMessagesResponse;
import com.google.api.services.healthcare.v1.model.Message;
import com.google.api.services.healthcare.v1.model.NotificationConfig;
import com.google.api.services.healthcare.v1.model.Operation;
import com.google.api.services.healthcare.v1.model.SearchResourcesRequest;
import com.google.auth.oauth2.GoogleCredentials;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.stream.Collectors;
import org.apache.beam.sdk.extensions.gcp.util.RetryHttpRequestInitializer;
import org.apache.beam.sdk.io.gcp.healthcare.HL7v2Message;
import org.apache.beam.sdk.io.gcp.healthcare.HealthcareApiClient;
import org.apache.beam.sdk.io.gcp.healthcare.WebPathParser;
import org.apache.beam.sdk.util.ReleaseInfo;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Splitter;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Strings;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpHealthcareApiClient
implements HealthcareApiClient,
Serializable {
    private static final String USER_AGENT = String.format("apache-beam-io-google-cloud-platform-healthcare/%s", ReleaseInfo.getReleaseInfo().getSdkVersion());
    private static final String FHIRSTORE_HEADER_CONTENT_TYPE = "application/fhir+json";
    private static final String FHIRSTORE_HEADER_ACCEPT = "application/fhir+json; charset=utf-8";
    private static final String FHIRSTORE_HEADER_ACCEPT_CHARSET = "utf-8";
    private static final Logger LOG = LoggerFactory.getLogger(HttpHealthcareApiClient.class);
    private transient CloudHealthcare client;
    private transient HttpClient httpClient;
    private transient GoogleCredentials credentials;

    public HttpHealthcareApiClient() throws IOException {
        this.initClient();
    }

    public HttpHealthcareApiClient(CloudHealthcare client) throws IOException {
        this.client = client;
        this.httpClient = HttpClients.createDefault();
        this.initClient();
    }

    public JsonFactory getJsonFactory() {
        return this.client.getJsonFactory();
    }

    @Override
    public Hl7V2Store createHL7v2Store(String dataset, String name) throws IOException {
        Hl7V2Store store = new Hl7V2Store();
        return (Hl7V2Store)this.client.projects().locations().datasets().hl7V2Stores().create(dataset, store).setHl7V2StoreId(name).execute();
    }

    @Override
    public FhirStore createFhirStore(String dataset, String name, String version) throws IOException {
        return this.createFhirStore(dataset, name, version, null);
    }

    @Override
    public FhirStore createFhirStore(String dataset, String name, String version, @Nullable String pubsubTopic) throws IOException {
        FhirStore store = new FhirStore();
        store.setVersion(version);
        store.setDisableReferentialIntegrity(Boolean.valueOf(true));
        store.setEnableUpdateCreate(Boolean.valueOf(true));
        if (pubsubTopic != null) {
            NotificationConfig notificationConfig = new NotificationConfig();
            notificationConfig.setPubsubTopic(pubsubTopic);
            store.setNotificationConfig(notificationConfig);
        }
        return (FhirStore)this.client.projects().locations().datasets().fhirStores().create(dataset, store).setFhirStoreId(name).execute();
    }

    @Override
    public List<FhirStore> listAllFhirStores(String dataset) throws IOException {
        ListFhirStoresResponse resp;
        ArrayList<FhirStore> fhirStores = new ArrayList<FhirStore>();
        String pageToken = "";
        do {
            resp = (ListFhirStoresResponse)this.client.projects().locations().datasets().fhirStores().list(dataset).setPageToken(pageToken).execute();
            for (FhirStore fs : resp.getFhirStores()) {
                fhirStores.add(fs);
            }
        } while (resp.getNextPageToken() != null && !(pageToken = resp.getNextPageToken()).equals(""));
        return fhirStores;
    }

    @Override
    public Empty deleteHL7v2Store(String name) throws IOException {
        return (Empty)this.client.projects().locations().datasets().hl7V2Stores().delete(name).execute();
    }

    @Override
    public Empty deleteFhirStore(String name) throws IOException {
        return (Empty)this.client.projects().locations().datasets().fhirStores().delete(name).execute();
    }

    @Override
    public String retrieveDicomStudyMetadata(String dicomWebPath) throws IOException {
        WebPathParser parser = new WebPathParser();
        WebPathParser.DicomWebPath parsedDicomWebPath = parser.parseDicomWebpath(dicomWebPath);
        String searchQuery = String.format("studies/%s/metadata", parsedDicomWebPath.studyId);
        return this.makeRetrieveStudyMetadataRequest(parsedDicomWebPath.dicomStorePath, searchQuery);
    }

    @Override
    public DicomStore createDicomStore(String dataset, String name) throws IOException {
        return this.createDicomStore(dataset, name, null);
    }

    @Override
    public Empty deleteDicomStore(String name) throws IOException {
        return (Empty)this.client.projects().locations().datasets().dicomStores().delete(name).execute();
    }

    @Override
    public Empty uploadToDicomStore(String webPath, String filePath) throws IOException, URISyntaxException {
        byte[] dcmFile = Files.readAllBytes(Paths.get(filePath, new String[0]));
        ByteArrayEntity requestEntity = new ByteArrayEntity(dcmFile);
        String uri = String.format("%sv1/%s/dicomWeb/studies", this.client.getRootUrl(), webPath);
        URIBuilder uriBuilder = new URIBuilder(uri).setParameter("access_token", this.credentials.getAccessToken().getTokenValue());
        HttpUriRequest request = RequestBuilder.post((URI)uriBuilder.build()).setEntity((HttpEntity)requestEntity).addHeader("Content-Type", "application/dicom").build();
        org.apache.http.HttpResponse response = this.httpClient.execute(request);
        return new Empty();
    }

    @Override
    public DicomStore createDicomStore(String dataset, String name, @Nullable String pubsubTopic) throws IOException {
        DicomStore store = new DicomStore();
        if (pubsubTopic != null) {
            NotificationConfig notificationConfig = new NotificationConfig();
            notificationConfig.setPubsubTopic(pubsubTopic);
            store.setNotificationConfig(notificationConfig);
        }
        return (DicomStore)this.client.projects().locations().datasets().dicomStores().create(dataset, store).setDicomStoreId(name).execute();
    }

    private String makeRetrieveStudyMetadataRequest(String dicomStorePath, String searchQuery) throws IOException {
        CloudHealthcare.Projects.Locations.Datasets.DicomStores.Studies.RetrieveMetadata request = this.client.projects().locations().datasets().dicomStores().studies().retrieveMetadata(dicomStorePath, searchQuery);
        HttpResponse response = request.executeUnparsed();
        return response.parseAsString();
    }

    @Override
    public Instant getEarliestHL7v2SendTime(String hl7v2Store, @Nullable String filter) throws IOException {
        ListMessagesResponse response = (ListMessagesResponse)this.client.projects().locations().datasets().hl7V2Stores().messages().list(hl7v2Store).setFilter(filter).set("view", (Object)"full").setOrderBy("sendTime").setPageSize(Integer.valueOf(1)).execute();
        if (response.isEmpty()) {
            throw new IllegalArgumentException(String.format("Could not find earliest send time. The filter %s  matched no results on HL7v2 Store: %s", filter, hl7v2Store));
        }
        String sendTime = ((Message)response.getHl7V2Messages().get(0)).getSendTime();
        if (Strings.isNullOrEmpty((String)sendTime)) {
            LOG.warn(String.format("Earliest message in %s has null or empty sendTime defaulting to Epoch.", hl7v2Store));
            return Instant.ofEpochMilli((long)0L);
        }
        return Instant.parse((String)sendTime);
    }

    @Override
    public Instant getLatestHL7v2SendTime(String hl7v2Store, @Nullable String filter) throws IOException {
        ListMessagesResponse response = (ListMessagesResponse)this.client.projects().locations().datasets().hl7V2Stores().messages().list(hl7v2Store).setFilter(filter).set("view", (Object)"full").setOrderBy("sendTime desc").setPageSize(Integer.valueOf(1)).execute();
        if (response.isEmpty()) {
            throw new IllegalArgumentException(String.format("Could not find latest send time. The filter %s  matched no results on HL7v2 Store: %s", filter, hl7v2Store));
        }
        String sendTime = ((Message)response.getHl7V2Messages().get(0)).getSendTime();
        if (Strings.isNullOrEmpty((String)sendTime)) {
            LOG.warn(String.format("Latest message in %s has null or empty sendTime defaulting to now.", hl7v2Store));
            return Instant.now();
        }
        return Instant.parse((String)sendTime);
    }

    @Override
    public ListMessagesResponse makeSendTimeBoundHL7v2ListRequest(String hl7v2Store, Instant start, @Nullable Instant end, @Nullable String otherFilter, @Nullable String orderBy, @Nullable String pageToken) throws IOException {
        String sendTimeFilter = "";
        if (start != null) {
            sendTimeFilter = sendTimeFilter + String.format("sendTime >= \"%s\"", start.toString());
            if (end != null) {
                sendTimeFilter = sendTimeFilter + String.format(" AND sendTime < \"%s\"", end.toString());
            }
        }
        String filter = otherFilter != null && !Strings.isNullOrEmpty((String)sendTimeFilter) ? sendTimeFilter + " AND " + otherFilter : sendTimeFilter;
        return this.makeHL7v2ListRequest(hl7v2Store, filter, orderBy, pageToken);
    }

    @Override
    public ListMessagesResponse makeHL7v2ListRequest(String hl7v2Store, @Nullable String filter, @Nullable String orderBy, @Nullable String pageToken) throws IOException {
        CloudHealthcare.Projects.Locations.Datasets.Hl7V2Stores.Messages.List baseRequest = this.client.projects().locations().datasets().hl7V2Stores().messages().list(hl7v2Store).set("view", (Object)"full").setFilter(filter).setPageSize(Integer.valueOf(1000)).setPageToken(pageToken);
        if (orderBy == null) {
            return (ListMessagesResponse)baseRequest.execute();
        }
        return (ListMessagesResponse)baseRequest.setOrderBy(orderBy).execute();
    }

    @Override
    public Message getHL7v2Message(String msgName) throws IOException {
        Message msg = (Message)this.client.projects().locations().datasets().hl7V2Stores().messages().get(msgName).execute();
        if (msg == null) {
            throw new IOException(String.format("Couldn't find message: %s.", msgName));
        }
        return msg;
    }

    @Override
    public Empty deleteHL7v2Message(String msgName) throws IOException {
        return (Empty)this.client.projects().locations().datasets().hl7V2Stores().messages().delete(msgName).execute();
    }

    @Override
    public Hl7V2Store getHL7v2Store(String storeName) throws IOException {
        return (Hl7V2Store)this.client.projects().locations().datasets().hl7V2Stores().get(storeName).execute();
    }

    @Override
    public IngestMessageResponse ingestHL7v2Message(String hl7v2Store, Message msg) throws IOException {
        IngestMessageRequest ingestMessageRequest = new IngestMessageRequest();
        ingestMessageRequest.setMessage(msg);
        return (IngestMessageResponse)this.client.projects().locations().datasets().hl7V2Stores().messages().ingest(hl7v2Store, ingestMessageRequest).execute();
    }

    @Override
    public Message createHL7v2Message(String hl7v2Store, Message msg) throws IOException {
        CreateMessageRequest createMessageRequest = new CreateMessageRequest();
        createMessageRequest.setMessage(msg);
        return (Message)this.client.projects().locations().datasets().hl7V2Stores().messages().create(hl7v2Store, createMessageRequest).execute();
    }

    @Override
    public Operation importFhirResource(String fhirStore, String gcsSourcePath, @Nullable String contentStructure) throws IOException {
        GoogleCloudHealthcareV1FhirGcsSource gcsSrc = new GoogleCloudHealthcareV1FhirGcsSource();
        gcsSrc.setUri(gcsSourcePath);
        ImportResourcesRequest importRequest = new ImportResourcesRequest();
        importRequest.setGcsSource(gcsSrc).setContentStructure(contentStructure);
        return (Operation)this.client.projects().locations().datasets().fhirStores().healthcareImport(fhirStore, importRequest).execute();
    }

    @Override
    public Operation exportFhirResourceToGcs(String fhirStore, String gcsDestinationPrefix) throws IOException {
        GoogleCloudHealthcareV1FhirGcsDestination gcsDst = new GoogleCloudHealthcareV1FhirGcsDestination();
        gcsDst.setUriPrefix(gcsDestinationPrefix);
        ExportResourcesRequest exportRequest = new ExportResourcesRequest();
        exportRequest.setGcsDestination(gcsDst);
        return (Operation)this.client.projects().locations().datasets().fhirStores().export(fhirStore, exportRequest).execute();
    }

    @Override
    public Operation deidentifyFhirStore(String sourcefhirStore, String destinationFhirStore, DeidentifyConfig deidConfig) throws IOException {
        DeidentifyFhirStoreRequest deidRequest = new DeidentifyFhirStoreRequest();
        deidRequest.setDestinationStore(destinationFhirStore);
        deidRequest.setConfig(deidConfig);
        return (Operation)this.client.projects().locations().datasets().fhirStores().deidentify(sourcefhirStore, deidRequest).execute();
    }

    @Override
    public Operation pollOperation(Operation operation, Long sleepMs) throws InterruptedException, IOException {
        LOG.debug(String.format("Operation %s started, polling until complete.", operation.getName()));
        while (operation.getDone() == null || !operation.getDone().booleanValue()) {
            Thread.sleep(sleepMs);
            operation = (Operation)this.client.projects().locations().datasets().operations().get(operation.getName()).execute();
        }
        return operation;
    }

    @Override
    public HttpBody executeFhirBundle(String fhirStore, String bundle) throws IOException, HealthcareHttpException {
        URI uri;
        if (this.httpClient == null || this.client == null) {
            this.initClient();
        }
        this.credentials.refreshIfExpired();
        StringEntity requestEntity = new StringEntity(bundle, ContentType.APPLICATION_JSON);
        try {
            uri = new URIBuilder(this.client.getRootUrl() + "v1/" + fhirStore + "/fhir").build();
        }
        catch (URISyntaxException e) {
            LOG.error("URL error when making executeBundle request to FHIR API. " + e.getMessage());
            throw new IllegalArgumentException(e);
        }
        HttpUriRequest request = RequestBuilder.post().setUri(uri).setEntity((HttpEntity)requestEntity).addHeader("Authorization", "Bearer " + this.credentials.getAccessToken().getTokenValue()).addHeader("User-Agent", USER_AGENT).addHeader("Content-Type", FHIRSTORE_HEADER_CONTENT_TYPE).addHeader("Accept-Charset", FHIRSTORE_HEADER_ACCEPT_CHARSET).addHeader("Accept", FHIRSTORE_HEADER_ACCEPT).build();
        org.apache.http.HttpResponse response = this.httpClient.execute(request);
        HttpEntity responseEntity = response.getEntity();
        String content = EntityUtils.toString((HttpEntity)responseEntity);
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode / 100 != 2) {
            throw HealthcareHttpException.of(statusCode, content);
        }
        HttpBody responseModel = new HttpBody();
        responseModel.setData(content);
        return responseModel;
    }

    @Override
    public HttpBody readFhirResource(String resourceId) throws IOException {
        return (HttpBody)this.client.projects().locations().datasets().fhirStores().fhir().read(resourceId).execute();
    }

    @Override
    public HttpBody searchFhirResource(String fhirStore, String resourceType, @Nullable Map<String, Object> parameters, String pageToken) throws IOException {
        SearchResourcesRequest request = new SearchResourcesRequest().setResourceType(resourceType);
        CloudHealthcare.Projects.Locations.Datasets.FhirStores.Fhir.Search search = this.client.projects().locations().datasets().fhirStores().fhir().search(fhirStore, request);
        if (parameters != null && !parameters.isEmpty()) {
            parameters.forEach((arg_0, arg_1) -> ((CloudHealthcare.Projects.Locations.Datasets.FhirStores.Fhir.Search)search).set(arg_0, arg_1));
        }
        if (pageToken != null && !pageToken.isEmpty()) {
            search.set("_page_token", (Object)URLDecoder.decode(pageToken, "UTF-8"));
        }
        return (HttpBody)search.execute();
    }

    private void initClient() throws IOException {
        this.credentials = GoogleCredentials.getApplicationDefault();
        AuthenticatedRetryInitializer requestInitializer = new AuthenticatedRetryInitializer(this.credentials.createScoped(new String[]{"https://www.googleapis.com/auth/cloud-platform", "https://www.googleapis.com/auth/cloud-platform.read-only"}));
        this.client = new CloudHealthcare.Builder((HttpTransport)new NetHttpTransport(), (JsonFactory)new JacksonFactory(), (HttpRequestInitializer)requestInitializer).setApplicationName("apache-beam-hl7v2-io").build();
        this.httpClient = HttpClients.custom().setRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(10, false)).build();
    }

    public static class FhirResourcePages
    implements Iterable<JsonArray> {
        private final String fhirStore;
        private final String resourceType;
        private final Map<String, Object> parameters;
        private transient HealthcareApiClient client;

        FhirResourcePages(HealthcareApiClient client, String fhirStore, String resourceType, @Nullable Map<String, Object> parameters) {
            this.client = client;
            this.fhirStore = fhirStore;
            this.resourceType = resourceType;
            this.parameters = parameters;
        }

        public static HttpBody makeSearchRequest(HealthcareApiClient client, String fhirStore, String resourceType, @Nullable Map<String, Object> parameters, String pageToken) throws IOException {
            return client.searchFhirResource(fhirStore, resourceType, parameters, pageToken);
        }

        @Override
        public Iterator<JsonArray> iterator() {
            return new FhirResourcePagesIterator(this.client, this.fhirStore, this.resourceType, this.parameters);
        }

        public static class FhirResourcePagesIterator
        implements Iterator<JsonArray> {
            private final String fhirStore;
            private final String resourceType;
            private final Map<String, Object> parameters;
            private HealthcareApiClient client;
            private String pageToken;
            private boolean isFirstRequest;
            private ObjectMapper mapper;

            FhirResourcePagesIterator(HealthcareApiClient client, String fhirStore, String resourceType, @Nullable Map<String, Object> parameters) {
                this.client = client;
                this.fhirStore = fhirStore;
                this.resourceType = resourceType;
                this.parameters = parameters;
                this.pageToken = null;
                this.isFirstRequest = true;
                this.mapper = new ObjectMapper();
            }

            @Override
            public boolean hasNext() throws NoSuchElementException {
                if (!this.isFirstRequest) {
                    return this.pageToken != null && !this.pageToken.isEmpty();
                }
                try {
                    HttpBody response = FhirResourcePages.makeSearchRequest(this.client, this.fhirStore, this.resourceType, this.parameters, this.pageToken);
                    JsonObject jsonResponse = JsonParser.parseString((String)this.mapper.writeValueAsString((Object)response)).getAsJsonObject();
                    JsonArray resources = jsonResponse.getAsJsonArray("entry");
                    return resources != null && resources.size() != 0;
                }
                catch (IOException e) {
                    throw new NoSuchElementException(String.format("Failed to list first page of Fhir resources from %s: %s", this.fhirStore, e.getMessage()));
                }
            }

            @Override
            public JsonArray next() throws NoSuchElementException {
                try {
                    HttpBody response = FhirResourcePages.makeSearchRequest(this.client, this.fhirStore, this.resourceType, this.parameters, this.pageToken);
                    this.isFirstRequest = false;
                    JsonObject jsonResponse = JsonParser.parseString((String)this.mapper.writeValueAsString((Object)response)).getAsJsonObject();
                    JsonArray links = jsonResponse.getAsJsonArray("link");
                    this.pageToken = FhirResourcePagesIterator.parsePageToken(links);
                    JsonArray resources = jsonResponse.getAsJsonArray("entry");
                    return resources;
                }
                catch (IOException e) {
                    this.pageToken = null;
                    throw new NoSuchElementException(String.format("Error listing Fhir resources from %s: %s", this.fhirStore, e.getMessage()));
                }
            }

            private static String parsePageToken(JsonArray links) throws MalformedURLException {
                for (JsonElement e : links) {
                    JsonObject link = e.getAsJsonObject();
                    if (!link.get("relation").getAsString().equalsIgnoreCase("next")) continue;
                    URL url = new URL(link.get("url").getAsString());
                    List parameters = Splitter.on((String)"&").splitToList((CharSequence)url.getQuery());
                    for (String parameter : parameters) {
                        List parts = Splitter.on((String)"=").limit(2).splitToList((CharSequence)parameter);
                        if (!((String)parts.get(0)).equalsIgnoreCase("_page_token")) continue;
                        return (String)parts.get(1);
                    }
                }
                return "";
            }
        }
    }

    public static class HL7v2MessagePages
    implements Iterable<List<HL7v2Message>> {
        private final String hl7v2Store;
        private final String filter;
        private final String orderBy;
        private final Instant start;
        private final Instant end;
        private transient HealthcareApiClient client;

        HL7v2MessagePages(HealthcareApiClient client, String hl7v2Store, @Nullable Instant start, @Nullable Instant end) {
            this(client, hl7v2Store, start, end, null, null);
        }

        HL7v2MessagePages(HealthcareApiClient client, String hl7v2Store, @Nullable Instant start, @Nullable Instant end, @Nullable String filter, @Nullable String orderBy) {
            this.client = client;
            this.hl7v2Store = hl7v2Store;
            this.filter = filter;
            this.orderBy = orderBy;
            this.start = start;
            this.end = end;
        }

        public Instant getStart() {
            return this.start;
        }

        public Instant getEnd() {
            return this.end;
        }

        public static ListMessagesResponse makeListRequest(HealthcareApiClient client, String hl7v2Store, @Nullable Instant start, @Nullable Instant end, @Nullable String filter, @Nullable String orderBy, @Nullable String pageToken) throws IOException {
            return client.makeSendTimeBoundHL7v2ListRequest(hl7v2Store, start, end, filter, orderBy, pageToken);
        }

        @Override
        public Iterator<List<HL7v2Message>> iterator() {
            return new HL7v2MessagePagesIterator(this.client, this.hl7v2Store, this.start, this.end, this.filter, this.orderBy);
        }

        public static class HL7v2MessagePagesIterator
        implements Iterator<List<HL7v2Message>> {
            private final String hl7v2Store;
            private final String filter;
            private final String orderBy;
            private final Instant start;
            private final Instant end;
            private HealthcareApiClient client;
            private String pageToken;
            private boolean isFirstRequest;

            HL7v2MessagePagesIterator(HealthcareApiClient client, String hl7v2Store, @Nullable Instant start, @Nullable Instant end, @Nullable String filter, @Nullable String orderBy) {
                this.client = client;
                this.hl7v2Store = hl7v2Store;
                this.start = start;
                this.end = end;
                this.filter = filter;
                this.orderBy = orderBy;
                this.pageToken = null;
                this.isFirstRequest = true;
            }

            @Override
            public boolean hasNext() throws NoSuchElementException {
                if (this.isFirstRequest) {
                    try {
                        ListMessagesResponse response = HL7v2MessagePages.makeListRequest(this.client, this.hl7v2Store, this.start, this.end, this.filter, this.orderBy, this.pageToken);
                        List msgs = response.getHl7V2Messages();
                        if (msgs == null) {
                            return false;
                        }
                        return !msgs.isEmpty();
                    }
                    catch (IOException e) {
                        throw new NoSuchElementException(String.format("Failed to list first page of HL7v2 messages from %s: %s", this.hl7v2Store, e.getMessage()));
                    }
                }
                return this.pageToken != null;
            }

            @Override
            public List<HL7v2Message> next() throws NoSuchElementException {
                try {
                    ListMessagesResponse response = HL7v2MessagePages.makeListRequest(this.client, this.hl7v2Store, this.start, this.end, this.filter, this.orderBy, this.pageToken);
                    this.isFirstRequest = false;
                    this.pageToken = response.getNextPageToken();
                    List msgs = response.getHl7V2Messages();
                    return msgs.stream().map(HL7v2Message::fromModel).collect(Collectors.toList());
                }
                catch (IOException e) {
                    this.pageToken = null;
                    throw new NoSuchElementException(String.format("Error listing HL7v2 Messages from %s: %s", this.hl7v2Store, e.getMessage()));
                }
            }
        }
    }

    public static class AuthenticatedRetryInitializer
    extends RetryHttpRequestInitializer {
        GoogleCredentials credentials;

        public AuthenticatedRetryInitializer(GoogleCredentials credentials) {
            this.credentials = credentials;
        }

        public void initialize(HttpRequest request) throws IOException {
            Map credentialHeaders;
            super.initialize(request);
            HttpHeaders requestHeaders = request.getHeaders();
            requestHeaders.setUserAgent(USER_AGENT);
            if (!this.credentials.hasRequestMetadata()) {
                return;
            }
            URI uri = null;
            if (request.getUrl() != null) {
                uri = request.getUrl().toURI();
            }
            if ((credentialHeaders = this.credentials.getRequestMetadata(uri)) == null) {
                return;
            }
            for (Map.Entry entry : credentialHeaders.entrySet()) {
                String headerName = (String)entry.getKey();
                ArrayList requestValues = new ArrayList((Collection)entry.getValue());
                requestHeaders.put(headerName, requestValues);
            }
        }
    }

    public static class HealthcareHttpException
    extends Exception {
        private final int statusCode;

        private HealthcareHttpException(int statusCode, String message) {
            super(message);
            this.statusCode = statusCode;
            if (statusCode / 100 == 2) {
                throw new IllegalArgumentException(String.format("2xx codes should not be exceptions. Got status code: %s with body: %s", statusCode, message));
            }
        }

        static HealthcareHttpException of(int statusCode, String message) {
            return new HealthcareHttpException(statusCode, message);
        }

        int getStatusCode() {
            return this.statusCode;
        }
    }
}

