/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.cloud.bigquery.storage.v1beta2.ProtoRows;
import com.google.protobuf.ByteString;
import java.util.Iterator;
import java.util.NoSuchElementException;

class SplittingIterable
implements Iterable<ProtoRows> {
    private final Iterable<byte[]> underlying;
    private final long splitSize;

    public SplittingIterable(Iterable<byte[]> underlying, long splitSize) {
        this.underlying = underlying;
        this.splitSize = splitSize;
    }

    @Override
    public Iterator<ProtoRows> iterator() {
        return new Iterator<ProtoRows>(){
            final Iterator<byte[]> underlyingIterator;
            {
                this.underlyingIterator = SplittingIterable.this.underlying.iterator();
            }

            @Override
            public boolean hasNext() {
                return this.underlyingIterator.hasNext();
            }

            @Override
            public ProtoRows next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                ProtoRows.Builder inserts = ProtoRows.newBuilder();
                long bytesSize = 0L;
                while (this.underlyingIterator.hasNext()) {
                    ByteString byteString = ByteString.copyFrom((byte[])this.underlyingIterator.next());
                    inserts.addSerializedRows(byteString);
                    if ((bytesSize += (long)byteString.size()) <= SplittingIterable.this.splitSize) continue;
                    break;
                }
                return inserts.build();
            }
        };
    }
}

