/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner;

import java.util.OptionalInt;
import org.apache.beam.sdk.io.gcp.spanner.SpannerConfig;
import org.apache.beam.sdk.io.gcp.spanner.SpannerIO;
import org.apache.beam.sdk.values.PCollection;
import org.checkerframework.checker.nullness.qual.Nullable;

final class AutoValue_SpannerIO_Write
extends SpannerIO.Write {
    private final SpannerConfig spannerConfig;
    private final long batchSizeBytes;
    private final long maxNumMutations;
    private final long maxNumRows;
    private final SpannerIO.FailureMode failureMode;
    private final @Nullable PCollection<?> schemaReadySignal;
    private final OptionalInt groupingFactor;

    private AutoValue_SpannerIO_Write(SpannerConfig spannerConfig, long batchSizeBytes, long maxNumMutations, long maxNumRows, SpannerIO.FailureMode failureMode, @Nullable PCollection<?> schemaReadySignal, OptionalInt groupingFactor) {
        this.spannerConfig = spannerConfig;
        this.batchSizeBytes = batchSizeBytes;
        this.maxNumMutations = maxNumMutations;
        this.maxNumRows = maxNumRows;
        this.failureMode = failureMode;
        this.schemaReadySignal = schemaReadySignal;
        this.groupingFactor = groupingFactor;
    }

    @Override
    SpannerConfig getSpannerConfig() {
        return this.spannerConfig;
    }

    @Override
    long getBatchSizeBytes() {
        return this.batchSizeBytes;
    }

    @Override
    long getMaxNumMutations() {
        return this.maxNumMutations;
    }

    @Override
    long getMaxNumRows() {
        return this.maxNumRows;
    }

    @Override
    SpannerIO.FailureMode getFailureMode() {
        return this.failureMode;
    }

    @Override
    @Nullable PCollection<?> getSchemaReadySignal() {
        return this.schemaReadySignal;
    }

    @Override
    OptionalInt getGroupingFactor() {
        return this.groupingFactor;
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SpannerIO.Write) {
            SpannerIO.Write that = (SpannerIO.Write)((Object)o);
            return this.spannerConfig.equals(that.getSpannerConfig()) && this.batchSizeBytes == that.getBatchSizeBytes() && this.maxNumMutations == that.getMaxNumMutations() && this.maxNumRows == that.getMaxNumRows() && this.failureMode.equals((Object)that.getFailureMode()) && (this.schemaReadySignal == null ? that.getSchemaReadySignal() == null : this.schemaReadySignal.equals(that.getSchemaReadySignal())) && this.groupingFactor.equals(that.getGroupingFactor());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.spannerConfig.hashCode();
        h$ *= 1000003;
        h$ ^= (int)(this.batchSizeBytes >>> 32 ^ this.batchSizeBytes);
        h$ *= 1000003;
        h$ ^= (int)(this.maxNumMutations >>> 32 ^ this.maxNumMutations);
        h$ *= 1000003;
        h$ ^= (int)(this.maxNumRows >>> 32 ^ this.maxNumRows);
        h$ *= 1000003;
        h$ ^= this.failureMode.hashCode();
        h$ *= 1000003;
        h$ ^= this.schemaReadySignal == null ? 0 : this.schemaReadySignal.hashCode();
        h$ *= 1000003;
        return h$ ^= this.groupingFactor.hashCode();
    }

    @Override
    SpannerIO.Write.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends SpannerIO.Write.Builder {
        private SpannerConfig spannerConfig;
        private Long batchSizeBytes;
        private Long maxNumMutations;
        private Long maxNumRows;
        private SpannerIO.FailureMode failureMode;
        private @Nullable PCollection<?> schemaReadySignal;
        private OptionalInt groupingFactor = OptionalInt.empty();

        Builder() {
        }

        private Builder(SpannerIO.Write source) {
            this.spannerConfig = source.getSpannerConfig();
            this.batchSizeBytes = source.getBatchSizeBytes();
            this.maxNumMutations = source.getMaxNumMutations();
            this.maxNumRows = source.getMaxNumRows();
            this.failureMode = source.getFailureMode();
            this.schemaReadySignal = source.getSchemaReadySignal();
            this.groupingFactor = source.getGroupingFactor();
        }

        @Override
        SpannerIO.Write.Builder setSpannerConfig(SpannerConfig spannerConfig) {
            if (spannerConfig == null) {
                throw new NullPointerException("Null spannerConfig");
            }
            this.spannerConfig = spannerConfig;
            return this;
        }

        @Override
        SpannerIO.Write.Builder setBatchSizeBytes(long batchSizeBytes) {
            this.batchSizeBytes = batchSizeBytes;
            return this;
        }

        @Override
        SpannerIO.Write.Builder setMaxNumMutations(long maxNumMutations) {
            this.maxNumMutations = maxNumMutations;
            return this;
        }

        @Override
        SpannerIO.Write.Builder setMaxNumRows(long maxNumRows) {
            this.maxNumRows = maxNumRows;
            return this;
        }

        @Override
        SpannerIO.Write.Builder setFailureMode(SpannerIO.FailureMode failureMode) {
            if (failureMode == null) {
                throw new NullPointerException("Null failureMode");
            }
            this.failureMode = failureMode;
            return this;
        }

        @Override
        SpannerIO.Write.Builder setSchemaReadySignal(PCollection<?> schemaReadySignal) {
            this.schemaReadySignal = schemaReadySignal;
            return this;
        }

        @Override
        SpannerIO.Write.Builder setGroupingFactor(int groupingFactor) {
            this.groupingFactor = OptionalInt.of(groupingFactor);
            return this;
        }

        @Override
        SpannerIO.Write build() {
            String missing = "";
            if (this.spannerConfig == null) {
                missing = missing + " spannerConfig";
            }
            if (this.batchSizeBytes == null) {
                missing = missing + " batchSizeBytes";
            }
            if (this.maxNumMutations == null) {
                missing = missing + " maxNumMutations";
            }
            if (this.maxNumRows == null) {
                missing = missing + " maxNumRows";
            }
            if (this.failureMode == null) {
                missing = missing + " failureMode";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_SpannerIO_Write(this.spannerConfig, this.batchSizeBytes, this.maxNumMutations, this.maxNumRows, this.failureMode, this.schemaReadySignal, this.groupingFactor);
        }
    }
}

