/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsublite;

import com.google.api.gax.rpc.ApiException;
import com.google.cloud.pubsublite.Offset;
import com.google.cloud.pubsublite.proto.ComputeMessageStatsResponse;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.concurrent.GuardedBy;
import org.apache.beam.sdk.io.gcp.pubsublite.ManagedBacklogReaderFactory;
import org.apache.beam.sdk.io.gcp.pubsublite.SubscriptionPartition;
import org.apache.beam.sdk.io.gcp.pubsublite.TopicBacklogReader;
import org.apache.beam.sdk.transforms.SerializableFunction;

public class ManagedBacklogReaderFactoryImpl
implements ManagedBacklogReaderFactory {
    private final SerializableFunction<SubscriptionPartition, TopicBacklogReader> newReader;
    @GuardedBy(value="this")
    private final Map<SubscriptionPartition, TopicBacklogReader> readers = new HashMap<SubscriptionPartition, TopicBacklogReader>();

    ManagedBacklogReaderFactoryImpl(SerializableFunction<SubscriptionPartition, TopicBacklogReader> newReader) {
        this.newReader = newReader;
    }

    @Override
    public synchronized TopicBacklogReader newReader(SubscriptionPartition subscriptionPartition) {
        return new NonCloseableTopicBacklogReader(this.readers.computeIfAbsent(subscriptionPartition, arg_0 -> this.newReader.apply(arg_0)));
    }

    @Override
    public synchronized void close() {
        this.readers.values().forEach(TopicBacklogReader::close);
    }

    private static final class NonCloseableTopicBacklogReader
    implements TopicBacklogReader {
        private final TopicBacklogReader underlying;

        NonCloseableTopicBacklogReader(TopicBacklogReader underlying) {
            this.underlying = underlying;
        }

        @Override
        public ComputeMessageStatsResponse computeMessageStats(Offset offset) throws ApiException {
            return this.underlying.computeMessageStats(offset);
        }

        @Override
        public void close() {
            throw new IllegalArgumentException("Cannot call close() on a reader returned from ManagedBacklogReaderFactory.");
        }
    }
}

