/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsublite;

import com.google.cloud.pubsublite.proto.SequencedMessage;
import java.io.Serializable;
import org.apache.beam.sdk.io.gcp.pubsublite.Uuid;
import org.apache.beam.sdk.io.gcp.pubsublite.UuidDeduplicationOptions;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ProcessFunction;
import org.apache.beam.sdk.transforms.Values;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TypeDescriptor;

class UuidDeduplicationTransform
extends PTransform<PCollection<SequencedMessage>, PCollection<SequencedMessage>> {
    private final UuidDeduplicationOptions options;

    UuidDeduplicationTransform(UuidDeduplicationOptions options) {
        this.options = options;
    }

    public PCollection<SequencedMessage> expand(PCollection<SequencedMessage> input) {
        ProcessFunction & Serializable mapWithKeys = (ProcessFunction & Serializable)message -> KV.of((Object)((Uuid)this.options.uuidExtractor().apply(message)), (Object)message);
        PCollection uuidMapped = (PCollection)input.apply("MapUuids", (PTransform)MapElements.into((TypeDescriptor)new TypeDescriptor<KV<Uuid, SequencedMessage>>(){}).via((ProcessFunction)mapWithKeys));
        PCollection unique = (PCollection)uuidMapped.apply("Deduplicate", this.options.deduplicate());
        return (PCollection)unique.apply("StripUuids", (PTransform)Values.create());
    }
}

