/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsublite;

import com.google.api.gax.rpc.ApiException;
import com.google.cloud.pubsublite.AdminClient;
import com.google.cloud.pubsublite.AdminClientSettings;
import com.google.cloud.pubsublite.MessageMetadata;
import com.google.cloud.pubsublite.TopicPath;
import com.google.cloud.pubsublite.internal.Publisher;
import com.google.cloud.pubsublite.internal.UncheckedApiPreconditions;
import com.google.cloud.pubsublite.internal.wire.PartitionCountWatchingPublisherSettings;
import com.google.cloud.pubsublite.internal.wire.PubsubContext;
import com.google.cloud.pubsublite.internal.wire.SinglePartitionPublisherBuilder;
import org.apache.beam.sdk.io.gcp.pubsublite.PublisherOptions;
import org.apache.beam.sdk.io.gcp.pubsublite.SerializableSupplier;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.reflect.TypeToken;

class Publishers {
    private static final PubsubContext.Framework FRAMEWORK = PubsubContext.Framework.of((String)"BEAM");

    private Publishers() {
    }

    static Publisher<MessageMetadata> newPublisher(PublisherOptions options) throws ApiException {
        SerializableSupplier<Object> supplier = options.publisherSupplier();
        if (supplier != null) {
            Object supplied = supplier.get();
            TypeToken<Publisher<MessageMetadata>> token = new TypeToken<Publisher<MessageMetadata>>(){};
            UncheckedApiPreconditions.checkArgument((boolean)token.isSupertypeOf(supplied.getClass()));
            return (Publisher)supplied;
        }
        TopicPath topic = options.topicPath();
        PartitionCountWatchingPublisherSettings.Builder publisherSettings = PartitionCountWatchingPublisherSettings.newBuilder().setTopic(topic).setPublisherFactory(partition -> SinglePartitionPublisherBuilder.newBuilder().setTopic(topic).setPartition(partition).build()).setAdminClient(AdminClient.create((AdminClientSettings)AdminClientSettings.newBuilder().setRegion(topic.location().region()).build()));
        return publisherSettings.build().instantiate();
    }
}

