/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsublite;

import com.google.cloud.pubsublite.Partition;
import com.google.cloud.pubsublite.SubscriptionPath;
import com.google.cloud.pubsublite.cloudpubsub.FlowControlSettings;
import com.google.cloud.pubsublite.internal.wire.Committer;
import com.google.cloud.pubsublite.internal.wire.SubscriberFactory;
import java.util.Set;
import org.apache.beam.sdk.io.gcp.pubsublite.InitialOffsetReader;
import org.apache.beam.sdk.io.gcp.pubsublite.SerializableSupplier;
import org.apache.beam.sdk.io.gcp.pubsublite.SubscriberOptions;
import org.apache.beam.sdk.io.gcp.pubsublite.TopicBacklogReader;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.Duration;

final class AutoValue_SubscriberOptions
extends SubscriberOptions {
    private final SubscriptionPath subscriptionPath;
    private final FlowControlSettings flowControlSettings;
    private final Set<Partition> partitions;
    private final Duration minBundleTimeout;
    private final @Nullable SubscriberFactory subscriberFactory;
    private final @Nullable SerializableSupplier<Committer> committerSupplier;
    private final @Nullable SerializableSupplier<TopicBacklogReader> backlogReaderSupplier;
    private final @Nullable SerializableSupplier<InitialOffsetReader> offsetReaderSupplier;
    private static final long serialVersionUID = 269598118L;

    private AutoValue_SubscriberOptions(SubscriptionPath subscriptionPath, FlowControlSettings flowControlSettings, Set<Partition> partitions, Duration minBundleTimeout, @Nullable SubscriberFactory subscriberFactory, @Nullable SerializableSupplier<Committer> committerSupplier, @Nullable SerializableSupplier<TopicBacklogReader> backlogReaderSupplier, @Nullable SerializableSupplier<InitialOffsetReader> offsetReaderSupplier) {
        this.subscriptionPath = subscriptionPath;
        this.flowControlSettings = flowControlSettings;
        this.partitions = partitions;
        this.minBundleTimeout = minBundleTimeout;
        this.subscriberFactory = subscriberFactory;
        this.committerSupplier = committerSupplier;
        this.backlogReaderSupplier = backlogReaderSupplier;
        this.offsetReaderSupplier = offsetReaderSupplier;
    }

    @Override
    public SubscriptionPath subscriptionPath() {
        return this.subscriptionPath;
    }

    @Override
    public FlowControlSettings flowControlSettings() {
        return this.flowControlSettings;
    }

    @Override
    public Set<Partition> partitions() {
        return this.partitions;
    }

    @Override
    public Duration minBundleTimeout() {
        return this.minBundleTimeout;
    }

    @Override
    @Nullable SubscriberFactory subscriberFactory() {
        return this.subscriberFactory;
    }

    @Override
    @Nullable SerializableSupplier<Committer> committerSupplier() {
        return this.committerSupplier;
    }

    @Override
    @Nullable SerializableSupplier<TopicBacklogReader> backlogReaderSupplier() {
        return this.backlogReaderSupplier;
    }

    @Override
    @Nullable SerializableSupplier<InitialOffsetReader> offsetReaderSupplier() {
        return this.offsetReaderSupplier;
    }

    public String toString() {
        return "SubscriberOptions{subscriptionPath=" + this.subscriptionPath + ", flowControlSettings=" + this.flowControlSettings + ", partitions=" + this.partitions + ", minBundleTimeout=" + this.minBundleTimeout + ", subscriberFactory=" + this.subscriberFactory + ", committerSupplier=" + this.committerSupplier + ", backlogReaderSupplier=" + this.backlogReaderSupplier + ", offsetReaderSupplier=" + this.offsetReaderSupplier + "}";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SubscriberOptions) {
            SubscriberOptions that = (SubscriberOptions)o;
            return this.subscriptionPath.equals(that.subscriptionPath()) && this.flowControlSettings.equals(that.flowControlSettings()) && this.partitions.equals(that.partitions()) && this.minBundleTimeout.equals((Object)that.minBundleTimeout()) && (this.subscriberFactory == null ? that.subscriberFactory() == null : this.subscriberFactory.equals(that.subscriberFactory())) && (this.committerSupplier == null ? that.committerSupplier() == null : this.committerSupplier.equals(that.committerSupplier())) && (this.backlogReaderSupplier == null ? that.backlogReaderSupplier() == null : this.backlogReaderSupplier.equals(that.backlogReaderSupplier())) && (this.offsetReaderSupplier == null ? that.offsetReaderSupplier() == null : this.offsetReaderSupplier.equals(that.offsetReaderSupplier()));
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.subscriptionPath.hashCode();
        h$ *= 1000003;
        h$ ^= this.flowControlSettings.hashCode();
        h$ *= 1000003;
        h$ ^= this.partitions.hashCode();
        h$ *= 1000003;
        h$ ^= this.minBundleTimeout.hashCode();
        h$ *= 1000003;
        h$ ^= this.subscriberFactory == null ? 0 : this.subscriberFactory.hashCode();
        h$ *= 1000003;
        h$ ^= this.committerSupplier == null ? 0 : this.committerSupplier.hashCode();
        h$ *= 1000003;
        h$ ^= this.backlogReaderSupplier == null ? 0 : this.backlogReaderSupplier.hashCode();
        h$ *= 1000003;
        return h$ ^= this.offsetReaderSupplier == null ? 0 : this.offsetReaderSupplier.hashCode();
    }

    @Override
    public SubscriberOptions.Builder toBuilder() {
        return new Builder(this);
    }

    static final class Builder
    extends SubscriberOptions.Builder {
        private SubscriptionPath subscriptionPath;
        private FlowControlSettings flowControlSettings;
        private Set<Partition> partitions;
        private Duration minBundleTimeout;
        private @Nullable SubscriberFactory subscriberFactory;
        private @Nullable SerializableSupplier<Committer> committerSupplier;
        private @Nullable SerializableSupplier<TopicBacklogReader> backlogReaderSupplier;
        private @Nullable SerializableSupplier<InitialOffsetReader> offsetReaderSupplier;

        Builder() {
        }

        private Builder(SubscriberOptions source) {
            this.subscriptionPath = source.subscriptionPath();
            this.flowControlSettings = source.flowControlSettings();
            this.partitions = source.partitions();
            this.minBundleTimeout = source.minBundleTimeout();
            this.subscriberFactory = source.subscriberFactory();
            this.committerSupplier = source.committerSupplier();
            this.backlogReaderSupplier = source.backlogReaderSupplier();
            this.offsetReaderSupplier = source.offsetReaderSupplier();
        }

        @Override
        public SubscriberOptions.Builder setSubscriptionPath(SubscriptionPath subscriptionPath) {
            if (subscriptionPath == null) {
                throw new NullPointerException("Null subscriptionPath");
            }
            this.subscriptionPath = subscriptionPath;
            return this;
        }

        @Override
        public SubscriberOptions.Builder setFlowControlSettings(FlowControlSettings flowControlSettings) {
            if (flowControlSettings == null) {
                throw new NullPointerException("Null flowControlSettings");
            }
            this.flowControlSettings = flowControlSettings;
            return this;
        }

        @Override
        public SubscriberOptions.Builder setPartitions(Set<Partition> partitions) {
            if (partitions == null) {
                throw new NullPointerException("Null partitions");
            }
            this.partitions = partitions;
            return this;
        }

        @Override
        public SubscriberOptions.Builder setMinBundleTimeout(Duration minBundleTimeout) {
            if (minBundleTimeout == null) {
                throw new NullPointerException("Null minBundleTimeout");
            }
            this.minBundleTimeout = minBundleTimeout;
            return this;
        }

        @Override
        SubscriberOptions.Builder setSubscriberFactory(SubscriberFactory subscriberFactory) {
            this.subscriberFactory = subscriberFactory;
            return this;
        }

        @Override
        SubscriberOptions.Builder setCommitterSupplier(SerializableSupplier<Committer> committerSupplier) {
            this.committerSupplier = committerSupplier;
            return this;
        }

        @Override
        SubscriberOptions.Builder setBacklogReaderSupplier(SerializableSupplier<TopicBacklogReader> backlogReaderSupplier) {
            this.backlogReaderSupplier = backlogReaderSupplier;
            return this;
        }

        @Override
        SubscriberOptions.Builder setOffsetReaderSupplier(SerializableSupplier<InitialOffsetReader> offsetReaderSupplier) {
            this.offsetReaderSupplier = offsetReaderSupplier;
            return this;
        }

        @Override
        public SubscriberOptions build() {
            String missing = "";
            if (this.subscriptionPath == null) {
                missing = missing + " subscriptionPath";
            }
            if (this.flowControlSettings == null) {
                missing = missing + " flowControlSettings";
            }
            if (this.partitions == null) {
                missing = missing + " partitions";
            }
            if (this.minBundleTimeout == null) {
                missing = missing + " minBundleTimeout";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_SubscriberOptions(this.subscriptionPath, this.flowControlSettings, this.partitions, this.minBundleTimeout, this.subscriberFactory, this.committerSupplier, this.backlogReaderSupplier, this.offsetReaderSupplier);
        }
    }
}

