/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.healthcare;

import com.google.api.services.healthcare.v1beta1.model.Message;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.CustomCoder;
import org.apache.beam.sdk.coders.MapCoder;
import org.apache.beam.sdk.coders.NullableCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.io.gcp.healthcare.HL7v2Message;

public class HL7v2MessageCoder
extends CustomCoder<HL7v2Message> {
    private static final NullableCoder<String> STRING_CODER = NullableCoder.of((Coder)StringUtf8Coder.of());
    private static final NullableCoder<Map<String, String>> MAP_CODER = NullableCoder.of((Coder)MapCoder.of(STRING_CODER, STRING_CODER));

    HL7v2MessageCoder() {
    }

    public static HL7v2MessageCoder of() {
        return new HL7v2MessageCoder();
    }

    public static HL7v2MessageCoder of(Class<HL7v2Message> clazz) {
        return new HL7v2MessageCoder();
    }

    public void encode(HL7v2Message value, OutputStream outStream) throws CoderException, IOException {
        STRING_CODER.encode((Object)value.getName(), outStream);
        STRING_CODER.encode((Object)value.getMessageType(), outStream);
        STRING_CODER.encode((Object)value.getCreateTime(), outStream);
        STRING_CODER.encode((Object)value.getSendTime(), outStream);
        STRING_CODER.encode((Object)value.getData(), outStream);
        STRING_CODER.encode((Object)value.getSendFacility(), outStream);
        MAP_CODER.encode(value.getLabels(), outStream);
        STRING_CODER.encode((Object)value.getSchematizedData(), outStream);
    }

    public HL7v2Message decode(InputStream inStream) throws CoderException, IOException {
        Message msg = new Message();
        msg.setName((String)STRING_CODER.decode(inStream));
        msg.setMessageType((String)STRING_CODER.decode(inStream));
        msg.setCreateTime((String)STRING_CODER.decode(inStream));
        msg.setSendTime((String)STRING_CODER.decode(inStream));
        msg.setData((String)STRING_CODER.decode(inStream));
        msg.setSendFacility((String)STRING_CODER.decode(inStream));
        msg.setLabels((Map)MAP_CODER.decode(inStream));
        HL7v2Message out = HL7v2Message.fromModel(msg);
        out.setSchematizedData((String)STRING_CODER.decode(inStream));
        return out;
    }
}

