/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import org.apache.beam.sdk.io.gcp.bigquery.StorageApiDynamicDestinations;
import org.apache.beam.sdk.io.gcp.bigquery.TwoLevelMessageConverterCache;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;

public class StorageApiConvertMessages<DestinationT, ElementT>
extends PTransform<PCollection<KV<DestinationT, ElementT>>, PCollection<KV<DestinationT, byte[]>>> {
    private final StorageApiDynamicDestinations<ElementT, DestinationT> dynamicDestinations;

    public StorageApiConvertMessages(StorageApiDynamicDestinations<ElementT, DestinationT> dynamicDestinations) {
        this.dynamicDestinations = dynamicDestinations;
    }

    public PCollection<KV<DestinationT, byte[]>> expand(PCollection<KV<DestinationT, ElementT>> input) {
        String operationName = input.getName() + "/" + this.getName();
        return (PCollection)input.apply("Convert to message", (PTransform)ParDo.of(new ConvertMessagesDoFn<DestinationT, ElementT>(this.dynamicDestinations, operationName)).withSideInputs(this.dynamicDestinations.getSideInputs()));
    }

    public static class ConvertMessagesDoFn<DestinationT, ElementT>
    extends DoFn<KV<DestinationT, ElementT>, KV<DestinationT, byte[]>> {
        private final StorageApiDynamicDestinations<ElementT, DestinationT> dynamicDestinations;
        private TwoLevelMessageConverterCache<DestinationT, ElementT> messageConverters;

        ConvertMessagesDoFn(StorageApiDynamicDestinations<ElementT, DestinationT> dynamicDestinations, String operationName) {
            this.dynamicDestinations = dynamicDestinations;
            this.messageConverters = new TwoLevelMessageConverterCache(operationName);
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c, @DoFn.Element KV<DestinationT, ElementT> element, DoFn.OutputReceiver<KV<DestinationT, byte[]>> o) throws Exception {
            this.dynamicDestinations.setSideInputAccessorFromProcessContext(c);
            StorageApiDynamicDestinations.MessageConverter<ElementT> messageConverter = this.messageConverters.get(element.getKey(), this.dynamicDestinations);
            o.output((Object)KV.of((Object)element.getKey(), (Object)messageConverter.toMessage(element.getValue()).toByteArray()));
        }
    }
}

